<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un Element.
 * Un Elment est l'objet de base de toute entit possedant
 * un identifiant et un libell.
 * 
 * @package element
 */
class Element{
	
	/**
	 * @var integer Identifiant de l'Element
	 */
	var $id;
	
	/**
	 * @var string Libell de l'Element
	 */
	var $libelle;

	/**
	 * Constucteur.
	 * Affecte les attributs de la classe 
	 * partir des paramtres.
	 * La validit de ces parametres est vrifie.
	 * 
	 * @param integer $id Identifiant de l'Element
	 * @param string $libelle Libell de l'Element
	 */
	function Element($id,$libelle){
		messageDebug("Element::Element($id,$libelle)");
		$this->id=$id;
		$this->libelle=$libelle;
		$this->initElement();
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	
	/**
	 * Vrifie les attributs de la classe.
	 * En cas d'attributs invalide, gnre une erreur.
	 */
	function initElement(){
		messageDebug("Element::initElement()");
		if(is_numeric($this->id)&&!empty($this->libelle)){
			
		}else{
			die("Erreur iniElement(): L'objet ne peut etre initialis.(id=".$this->id." libelle=".$this->libelle.")");
		}
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie que l'identifiant est bien null.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		$attributs_ok=true;
		if(!empty($this->id)){
			$message.="[id]";
			$attributs_ok=false;			
		}
		$verif=Element::verify($message);
		return $verif && $attributs_ok;
	}
	
	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() 
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		return Element::verify(&$message);
	}	

	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Le libll doit etre non null.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */	
	function verify(&$message){
		$attributs_ok=true;
		if(empty($this->libelle)){
			$message.="[libelle]";
			$attributs_ok=false;	
		}
		return $attributs_ok;
	}	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	
	function getId(){
		return $this->id;
	}
	
	function getLibelle(){
		//return get_fo_libelle($this->libelle);
		return $this->libelle;
	}
	
	function setId($id) { $this->id=$id ; }
	
	function setLibelle($libelle) { $this->libelle=$libelle ; } 
}
?>