<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Created on 27 mars 2006
 * @author Rmi Cocquet
 * @package element
 * @modulegroup plpgsql
 * @module plpgsql_element
 */
 


/**
 * Savoir si un lment de la base de donnes est utilis dans une table de la plate-forme. 
 * Cette fonction repose sur l'exploitation des liens entre les tables, crs
 * par les contraintes d'intgrit dans les tables systme de PostgreSQL.
 * Elle ne fonctionne que pour le shema "contraintes".
 * 
 * @author Rmi Cocquet
 * @param string nom de la table de l'lment
 * @param string nom de la colonne de l'lment
 * @param integer identifiant de l'lment
 * @return bool TRUE si l'lment est utilis, FALSE sinon
 */
function fk_finder($table, $colonne, $id){
	if (VERSION_BASE > VERSION) {
		
		$req="select * from contraintes.af_fk_finder('".utf8_decode($table)."', '$colonne', $id) ";
		//echo $req."<BR>";
		$res = pg_query($req);
		
	} else{
		print("La fonction af_fk_finder($table, $colonne, $id) n'existe pas pour la version ".VERSION);
	}
	
	return (pg_fetch_result($res,0,0)=="t");	
 	
}


?>
