<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Cette classe dcrit un espace de ressource

La connexion  la base de donnes doit tre $db

@author LADJANI said <sladjani@afide.fr>
@since 18/04/2005

@package espace
*/
class Espace{

        /**
        * @var integer : Identifiant en base de donnes
        */
        var $id ;

        /**
        * @var string : Libell de la capacit
        */
        var $libelle ;

        /**
        * Constructeur de la classe Espace
        * @param integer $num_ou_lib identifiant de l'enregistrement en BD ou string : Libell
        */
        function Espace($num_ou_lib)
        {
            // On determine le type du paramtre  l'aide d'une expression regulire (on reoit toujours une String en php si c'est une rsultat de BD)
                $une_chaine  = ereg("[^0-9]",$num_ou_lib) ;

                // Deux constructions diffrentes selon le type du paramtre ( refaire le jour o on pourra surcharger les fonctions !!!)
                if(!$une_chaine)
                {
                        $this->id = $num_ou_lib ;
                        $result=get_espace($num_ou_lib);
                        $row=pg_fetch_array($result) ;
                        $this->libelle = $row[1] ;


                }
                // Construction  partir d'un nom
                else
                {
                       $this->libelle = $num_ou_lib ;

                }
                
        }

        /**
        * Fonction qui insre un enregistrement en table resoource_esp et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                // On n'insre une ligne que si l'espace n'existe pas dj
                if($this->libelle=="")
                {
                        return (-110) ; // libell vide
                }
                // Le libell est correcte
                else
                {
                        //$lib=addslashes($this->libelle) ;
                        // Cet espace existe-il dj ?
                        //if(pg_num_rows(pg_query("SELECT num_espace FROM ressource_esp WHERE titre='$lib'"))>0)
                        if(check_espace($lib))
                        {
                                return (-111);  //  existe dj
                        }
                        else
                        {
                                //$insertion = "INSERT INTO ressource_esp (titre) VALUES ('$lib')" ;
                                $insertion=set_espace(set_ams_libelle($this->libelle));

                                // On retourne un boolen
                                //if($res = pg_query($insertion))
                                if($insertion)
                                {
                                        /*
                                        $tmp = pg_result(pg_query("SELECT num_espace FROM ressource_esp WHERE titre='$lib'"),0,0) ;
                                        // on retourne l'identifiant de la ligne cre
                                        return($tmp);
                                        */
                                        return $insertion;
                                }
                                else
                                        return (-1) ; // Problme requte
                        }
                }
        }

        /**
        * Fonction qui met  jour l'enregistrement en table ressource_esp
        *

        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function updateToDB()
        {
                // Il faut que l'identifiant soit connu
                if($this->id != 0)
                {
                        //$update = "UPDATE ressource_esp SET titre = '".addslashes($this->libelle)."' WHERE num_espace=$this->id" ;
                        //$lib=addslashes($this->libelle) ;
                        $update=maj_espace($this->id,set_ams_libelle($this->libelle));

                        // echo "Class Titrecapacite : updateToDB. Requete =<br>$update<br>" ;

                        // On retourne un boolen
                        //if(pg_query($update))
                        if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }

        /**
        * Procdure qui supprime l'enregistrement en base
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */
        function deleteToDB(){
            // Il faut que l'identifiant soit connu
            if($this->id != 0){

                // suppression de la grille
                if(del_espace($this->id)){
                    return true;
                }
                else
                    return -1;  // erreur base de donnes
            }
            else{
                // Identifiant inconnu : suppression impossible
                return -2;
            }
        }


		function getLibelle(){
			return $this->libelle ;
		}
        function getId() { return $this->id ; }


}
?>