<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

 /**

       @package espace
       @modulegroup plpgsql
       @module plpgsql_espace
*/



/*-----------------------------------------------------------------------------------------*/
//                         LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL
/*-----------------------------------------------------------------------------------------*/
/*
                            DOIVENT RETOURNER UNE VARIABLE
*/
/*
CONVENTION DE NOMAGE :
Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
 la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
Exemple:

la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base

*/


/**
*   Supprimer un espace.  (OLD)
*
*   Supprime l'espace

*
*   @param integer : numero de l'espace  supprimer
*   @return integer : 1
*/
function del_espace_old($espace){


    // suppression du titre de l'espace
    $del=pg_query("delete from ressource_esp where num_espace=$espace;");

    return 1;
}

/**
*   Supprimer un espace.
*
*   Supprime l'espace
*
*   @param integer : numero de l'espace  supprimer
*   @return integer : 1
*/
function del_espace($espace){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_espace($espace)";
		$res=pg_query($sql);
	}
	else
		$res=del_espace_old($espace);
	return ($res);
}

/**
*   Supprimer un espace des ressources d'une formation.  (OLD)
*
*   Supprime l'espace

*
*   @param integer : numero de l'espace  supprimer
*   @param integer : numero de la formation
*   @return integer : 1
*/
function del_espace_ressource_old($formation,$espace){


    // suppression  l'espace
    $del=pg_query("delete from ressource_gest where num_espace=$espace and num_cal=$formation;");

    return 1;
}

/**
*   Supprimer un espace des ressources d'une formation.
*
*   Supprime l'espace
*
*   @param integer : numero de l'espace  supprimer
*   @param integer : numero de la formation
*   @return integer : 1
*/
function del_espace_ressource($formation,$espace){
	if(VERSION_BASE>VERSION){
	print("A IMPLEMENTER");
	}
	else
		$res=del_espace_ressource_old($formation,$espace);
	return ($res);
}

/**
*   Obtenir le titre d'un espace (OLD)
*
    @deprecated : utiliser get_espace($espace)
*   @param integer : le numro de l'espace
*   @return string : le titre de l'espace
*/
function get_espace_titre_old($espace){
    $sql="select titre from ressource_esp where num_espace=$espace";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
*   Obtenir le titre d'un espace
*
    @deprecated : utiliser get_espace($espace)
*   @param integer : le numro de l'espace
*   @return string : le titre de l'espace
*/
function get_espace_titre($espace){
     if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
     }
     else
        $res=get_espace_titre_old($espace);
     return ($res);
}

/**
*   Obtenir le titre d'un espace (OLD)
*
*   @param integer : le numro de l'espace
*    @return integer : resultat de la requete (id int4,libelle varchar)
*/
function get_espace_old($espace){
    $sql="select num_espace, titre from ressource_esp where num_espace=$espace";
    return pg_query($sql);

}
/**
*   Obtenir le titre d'un espace
*
*   @param integer : le numro de l'espace
*   @return integer : resultat de la requete (id int4,libelle varchar)
*/
function get_espace($espace){
     if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_espace($espace) as (id int4,libelle varchar)";
		$res=pg_query($sql);
     }
     else
        $res=get_espace_old($espace);
     return ($res);
}

///**
//*   Obtenir les sections d'un espace pour une formation (OLD)
//*
//*   @param integer : le numero de l'espace
//*   @param integer : le numero de formation
//*   @return integer : le resultat de la requete
//*/
//function get_espace_sections_infos_formation_old($espace,$formation){
//    $sql="select * from ressource_sec where num_section in
//            (select num_section from ressource_gest where num_cal=$formation and num_espace=$espace)";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir les sections d'un espace pour une formation
//*
//*   @param integer : le numero de l'espace
//*   @param integer : le numero de formation
//*   @return integer : le resultat de la requete
//*/
//function get_espace_sections_infos_formation($espace,$formation){
//    if(VERSION_BASE>VERSION){
//        print("A IMPLEMENTER");
//     }
//     else
//        $res=get_espace_sections_infos_formation_old($espace,$formation);
//     return ($res);
//}

/**
    Verifie si un espace existe deja (OLD)

    @param string : le nom de l'espace
    @return bool : true si existe,false sinon
*/
function check_espace_old($libelle){
    $sql="SELECT num_espace FROM ressource_esp WHERE titre='$libelle'";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    return true;
}
/**
    Verifie si un espace existe deja 

    @param string : le nom de l'espace
    @return bool : true si existe,false sinon
*/
function check_espace($libelle){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
     }
     else
        $res=check_espace_old($libelle);
     return ($res);
}

/**
    Enregistre un espace (OLD)

    @param string : le nom de l'espace
    @return integer : le numero de l'espace, 0 si erreur
*/
function set_espace_old($libelle){
    $sql="INSERT INTO ressource_esp (titre) VALUES ('$libelle')" ;
    $ins=pg_query($sql);
    if($ins){
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_espace from ressource_esp where oid=$oid");
        return pg_result($res, 0, 0);
    }
    else
        return 0;
}
/**
    Enregistre un espace

    @param string : le nom de l'espace
    @return integer : le numero de l'espace, 0 si erreur
*/
function set_espace($libelle){
     if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_espace('$libelle')";
		$res=pg_query($sql);
     }
     else
        $res=set_espace_old($libelle);
     return ($res);
}

/**
    Mettre  jour un espace  (OLD)

    @param integer : le numero d'espace
    @param string : le nom de l'espace
    @return integer : le resultat de la requete
*/
function maj_espace_old($espace,$libelle){
    $sql="UPDATE ressource_esp SET titre = '$libelle' WHERE num_espace=$espace" ;
    return pg_query($sql);
}
/**
    Mettre  jour un espace

    @param integer : le numero d'espace
    @param string : le nom de l'espace
    @return integer : le resultat de la requete
*/
function maj_espace($espace,$libelle){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_maj_espace($espace,'$libelle')";
		$res=pg_query($sql);
     }
     else
        $res=maj_espace_old($espace,$libelle);
     return ($res);
}

/**
	Teste si un espace est supprimable (OLD)
	@param integer : numero espace
	@return bool : true supprimable,sinon false
*/
function check_espace_supprimable_old($espace){
	 // on regarde si l'espace est utilis
	$req = "select * from ressource_gest where num_espace=$espace";
	$res = pg_exec($req);
	if (pg_numrows($res) == 0)
		return true;
	else
		return false;
}
/**
	Teste si un espace est supprimable 
	@param integer : numero espace
	@return bool : true supprimable,sinon false
*/
function check_espace_supprimable($espace){
	 if(VERSION_BASE>VERSION){
		$res=!fk_finder('espace','id',$espace);
	 }
	 else
		$res=check_espace_supprimable_old($espace);
	 return $res;
}
?>