<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoEtapeDynamique.
 * Un DoEtapeDynamique est un DoEtape possedant une mthode, perform(), qui est appele automatiquement pour commencer le DoEtapeDynamique,
 * et donc effectuer des traitements spcifiques 
 * 
 * CLASSE ABSTRAITE
 * 
 * @package parcours
 */
class DoEtapeDynamique extends DoEtape{

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'Exotlc
	 */	
	 function DoEtapeDynamique($formation,$individu){
		messageDebug("DoEtapeDynamique:: DoEtapeDynamique()");
		parent::DoEtape($formation,$individu);
	 }
	 
	 /**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * 
	 * @param integer $parcours Identifiant du parcours courant.
	 * @param integer $etape Identifiant de l'tape courante.
	 * @param object EtapeFactory &$obj_EtapeFactory La fabrique d'objet Etape.
	 */		
	function initDoEtapeDynamique($parcours,$etape,$obj_EtapeFactory){
		messageDebug("DoEtapeTitre::initDoEtapeTitre($parcours,$etape)");
		parent::initDoEtape($parcours,$etape, TYPE_ETAPE_TITRE);
		//$this->beginCurrentEtape($obj_EtapeFactory);
	}
	/**
	 * METHODE ABSTRAITE
	 * Appele automatiquement par l'objet d'avancement, cette mthode permet d'effectuer des traitements spcifiques 
	 * (Saut de l'tape titre, etc...)
	 * Cette mthode doit etre surcharge.
	 * @param object &$obj_elementEntity DoElementEntity L'objet d'avancement 
	 */
	function perform(&$obj_elementEntity){
		messageDebug("DoParcoursDynamique::perform()");
		die("Erreur: Mthode abstraite a surcharger.");
	}
	 
	 
	
}

?>