<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets d'avancement pour les Etapes.
 * 
 * La fabrique doit �tre initialis�e avec des identifiants de Formation, d'Individu ainsi qu'avec une
 * fabrique permettant de cr�er les objets associ�s aux objets d'avancement.
 * 
 * Cet objet permet ensuite d'obtenir, par la m�thode createDoEtape(), un objet d'avancement pour le Parcours et l'Etape sp�cifi�e.
 * 
 * @package etape
 */
class DoEtapeFactory extends DoNodeFactory{
	
	/**
	 * Constructeur de la fabrique.
	 * @param integer $formation Identifiant de la formation.
	 * @param integer $individu Identifiant de l'individu.
	 * @param object EtapeFactory $obj_EtapeFactory Fabrique des objets associ�s aux objets d'avancement. 
	 */
	function DoEtapeFactory($formation,$individu,&$obj_EtapeFactory){
		messageDebug("DoEtapeFactory::DoEtapeFactory($formation,$individu,&\$obj_EtapeFactory)");
		parent::DoNodeFactory($formation,$individu,&$obj_EtapeFactory);
	}
	
	/**
	 * Cr�e un objet d'avancement pour une Etape.
	 * @param integer $parcours identifiant du parcours de l'�tape.
	 * @param integer $etape identifiant de l'�tape.
	 * @param integer $type identifiant du type de l'�tape. Facultatif: si non valu�, le type est calcul�. Le type doit etre de niveau 1.
	 * 
	 * @return  object DoEtape  l'objet d'avancement d�sir�
	 */
	function &createDoEtape($parcours,$etape,$type=0){
		global $root;
		messageDebug("DoEtapeFactory::createDoEtape($parcours,$etape,$type)");
		
		//au cas ou le type n'est pas connu on le recherche.
		if(empty ($type)){
			$type= pg_fetch_result(get_etape($etape),0,2);
		}
//		include_once("../../config_types.php");
		switch($type){
			case TYPE_ETAPE_PARCOURS_ATTACHE:
				$obj_new_etape= new DoParcoursAttache($this->formation,$this->individu,$parcours,$etape,$this);
				break;
				
			case TYPE_ETAPE_FORUM:
				$obj_new_etape= new DoEtapeForum($this->formation,$this->individu,$parcours,$etape);
				break;
				
			case TYPE_ETAPE_SCORM:
				$obj_new_etape= new DoScorm($this->formation,$this->individu,$parcours,$etape);
				break;
				
			case TYPE_ETAPE_LISTE:
				$res_liste=get_liste($etape);
				$type_liste=pg_fetch_result($res_liste,0,2);
				switch($type_liste){
					case TYPE_LISTE_SERIE:
						$res=get_serie_aleatoire($etape);
						$type_serie=pg_fetch_result($res,0,4);
//						echo "ty=$type_serie et etape=$etape<br>";
						switch($type_serie){
							case TYPE_SERIE_ALEATOIRE_MULTISERIE :
								$obj_new_etape= new DoSerieAleatoireMultiserie($this->formation,$this->individu,$parcours,$etape,new DoEvaluationFactory($this->formation,$this->individu, new EvaluationFactory()));
							break;
							case TYPE_SERIE_ALEATOIRE_MULTITHEME :
								$obj_new_etape= new DoSerieAleatoireMultitheme($this->formation,$this->individu,$parcours,$etape,new DoEvaluationFactory($this->formation,$this->individu, new EvaluationFactory()));
							break;
							
							default :
								if(is_serie_aleatoire_melangee($etape, $this->formation,$parcours))
									 $obj_new_etape= new DoSerieAleatoireMelangee($this->formation,$this->individu,$parcours,$etape,new DoEvaluationFactory($this->formation,$this->individu, new EvaluationFactory()));
								else
									$obj_new_etape= new DoSerie($this->formation,$this->individu,$parcours,$etape,new DoEvaluationFactory($this->formation,$this->individu, new EvaluationFactory()));
						}
						break;
					case TYPE_LISTE_TEST:
						$obj_new_etape= new DoTest($this->formation,$this->individu,$parcours,$etape,new DoEvaluationFactory($this->formation,$this->individu, new EvaluationFactory()));
						break;
					default:
						die("Erreur createDoEtape($parcours,$etape,$type): Le type de Liste '$type_liste' est inconnu.<br>");				
				}
				break;
				
			case TYPE_ETAPE_EXOTLC;
				$res_exotlc=get_exotlc($etape);
//				$row_exotlc=pg_fetch_row($res_exotlc);
//				print_rr($row_exotlc);
				$type_exotlc=pg_fetch_result($res_exotlc,0,7);
				switch($type_exotlc){
					case TYPE_EXOTLC_MAIL;
						$obj_new_etape= new DoExotlcMail($this->formation,$this->individu,$parcours,$etape,new DoExotlcFactory($this->formation,$this->individu, new EvaluationFactory()));
						break;
					case TYPE_EXOTLC_PLATEFORME;
						$obj_new_etape= new DoExotlcPlateforme($this->formation,$this->individu,$parcours,$etape,new DoExotlcFactory($this->formation,$this->individu, new EvaluationFactory()));
						break;
					default:
						die("Erreur createDoEtape($parcours,$etape,$type): Le type de Exotlc '$type_liste' est inconnu.<br>");				
				}
				break;
				
			case TYPE_ETAPE_SCENARIO;
				$obj_new_etape= new DoScenario($this->formation,$this->individu,$parcours,$etape);
				break;
				
			case TYPE_ETAPE_RESSOURCE;
				$obj_new_etape= new DoEtapeRessource($this->formation,$this->individu,$parcours,$etape);
				break;
				
			case TYPE_ETAPE_CHAT;
				$obj_new_etape= new DoEtapeChat($this->formation,$this->individu,$parcours,$etape);
				break;
				
			case TYPE_ETAPE_TITRE;
				$obj_new_etape= new DoEtapeTitre($this->formation,$this->individu,$parcours,$etape,$this->getEtapeFactory());
				break;
				
			case TYPE_ETAPE_PARCOURS_ORIENTE;
				
				$obj_new_etape= new DoParcoursOriente($this->formation,$this->individu,$parcours,$etape,$this);
				break;

			case TYPE_ETAPE_SCENARIO_DYNAMIQUE;
					$obj_new_etape=new DoScenarioDynamique($this->formation,$this->individu,$parcours,$etape);
					
				 
				break;				
			default:
				die("Erreur createDoEtape($parcours,$etape,$type): Le type '$type' est inconnu.<br>");		
				
																						
		}
		if(is_object($obj_new_etape))
			return $obj_new_etape;
		else
			return false;
	}
	
	/**
	 * Obtenir la fabrique des objets associ�s (Etapes).
	 * @return  object EtapeFactory la fabrique des objets associ�s aux objets d'avancement de cette fabrique.
	 */
	function &getEtapeFactory(){
		return parent::getNodeFactory();
	}
}
?>
