<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoEtapeRenewable.
 * Un DoEtapeRenewable est l'objet de base servant  gerer l'avancement des
 * Etapes d'un parcours, avec la particularit que ces tapes peuvent etre
 * faites plusieurs fois.
 * Ainsi, les dures des diffrents accs  ces tapes sont cumules, et aucune
 * erreur n'est gnre lors de plusieurs appels aux mthodes beginCurrentEtape() et endCurrentEtape().
 *   
 * @package etape
 */
class DoEtapeRenewable extends DoEtape{

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 */
	function DoEtapeRenewable($formation,$individu){
		messageDebug("DoEtapeRenewable::DoEtapeRenewable($formation,$individu)");
		parent::DoEtape($formation, $individu);
	}
	
	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * @param integer $parcours Identifiant du parcours courant.
	 * @param integer $etape Identifiant de l'tape courante.
	 * @param integer $type Identifiant du type de l'tape courante.
	 */
	function initDoEtapeRenewable($parcours,$etape, $type){
		
		messageDebug("DoEtapeRenewable::initDoEtapeRenewable($parcours,$etape, $type)");
		parent::initDoEtape($parcours,$etape, $type);
		$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
		if(pg_num_rows($res_resultat)==1){
			$row_resultat=pg_fetch_row($res_resultat);
			//print_rr($row_resultat);
			$id_resultat=$row_resultat[0];
			if(!empty($id_resultat)){
			$this->resultat=$id_resultat;
			$this->debut=$row_resultat[5];
			$this->duree=$row_resultat[6];
			}
		}
		
	}
	
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	
	/**
	 * Dbut de l'tape.
	 * Initialise l'avancement de l'tape courante.
	 * Cration de l'identifiant rsultat et enregistrement de la date de dbut de l'tape.
	 * Si la mthode est rappele par la suite, l'identifiant rsultat cr lors du 1er appel  cette mthode
	 * est rcupr et la date de dbut est mise  jour.
	 * @return integer idenfiant rsultat en base de donnes
	 */
	function beginCurrentEtape(){
		messageDebug("DoEtapeRenewable::beginCurrentEtape()");
		if(empty($this->resultat)){
			$this->resultat=set_resultat_debut($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape() );
		}else{
			maj_resultat_debut($this->resultat);
		}
		return $this->resultat;
	}
	
	/**
	 * Construction de l'objet associ  l'tape.
	 * La mthode beginCurrentEtape() doit avoir t appelle au moins 1 fois auparavent.
	 * @return object Etape : L'objet correspondant  l'tape (au DoNode) 
	 */
	function &performCurrentEtape(&$obj_NodeFactory){
		messageDebug("DoEtapeRenewable::performCurrentEtape(\$obj_NodeFactory)");
		return parent::performCurrentEtape($obj_NodeFactory);

	}
	
	/**
	 * Termine l'tape.
	 * Enregistre et met  jour la dure de l'tape (cumul des dures) et detruit les attributs de l'objet inutiles (resultat et obj_node).
	 * @param object ResultatEtape $obj_resultat  Resultat associ  l'objet associ  l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succs ou non de la mthode.
	 */
	function endCurrentEtape($obj_resultat=null){
		
		messageDebug(" DoEtapeRenewable::endCurrentEtape($obj_resultat)");
		if(!empty($this->resultat)){
			$row_resultat_etape=get_resultat($this->resultat);	
			if(!empty($row_resultat_etape[6])){		
				$this->duree=maj_resultat_fin($this->resultat);
			}else{
				$this->duree=set_resultat_fin($this->resultat);
			}
			if(empty($this->duree)){
				die("Erreur DoEtapeRenewable::endCurrentEtape(): L'tape n'a pas t termine.<br>");
				return false;
			}
			return true;
		}
		die("Erreur DoEtapeRenewable::endCurrentEtape(): L'tape ne peut tre termine car elle n'a pas t commence.<br>");
		return false;
		
	}	
	
	/**
	 * Indique que l'Etape n'est jamais finie.
	 * @return boolean Toujours false. 
	 */
	function isEnd(){
		return false;	
	}
}
?>
