<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Etape.
 *	Une Etape est un objet driv de Node. 
 *	Les Etapes sont des lments de Parcours.
 *
 *	@package etape
 */
class Etape extends Node{

	/**
	 * Construit une Etape.
	 * L'Etape peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de l'Etape
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 * @param integer $type Type d'Etape
	 */
	function Etape($id, $libelle="Etape ", $date_creation="27.11.2006", $type=0){
		messageDebug("Etape::Etape($id, $libelle, $date_creation, $type)");
		if(func_num_args()==1){
			$res_etape=get_etape($id);
			$row_etape=pg_fetch_row($res_etape);
			//print_rr($row_etape);
			$libelle=$row_etape[1];
			$type=$row_etape[2];
			$date_creation=$row_etape[3];
		}else{
		}
		
		parent::Node($id, $libelle, $type,$date_creation);
	}

	/**
	 * Initialise les attributs propres  l'Etape.
	 * Ne fait rien.
	 */			
	function initEtape(){
		messageDebug("Etape::initEtape()");
	}
	
	
	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string Le nom du fichier icone
	 */
	function getIcone(){
		global $serverback;
		return "http://$serverback/bo/images/txt.gif";
	}

	/**
	 * Obtenir l'icone associe au type de l'Etape.
	 * @return string L'URL de l'icone
	 */	
	function getIconeType(){
		return get_etape_type_icone($this->type);
	}
	
	/**
	 * Indique si l'Etape peut donner lieu  une correction.
	 * Retourne toujours false, car une tape ne retourne pas de correction par dfaut.
	 * @return boolean true si l'Etape donne lieu  une correction, false sinon.
	 */
	function isCorrectable(){
		return false;
	}	


	/**
	 * Indique si l'Etape peut possder son propre chrono.
	 * Retourne toujours false, car une tape ne possede pas de chrono par dfaut.
	 * @return boolean true si l'Etape donne lieu  un chrono, false sinon.
	 */
	function isChronometrable(){
		return false;
	}		
}
?>