<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class EtapeCorrection{
	
	var $obj_DoEtape;
	
	var $resultat;
	
	var $debut;
	
	var $duree;
	
	/**
	 * @param object EtapeFactory $obj_EtapeFactory La fabrique pour constuire l'objet retourn
	 */
	function EtapeCorrection($obj_DoEtape){
		messageDebug("EtapeCorrection::EtapeCorrection($obj_EtapeFactory,$obj_DoEtape)");
		$this->obj_DoEtape=$obj_DoEtape;
		$this->initEtapeCorrection();
	}
	
	function initEtapeCorrection(){
		$this->resultat=$this->obj_DoEtape->getResultat();
		if(!empty($this->resultat)){
			$row_resultat=get_resultat($this->resultat);
			$this->resultat=$row_resultat[0];
			$this->debut=$row_resultat[5];
			$this->duree=$row_resultat[6];
		}else{
			$res_resultat=get_resultat_etape($this->obj_DoEtape->getFormation(), $this->obj_DoEtape->getIndividu(), $this->obj_DoEtape->getParcours(), $this->obj_DoEtape->getEtape());
			if($res_resultat&&pg_num_rows($res_resultat)==1){
				$row_resultat=pg_fetch_row($res_resultat);
				$this->resultat=$row_resultat[0];
				$this->debut=$row_resultat[5];
				$this->duree=$row_resultat[6];
			}
			else{
				die("Erreur EtapeCorrection::EtapeCorrection($obj_DoEtape): L'objet d'avancement ne possde pas d'identifiant de rsultat.(Le DoEtape a-t-il bien t commenc?)");
			}
		}
	}
	
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir l'identifiant du parcours pourlequel l'objet d'avancement est utilis.
	 * @return integer identifiant du parcours
	 */
	function getParcours(){
		return $this->obj_DoEtape->getParcours();
	}
	
	/**
	 * Obtenir l'identifiant de la formation pour laquelle l'objet d'avancement est utilis.
	 * @return integer identifiant de la formation
	 */
	function getFormation(){
		return $this->obj_DoEtape->getFormation();
	}

	/**
	 * Obtenir le type de l'tape 
	 * @return integer le type de l'objet d'avancement
	 */	
	function getType(){
		return $this->obj_DoEtape->getType();
	}
		
	function getDebut(){
		return $this->debut;
	}
	
	function getDebutFormate(){
		return sql2StringTimestamp($this->getDebut());
	}
	
	function getDuree(){
		return $this->duree;
	}
	
	/**
	 * Obtenir l'identifiant resultat en base de donnes.
	 * @return integer l'identifiant resultat en base de donnes.
	 */	
	function getResultat(){
		return $this->resultat;
	}
	
	function getDureeFormate(){
    	return sql_interval_to_string($this->getDuree());
    }
    	
	function getDoEtape(){
		return $this->obj_DoEtape;
	}
	
	/**
	 * Obtenir l'objet Etape.
	 * @return object Etape l'objet correspondant  l'tape
	 */	
	function getEtape($obj_EtapeFactory){
		return $this->obj_DoEtape->getSrcEtape($obj_EtapeFactory);
	}
	
	function getBareme(){
		return null;
	}
	
	/**
	 * 
	 * Obtenir l'identifiant de l'tape 
	 * @return integer l'identifiant de l'tape 
	 */		
	function getId(){
		return $this->obj_DoEtape->getEtape();
	}

}
?>
