<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets de correction pour les Etapes.
 * 
 * @package etape
 */
class EtapeCorrectionFactory{
	
	/**
	 * Constructeur de la fabrique.
	 * Ne fait rien.
	 */
	function EtapeCorrectionFactory(){
		messageDebug("EtapeCorrectionFactory::EtapeCorrectionFactory()");
	}
	
	/**
	 * Cre un objet EtapeCorrection.
	 * @param DoEtape $obj_DoEtape Objet d'avancement de l'tape que l'on souhaite crer
	 * @return object EtapeCorrection l'objet de correction souhait.
	 */
	function &createEtapeCorrection($obj_DoEtape){
		messageDebug("EtapeCorrectionFactory::createEtapeCorrection($obj_DoEtape)");
		if(!is_object($obj_DoEtape)){
			//die("EtapeCorrectionFactory::createEtapeCorrection($obj_DoEtape): l'objet pass en parametre est invalide.");
			return null;
		}
		$type=get_etape_type_formate($obj_DoEtape->getType(),1);
//		echo "\$type=$type<br>";
		switch($type){
			
			case TYPE_ETAPE_LISTE:
				$res_liste=get_liste($obj_DoEtape->getEtape());
				$type_liste=pg_fetch_result($res_liste,0,2);
				switch($type_liste){
					case TYPE_LISTE_SERIE:
						$res=get_serie_aleatoire($obj_DoEtape->getEtape());
						$type_serie=pg_fetch_result($res,0,4);
						//echo "\$type_serie=$type_serie";
						 switch($type_serie){
							case TYPE_SERIE_ALEATOIRE_MULTISERIE :
							case TYPE_SERIE_ALEATOIRE_MULTITHEME :
							//case TYPE_SERIE_ALEATOIRE_MELANGEE:
								// si type 1 alors on teste si aleatoire pour cette formation et ce parcours
								/*
								if(is_serie_aleatoire_melangee($obj_DoEtape->getEtape(),$obj_DoEtape->getFormation(),$obj_DoEtape->getParcours()))
									return new SerieCorrection($obj_DoEtape);
								else 
									return new SerieAleatoireCorrection($obj_DoEtape);
								*/
								return new SerieAleatoireCorrection($obj_DoEtape);
								
							default :
							$tentative=$obj_DoEtape->isNouvelleTentative(); // OK Le test fonctionne
							
						/*	if($tentative==1)
								return new SerieCorrectionTentative($obj_DoEtape);
							else*/
						 
								return new SerieCorrection($obj_DoEtape);
						}
					case TYPE_LISTE_TEST:
						
						return new TestCorrection($obj_DoEtape);
					default:
						die("Erreur EtapeCorrectionFactory::createEtapeCorrection($obj_DoEtape): Le type de Liste '".$obj_DoEtape->getType()."' est inconnu.<br>");				
				}
				return new ListeCorrection($obj_DoEtape);
			case TYPE_ETAPE_EXOTLC:
				return new ExotlcCorrection($obj_DoEtape);//ExotlcFactory::createExoTlcCorrection($obj_DoEtape);
			default:
				die("Erreur EtapeCorrectionFactory::createEtapeCorrection($obj_DoEtape): Le type '".$obj_DoEtape->getType()."' est inconnu.<br>");																				
		}
		
	}
}
?>
