<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets Etapes.
 * 
 * Cet objet permet d'obtenir, par la m�thode createEtape(), un objet Etape correspondant � un objet d'avancement ou
 * � une �tape (identifiant+type) particuli�re.
 * 
 * @package etape
 */
class EtapeFactory extends NodeFactory{
	
	/**
	 * Constructeur de la fabrique.
	 * Ne fait rien.
	 */
	function EtapeFactory(){
		messageDebug("EtapeFactory::EtapeFactory()");
	}
	
	/**
	 * Cr�e un objet Etape.
	 * @param DoEtape $param1 Objet d'avancement de l'�tape que l'on souhaite cr�er ou identifiant de l'�tape (Integer)
	 * @param integer $param2 type de l'�tape (Uniquement si le 1er parametre est un identifiant)
	 * @return object Etape l'objet Etape souhait�.
	 */
	function &createEtape($param1, $param2=0){
		messageDebug("EtapeFactory::createEtape(\$param1, $param2)");
		if(is_object($param1)){
			if(!empty($param2)){
				die("Erreur EtapeFactory::createEtape($param1, $param2): param�tres incorrects.");
			}
			$etape=$param1->getEtape();
			$type=$param1->getType();
			$formation=$param1->getFormation();
			$parcours=$param1->getParcours();
			$individu=$param1->getIndividu();
		}
		else{
			$etape=$param1;
			$type=$param2;
		}
		if(empty($etape)||empty($type)){
			die("EtapeFactory::createEtape($param1, $param2): l'objet pass� en parametre est invalide.");
		}
		$type_court=get_etape_type_formate($type,1);
		//echo "type=$type_court<br>";
		switch($type_court){
			case TYPE_ETAPE_PARCOURS_ATTACHE:
				return new ParcoursAttache($etape);
				break;
			case TYPE_ETAPE_FORUM:
				return new EtapeForum($etape);
				break;
			case TYPE_ETAPE_SCORM:
				return new Scorm($etape);
				break;
			case TYPE_ETAPE_LISTE:
				$res_liste=get_liste($etape);
				$type_liste=pg_fetch_result($res_liste,0,2);
				switch($type_liste){
					case TYPE_LISTE_SERIE:
						$res=get_serie_aleatoire($etape);
						$row=pg_fetch_row($res,0);
						$type_serie=pg_fetch_result($res,0,4);
						if(!empty($formation)&& !empty($parcours)&&!empty($individu)){
							switch($type_serie){
								case TYPE_SERIE_ALEATOIRE_MULTISERIE :
									return new SerieAleatoireMultiserie($etape,$formation,$parcours,$individu,$row[1],$row[5],$row[2],$row[3]);
								break;
								case TYPE_SERIE_ALEATOIRE_MULTITHEME :
									  return new SerieAleatoireMultitheme($etape,$formation,$parcours,$individu,$row[1],$row[5],$row[2],$row[3]);
								break;
								
								
								default :
									if(is_serie_aleatoire_melangee($etape, $formation,$parcours))
										 return new SerieAleatoireMelangee($etape,$formation,$parcours,$individu,$row[1],$row[5],$row[2],$row[3]); 
									else
										return new Serie($etape);
							}
						}else{
							return new Serie($etape);
						}
					break;
					case TYPE_LISTE_TEST:
						return new Test($etape);
						break;
					default:
						die("Erreur createEtape($etape,$type): Le type de Liste '$type_liste' est inconnu.<br>");				
				}
				return new Liste($etape);
				break;
			case TYPE_ETAPE_EXOTLC:
				return ExotlcFactory::createExoTlc($etape);
				break;
			case TYPE_ETAPE_SCENARIO:
				return new Scenario($etape);
				break;
			case TYPE_ETAPE_SCENARIO_DYNAMIQUE:
				$obj_new_etape= new ScenarioDynamique($etape);
				if(is_object($obj_new_etape))return $obj_new_etape;
				else return null;
				break;
			case TYPE_ETAPE_RESSOURCE:
				return new EtapeRessource($etape);
				break;
			case TYPE_ETAPE_CHAT:
				return new EtapeChat($etape);
				break;
			case TYPE_ETAPE_TITRE:
				return new EtapeTitre($etape);
				break;
			case TYPE_ETAPE_PARCOURS_ORIENTE:
				return new ParcoursOriente($etape);
				break;
			default:
				die("Erreur createEtape($param1, $param2): Le type '$type_court' est inconnu.<br>");																				
		}
		
	}
}
?>