<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets ResultatEtape.
 * 
 * Cette fabrique permet d'obtenir, par la mthode createResultatEtape(), un objet Resultat correspondant  un type d'tape.
 * Ses attibuts varient selon le type d'tape et il doit ensuite etre correctement initialis afin de pouvoir tre pass
 * en parametre des methodes endCurrentEtape().
 * 
 * @package etape
 */
class ResultatEtapeFactory extends ResultatFactory {
	
	/**
	 * Constructeur de la fabrique.
	 * Ne fait rien.
	 */
	function ResultatEtapeFactory(){
		messageDebug("ResultatEtapeFactory::ResultatEtapeFactory()");
	}
	
	/**
	 * Cre un objet Resultat
	 * @param integer $type type d'tape pour lequel l'objet ResultatEtape est requis.
	 * @return object ResultatEtape l'objet ResultatEtape souhait.
	 */
	function &createResultatEtape($type){
		messageDebug("ResultatEtapeFactory::createResultatEtape($type)");
		switch($type){
			case TYPE_ETAPE_EXOTLC."_".TYPE_EXOTLC_PLATEFORME;
				return new ResultatExotlcPlateforme();
				break;
			case TYPE_ETAPE_EXOTLC;
				return null;
				break;				
			case TYPE_ETAPE_SCENARIO;
				return null;
				break;
			case TYPE_ETAPE_SCENARIO_DYNAMIQUE;
				return null;
				break;				
			case TYPE_ETAPE_RESSOURCE;
				return null;
				break;
				
			case TYPE_ETAPE_CHAT;
				return null;
				break;
				
			case TYPE_ETAPE_FORUM;
				return null;
				break;
				
			case TYPE_ETAPE_TITRE;
				return null;
				break;
				
			default:
				die("ResultatEtapeFactory::createResultatEtape($type): Le type '$type' est inconnu.<br>");																				
		}
		
	}
}
?>
