<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package etape
 * @modulegroup fonctions
 */

/**
 * Retourne le type d'tape  partir du code (lettre).
 * Le code peut etre T,F,Z,Q,B,C,L, E,S, R,P,I ou O.
 * La valeur retourne depend du shema de la base.
 * Renvoie le code si on est sur l'ancienne base, le numero si on est sur la nouvelle.
 * @param varchar: le code du type
 * @return interger : l'entier correspondant au code ou  le code lui meme.
 */
function get_etape_type_old_new($old_type) {
	if (VERSION_BASE > VERSION) {
		switch ($old_type) {
			case "T" : //etape parcours
				return 1;
			case "F" : //Forum
				return 2;
			case "Z" : //Scorm
				return 3;
			case "B" : //srie
			case "C" : //serie alatoire
			case "L" : //test d'autopositionnement
				return 4;
			case "E" : //exotlc
				return 5;
			case "S" : //Scnario
				return 6;
			case "R" : //Ressource
				return 7;
			case "P" : //Chat
				return 8;
			case "I" : //Etape titre
				return 9;
			case "O" : //parcours oriente
				return 10;
			default :
				return $old_type;
		}
	} else {
		return $old_type;
	}
}

/**
 * Retourne le type d'tape  partir du numero (nouvelle base).
 * Le code retourn peut etre  T,F,Z,QBCL,E,S, R,P,I ou O.
 * La valeur retourner depend du shema de la base.
 * Renvoie le numero si on est sur la nouvelle base, le code si on est sur l'ancienne.
 * @param integer: le code du type
 * @return varchar : le code correspondant a l'entier ou  l'entier lui meme.
 */
function get_etape_type_new_old($new_type) {
	if (VERSION_BASE > VERSION) {
		switch ($new_type) {
			case 1 :
				return "T";
			case 2 :
				return "F";
			case 3 :
				return "Z";
			case 4 :
				return "Q";
			case 5 :
				return "E";
			case 6 :
				return "S";
			case 7 :
				return "R";
			case 8 :
				return "P";
			case 9 :
				return "I";
			case 10 :
				return "O";
			default :
				return $new_type;
		}
	} else {
		return $new_type;
	}
}

function get_etape_type_libelle($type) {
global $MSG_113,$MSG_922,$MSG_727,$MSG_1267,$MSG_2040,$MSG_2041,$MSG_2042
,$MSG_2043,$MSG_2044,$MSG_2045,$MSG_2046,$MSG_2047,$MSG_2048
,$MSG_2049,$MSG_2050,$MSG_2051,$MSG_2052,$MSG_2053,$MSG_2054,$MSG_2055,$MSG_1626,$MSG_2056,$MSG_2057,
$MSG_547,$MSG_1626,$MSG_548,$MSG_1090,$MSG_928, $MSG_926,$MSG_927,$MSG_1834,$MSG_2035,$MSG_1659,$MSG_1503a,$MSG_1627,$MSG_1505 ;
 //echo "typ=$type<br>";
	switch ($type) {
		case '01-I' :
		case 'I' :
		case '9' :
			$libelle = $MSG_113; //"Intitul";
			break;
		case '02-S' :
		case 'S' :
		case '6':
			$libelle = $MSG_922; //"Scnario";
			break;
		case '03-T' :
		case 'T' :
		case '1':
			$libelle = $MSG_727; //"Parcours attach";
			break;
		case '05-B' :
		case 'B' :
		case '4_1':
			$libelle = $MSG_1267; //"Srie";
			break;
		case '06-Bq' :
		case 'Bq' :
			$libelle = " - $MSG_2040";
			break;
		case '07-Bf' :
		case 'Bf' :
			$libelle = " - $MSG_2041";
			break;
		case '08-Bs' :
		case 'Bs' :
			$libelle = " - $MSG_2042";
			break;
		case '08-Br' :
		case 'Br' :
			$libelle = " - $MSG_2043";
			break;
		case '09-Bm' :
		case 'Bm' :
			$libelle = " - $MSG_2044";
			break;
		case '10-Bo' :
		case 'Bo' :
			$libelle = " - $MSG_2045";
			break;			
		case 'Cmono':
		case '4_1_2':
			$libelle=$MSG_1627;
			break;
		case '17-Cmonomulti' :
		case 'Cmonomulti' :
			$libelle = $MSG_2046;
			break;
		case '12-Cmonoqcm' :
		case 'Cmonoqcm' :
			$libelle = $MSG_2047;
			break;
		case '13-Cmonoblanc' :
		case 'Cmonoblanc' :
			$libelle = $MSG_2048;
			break;
		case '14-Cmonosondage' :
		case 'Cmonosondage' :
			$libelle = $MSG_2049;
			break;
		case '15-Cmonoqrc' :
		case 'Cmonoqrc' :
			$libelle = $MSG_2050;
			break;
		case '16-Cmonosrc' :
		case 'Cmonosrc' :
			$libelle = $MSG_2051;
			break;
		case '24-Cmultimulti' :
		case 'Cmultimulti' :
			$libelle = $MSG_2052;
			break;
		case '19-Cmultiqcm' :
		case 'Cmultiqcm' :
			$libelle = $MSG_2053;
			break;
		case '20-Cmultiblanc' :
		case 'Cmultiblanc' :
			$libelle = $MSG_2054;
			break;
		case '21-Cmultisondage' :
		case 'Cmultisondage' :
			$libelle = $MSG_2055;
			break;
		case '18-Cmulti' :
		case 'Cmulti' :
		case '4_1_3':
			$libelle = $MSG_1626; //"Srie alatoire multitheme";
			break;
		case '22-Cmultiqrc' :
		case 'Cmultiqrc' :
			$libelle = $MSG_2056;
			break;
		case '23-Cmultisrc' :
		case 'Cmultisrc' :
			$libelle = $MSG_2057;
			break;
		case 'C' :
		case '4_1_4':
			$libelle = $MSG_1503a; //srie alatoire
			break;
		case '4_1_1':
			$libelle=$MSG_1505;
			break;			
		case 'Cq' :
			$libelle = " - $MSG_2058 ";
			break;
		case 'Cf' :
			$libelle = " - $MSG_2059";
			break;
		case 'Cs' :
			$libelle = " - $MSG_2060";
			break;
		case 'Q' :
			$libelle = $MSG_547; //"Qcm";
			break;
		case 'A' :
			$libelle = $MSG_548; //"Qcm alatoire";
			break;
		case '04-E' :
		case 'E' :
		case '5' :
			$libelle = $MSG_1090; //"Exotlc";
			break;
		case '27-P' :
		case 'P' :
		case '8' :
			$libelle = $MSG_928; //"Chat";
			break;
		case '26-F' :
		case 'F' :
		case '2':
			$libelle = $MSG_926; //"Forum";
			break;
		case '28-R' :
		case 'R' :
		case '7':
			$libelle = $MSG_927; //"Ressources";
			break;
		case '29-L' :
		case 'L' :
		case '4_3':
			$libelle = $MSG_1659; // test d'autoposit
			break;
		case '25-Z' :
		case 'Z' :
		case '3':
			$libelle = $MSG_2035; // scorm
			break;
		default:
			$libelle="Erreur: get_etape_type_libelle($type) :Type d'etape non reconnu ";
	}
	return $libelle;
}

/**
 * Savoir si un type d'tape correspond  des valuations.
 * 
 * Ces tapes donnent lieu  l'enregistrement de rsultats pour un stagiaire.
 * 
 * @param integer type d'tape.
 * @return bool true si le type d'tape  un chrono, false sinon.
 */
function is_etape_type_evaluee($type){
	switch($type){
		case 'B';
		case 'C';
		case 'L';
		case 'T';
		case 'E';
		case 'Z';
		case 4;
		case 10;
		case 5;
		case 3;		
			return true;
		default:
			return false;
	}
}

/**
 * Savoir si un type d'tape possde un chrono ou non.
 * 
 * @param integer type d'tape.
 * @return bool true si le type d'tape  un chrono, false sinon.
 */
function is_etape_type_chronometre($type){
	if($type=='4_1_4')return false;
	//on formate le $type pour les types composs
	$type=get_etape_type_formate($type,2);
	//echo "type=$type<br>";
	switch($type){
		case 'B':
		case 'C':
		case 'L':
		case 'T':
		case 'Z':
		case '4':
		case '4_1':
		case '4_3':
		case '1':
		case '3':
			//echo "OK type  reconnu:$type<br>";
			return true;
		default:
			//echo "- type non reconnu:$type<br>";
			return false;
	}
}

/**
 * Savoir si un type d'tape peut etre configur par une dure d'tape.
 * 
 * Cel inclu les types d'tapes pouvant posseder un chrono (fonction is_etape_type_chronometre()).
 * 
 * @param integer type d'tape.
 * @return bool true si le type d'tape peu etre configur, false sinon.
 */
function is_etape_type_duree($type){
	$type=get_etape_type_formate($type,2);
	//echo "type=$type<br>";
	switch($type){
		case 'S':
		case 'E':
		case 'R':
		case 'F':
		case 'P':
		case 6:
		case 5:
		case 7:
		case 2:
		case 8:
		case 1:
			return true;
		default:
			return is_etape_type_chronometre($type);
	}
}

/**
 * Obtenir la dure totale d'une tape de parcours.
 * Si la valeur retourne est un nombre ngatif, il s'agit
 * d'un chrono individuel.
 * 
 * @param integer le numro de l'tape.
 * @param integer: le type d'tape.
 * 
 * @return integer : la dure en seconde de l'tape de parcours.
 */
function get_etape_chrono_total($etape, $type="") {
	$duree = 0;
	//on formate le $type pour les types composs
	$type=get_etape_type_formate($type,2);
	//echo "$etape, $type<br>";
	switch ($type) {

		//SERIES
		case 'B' :
		case 'C' :
		case '4_1':
			$obj_serie= new Serie($etape);
			//on recupere le chrono total
			$duree = $obj_serie->getChronoTotal();
			//echo "duree=$duree<br>";
			//on retourne un chrono ngatif si le chrono est individuel, un chrono positif s'il est global
			$chono_serie=$obj_serie->getChrono();
			if(empty($chono_serie)){
				return -$duree;
			}else
				return $duree;
		
		//TESTS
		case 'L' :
		case '4_3':
			$obj_test = new Test($etape);
			
			//on recupere le chrono total
			$duree = $obj_test->getChronoTotal();
			//on retourne un chrono ngatif si le chrono est individuel, un chrono positif s'il est global
			if($obj_test->isContinue()!='t'){
				return -$duree;
			}else{
				return $duree;
			}
		
		//SOUS PARCOURS
		case 'T' :
		case '1' :
			$duree = get_parcours_duree_totale($etape);
			return $duree;
		
		case '4':
			return 0;
		//ERREUR
		default:
			die("fonctions_etape.inc: Erreur(get_etape_chrono_total($etape, $type)): le type d'tape ne peut avoir de chrono");
			return null;
			
	}
}


function get_etape_type_icone($type) {
global $serverback;
//print("$serverback cherche icone pour le type $type");
	switch ($type) {
		case "T" : //etape parcours
		case 1:
			$img_type = "http://$serverback/bo/images/ico_type/ico_vide.gif";    ///////MANQUANT
			break;
		case "F" : //Forum
		case 2:
			$img_type = "http://$serverback/bo/images/ico_type/ico_vide.gif";    ///////MANQUANT
			break;
		case "Z" : //Scorm
		case 3:
			$img_type = "http://$serverback/bo/images/ico_type/ico_scorm.png";
			break;
		case "B" : //srie
		case "C" : //serie alatoire
		case "L" : //test d'autopositionnement
		case 4:
			$img_type = "http://$serverback/bo/images/ico_type/ico_serie.png";
			break;
		case "E" : //exotlc
		case 5:
			$img_type = "http://$serverback/bo/images/ico_type/ico_exotlc.png";
			break;;
		case "S" : //Scnario
		case 6:
		case 11:
			$img_type = "http://$serverback/bo/images/ico_type/ico_scenario.gif";
			break;
		case "R" : //Ressource
		case 7:
			$img_type = "http://$serverback/bo/images/ico_type/ico_ressource.gif";
			break;
		case "P" : //Chat
		case 8:
			$img_type = "http://$serverback/bo/images/ico_type/ico_vide.gif";    ///////MANQUANT
			break;
		case "I" : //Etape titre
		case 9:
			$img_type = "http://$serverback/bo/images/ico_type/ico_vide.gif";    ///////MANQUANT
			break;
		case "O" : //parcours oriente
		case 10:
			$img_type = "http://$serverback/bo/images/ico_type/ico_vide.gif";    ///////MANQUANT
			break;
		default :
			$img_type="http://$serverback/bo/images/ico_type/ico_vide.gif";
	}
	return $img_type;
}
/**
 * Obtenir un tableau contenant tous les types donnant lieu  une notation.
 * @return string[] tableau de tous les types evalues
 */
function get_etape_types_evalues(){
	$tabtype=array();
	if (VERSION_BASE > VERSION) {
		$tabtype[]='5';
		$tabtype[]='4';
		$tabtype[]='4_1_0';
		$tabtype[]='4_1_0_1';
		$tabtype[]='4_1_0_2';
		$tabtype[]='4_1_0_3';
		$tabtype[]='4_1_0_4';
		$tabtype[]='4_1_0_5';			
		$tabtype[]='4_1_0_1';
		$tabtype[]='4_1_0_2';
		$tabtype[]='4_1_0_3';
		$tabtype[]='4_1_0_4';
		$tabtype[]='4_1_0_5';						
		$tabtype[]='4_1_0_1';
		$tabtype[]='4_1_0_2';
		$tabtype[]='4_1_0_3';
		$tabtype[]='4_1_0_4';
		$tabtype[]='4_1_0_5';		
		$tabtype[]='4_1_0_1';
		$tabtype[]='4_1_0_2';
		$tabtype[]='4_1_0_3';
		$tabtype[]='4_1_0_4';
		$tabtype[]='4_1_0_5';
		$tabtype[]='4_1_1';
		$tabtype[]='4_1_1_1';
		$tabtype[]='4_1_1_2';
		$tabtype[]='4_1_1_3';
		$tabtype[]='4_1_1_4';
		$tabtype[]='4_1_1_5';	
		$tabtype[]='4_1_2';		
		$tabtype[]='4_1_2_1';
		$tabtype[]='4_1_2_2';
		$tabtype[]='4_1_2_3';
		$tabtype[]='4_1_2_4';
		$tabtype[]='4_1_2_5';
		$tabtype[]='4_1_3';						
		$tabtype[]='4_1_3_1';
		$tabtype[]='4_1_3_2';
		$tabtype[]='4_1_3_3';
		$tabtype[]='4_1_3_4';
		$tabtype[]='4_1_3_5';
		$tabtype[]='4_1_4';		
		$tabtype[]='4_1_4_1';
		$tabtype[]='4_1_4_2';
		$tabtype[]='4_1_4_3';
		$tabtype[]='4_1_4_4';
		$tabtype[]='4_1_4_5';
		$tabtype[]='4_3';
	}else{		
		$tabtype[]='E';
		$tabtype[]='B';
		$tabtype[]='C';
	}
	return $tabtype;
}

/**
 * Formater un type calcul.
 * Le type retourn est le type pass en parametre format  la profondeur spcifie.
 * Les types ne pouvant etre ainsi tre 'rduits' sont retourns tels quels.
 * @param string : le type a formater.
 * @param integer : la profondeur de type dsire
 * @return string: le type format.
 */
function get_etape_type_formate($type_src,$profondeur){
	if((substr_count($type_src,'_')>$profondeur-1) ){
		$debut_type=strpos($type_src,'_',$profondeur);
		$type_return=substr($type_src,0,$debut_type);
		return	$type_return;	
	}
	else{
		return $type_src;
	}
	//on formate le $type pour les types composs

	
//	if($profondeur-2>0)$offset=$profondeur-2;
//	else $offset=0;
//	if(substr_count($type,'_')>=$profondeur){
//		
//		if($offset!=0)$type=substr($type,0,$debut_type+2);
//		else 
//	}
//	return $type;
}

/**
 * Test si une etape est valide (
 * 
 * @param integer : etape
 * @return bool : true si connect, false sinon
 * 
 */
 function is_etape_connectee($etape,$type){
 	switch($type){
 		case 11 : $res=get_scenario_dynamique($etape);
 						if($res)
 							return pg_fetch_result($res,0,5);
 						else
 							return false;
 		break;
 		
 		case 6 : $res=get_scenario($etape);
 						if($res)
 							return pg_fetch_result($res,0,5);
 						else
 							return false;
 		break;
 		
 		
 		default : return true;
 		
 	}
 	
 	
 }
?>
