<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

       @package etape
       @modulegroup plpgsql
       @module plpgsql_etape
*/

/**
 * Fichier de fonctions d�pr�ci�es
 */
//include ("$chemin_bo/lib/etape/plpgsql_deprecated_etape.inc");


/**
	Obtenir les informations d'une �tape

	@param integer : le numero d'�tape
    @return integer : le resultat de la requete :(id int4, libelle varchar, type int4, date_creation timestamp)
*/
function get_etape($etape){
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_etape($etape) AS (id int4, libelle varchar, type int4, date_creation timestamp)";
		//echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        print("La fonction get_etape($etape) n'existe pas pour la version ".VERSION);
        
    return $res ;
}

/**
	Supprime une etape
	@param integer : numero de l'etape
	@return integer : resultat requete
*/
function del_etape($etape){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_etape($etape)";
		$res=pg_query($sql);
	}
	else
		print("La fonction del_etape($etape) n'existe pas pour la version ".VERSION);
	return $res;
}

/**
    Obtenir les numeros de parcours pour une etape donn�e (OLD)

    @param integer : le numero d'�tape
    @param string : pour croissant (ASC, par d�faut) ou decroissant(DESC)
    @param char : le type d'�tape
    @return integer : le resultat de la requete (id int4, libelle varchar, filiere int4, duree bool)
*/
function get_etape_parcourss_old($etape,$desc="",$type='NULL'){
	if($desc=='DESC')$ordre=" ORDER BY DESC";
    else $ordre="";
    $sql="SELECT g_num_parcours FROM gestparcours WHERE num_c_q_e_d=$etape  AND type_etape='$type'";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les numeros de parcours pour une etape donn�e

    @param integer : le numero d'�tape
    @param string : pour croissant (ASC, par d�faut) ou decroissant(DESC)
    @return integer : le resultat de la requete (id int4, libelle varchar, filiere int4, duree bool, date_creation timestamp)
*/
function get_etape_parcourss($etape,$desc="", $type=""){
    if(VERSION_BASE>VERSION){
    	if($desc=='DESC')$ordre=" ORDER BY libelle DESC";
    	else $ordre="";
       	$sql="select * from contraintes.af_get_etape_parcourss($etape) AS (id int4, libelle varchar, filiere int4, duree bool, etape int4, date_creation timestamp) $ordre";
		$res=pg_query($sql);
    }
    else
        $res=get_etape_parcourss_old($etape,$desc,$type);
    return $res ;
}

/**
	Obtenir les �tapes correspondant � une liste de fichiers.

	@param array : un tableau contenant les identifiants des fichiers
	@param string : la table cible de la categorie
    @return array : un tableau ind�x� par les num�ros des fichiers contenant chacuns des champs de la table �tape(id, libelle, type, date_creation timestamp)
*/
function get_etapes_fichiers($fichiers, $table){
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_etapes_fichiers($fichiers, '$table') AS (id int4, libelle varchar, \"type\" int4, fichier int4, date_creation timestamp)";
		//echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        print("A impl�menter...");
    
    $etapes=array();
    $nb=pg_num_rows($res);
    for($i=0;$i<$nb;$i++){
    	$row=pg_fetch_row($res, $i);
    	$etapes[$row[3]][0]=$row[0];
    	$etapes[$row[3]][1]=$row[1];
    	$etapes[$row[3]][2]=$row[2];
    }    
    return $etapes ;
}


/**
	Modifier les libell�s d'une liste d'�tape.

	@param array : un tableau dont les cl�s sont les identifiants des �tapes et
					dont les valeurs sont leurs nouveaux lib�ll�s.
    @return integer : le nombre d'enregistrements ainsi modifi�s
*/
function maj_etapes_libelles($etapes_libelles){
	//CONSTRUCTION DES TABLEAUX POUR LES PARAMETRES DE LA REQUETE
	//print_rr($etapes_libelles);
	$nb=count($etapes_libelles);
	$i=0;
	$sql_ids=" _int4 '{";
	//$sql_libs=' _varchar $${';
	$sql_libs=' _varchar $${';
	while (list ($etape, $libelle) = each($etapes_libelles)) {
		if($i<$nb-1){
			$sql_ids.=$etape.",";
			//$sql_libs.="'".addslashes(str_replace ( "'","''", set_ams_libelle($libelle)))."',";
			$sql_libs.="\"".addslashes(str_replace ( "'","''", set_ams_libelle($libelle)))."\",";
		}
		else{
			$sql_ids.="$etape}'";
			//$sql_libs.="'".addslashes(str_replace ( "'","''", set_ams_libelle($libelle)))."'".'}$$';	
			$sql_libs.="\"".addslashes(str_replace ( "'","''", set_ams_libelle($libelle)))."\"".'}$$';			
		}
		$i++;	
	}
	
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_maj_etapes_libelles( $sql_ids , $sql_libs)";
		//echo "$sql<br>";die();
		$res=pg_query($sql);
    }
    else
        print("A impl�menter...");
        
    return pg_fetch_result($res,0,0) ;
}


/**
	Modifier le lib�ll� d'une �tape.

	@param integer : le numero d'�tape
	@param varchar: le nouveau libell� de l'�tape
    @return bool : true ou false si l'update s'est bien d�roul�
*/
function maj_etape_libelle($etape, $libelle){
	
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_maj_etape_libelle($etape,varchar '$libelle')";
		//echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        print("A impl�menter...");
        
    return pg_fetch_result($res,0,0) ;
}

/**
    Obtenir les infos sur les filieres des parcours qui utilisent l'�tape donn�e en param�tre

   	@param integer : le numero de l'�tape
    @param string : pour croissant (ASC, par d�faut) ou decroissant(DESC)
    @return integer : le resultat de la requete (id int4, libelle  varchar, pere int4, parcours int4)
*/
function get_etape_filieres($etape,$desc=""){
    if(VERSION_BASE>VERSION){
    	if($desc=='DESC')$ordre=" ORDER BY libelle DESC ";
    	else $ordre="";
		$req = "SELECT * from  contraintes.af_get_etape_filieres($etape) as (id int4, libelle  varchar, pere int4, parcours int4) $ordre";
		$res = pg_query($req);
    }
    else print("get_etape_filieres_old A IMPLEMENTER<br>");
    
    return $res ;
}

/**
	Obtenir les resultats obtenus � une �tape

	@param integer : le numero d'�tape
    @return integer : le resultat de la requete(id int4, formation int4,  classe int4, stagiaire int4, parcours int4,  etape int4, date_debut timestamp, date_fin timestamp)
*/
function get_etape_resultats($etape){
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_etape_resultats($etape) AS (id int8, formation int4, stagiaire int4, parcours int4,  etape int4, date_debut timestamp, duree interval)";
		//echo "$sql<br>";
		return pg_query($sql);
    }
    else
        print("La fonction get_etape_resulats($etape) n'existe pas pour la version ".VERSION);
}

function get_etape_classes($etape,$desc){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_etape_classes($etape) AS (id int4,libelle varchar,pere int4,min int4,max int4, parcours int4)";
        //echo $sql;
        return pg_query($sql);
    }
    else
          print("La fonction get_etape_classes($etape, $desc) n'existe pas pour la version ".VERSION);
}

/**
	Obtenir les formations pour une �tape (OLD)

	@param integer : le numero d'�tape
    @param char : le type d'�tape
    @return integer : le resultat de la requete (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4)
*/
function get_etape_formations_old($etape,$desc, $type){
	$sql="select DISTINCT num_cal, C.nom_cal, g_num_parcours , C.datedeb, C.datefin, C.langue
				FROM gestparcours G1,gestionparcours G2, calendrier C
				WHERE num_c_q_e_d=$etape
				AND type_etape='$type'
				AND C.num_cal=G1.num_cal
				AND gp_num_parcours=g_num_parcours
				ORDER BY C.nom_cal $desc ";
				echo $sql;
	return (pg_query($sql));
}

/**
	Obtenir les formations pour une �tape 

	@param integer : le numero d'�tape
    @param char : le type d'�tape
    @return integer : le resultat de la requete (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4)
*/
function get_etape_formations($etape,$desc="",$type=""){
	if(VERSION_BASE>VERSION){
		if($desc=='DESC')$ordre="ORDER BY libelle DESC";
		else $ordre="";
        $sql="SELECT * FROM contraintes.af_get_etape_formations($etape) AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4,ressources_fusionnees bool)";
        //echo $sql;
        return pg_query($sql);
    }
    else
        $res=get_etape_formations_old($etape,$desc, $type);
    return $res ;
}

/**
 * Obtenir les formations pour une �tape et une classe donn�e
 * 
 * @param integer : le numero d'�tape
 * @param integer : le numero de la classe
 * @param string : 'ASC' pour croissant(par d�faut) ou 'DESC' pour decroissant 
 * @return integer : le resultat de la requete (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4)
 */
function get_etape_formations_classe($etape,$classe,$desc=""){
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_etape_formations_classe($etape, $classe) AS (id int4, libelle varchar, parcours int4, date_debut date, date_fin date, langue_defaut int4, classe int4)";
        //echo $sql;
        return pg_query($sql);
    }
    else
        print("La fonction get_etape_formations_classe($etape, $classe,$desc) n'existe pas pour la version ".VERSION);
}

function get_etape_themes($etape){
	if (VERSION_BASE > VERSION) {
		$sql="SELECT * FROM contraintes.af_get_element_themes_categorie($etape,29) AS (id int4, libelle varchar)";
		//echo $sql;
		return pg_query($sql);
	}else{
		print("La fonction get_etape_themes($etape) n'existe pas pour la version ".VERSION);
	}
}

/**
*  Met � jour les parametre d'une �tape d'un parcours.(OLD)
* 
*   @param integer : l'identifiant du parcours
*   @param integer : l'indice de l'�tape
*   @param varchar : lib�ll� de l'�tape (alias!!)
*   @param bool : obligation de l'�tape
*   @param bool : �tape fin de page?
*   @param varchar : type de l'�tape
*   @return bool : true si l'affectation a bien �t� �ffectu�e.
*/
function maj_etape_parcours_old($parcours, $etape_indice, $alias_etape, $obligation, $chrono, $finpage, $type) {
	if ($finpage == "FALSE")
		$finpage = 0;
	else
		$finpage = 1;

	if ($obligation == "FALSE")
		$obligation = "l";
	else
		$obligation = "o";

	if ($type == get_etape_type_old_new('I')) {
		$libelle_etape_titre = ", attach_fic='$etape'";
	} else {
		$libelle_etape_titre = "";
	}

	$sql = "UPDATE gestparcours SET obligation='$obligation', num_etape_suivante='$finpage', chrono=$chrono $libelle_etape_titre 
		    WHERE g_num_parcours=$parcours AND num_etape=$etape_indice AND type_etape='$type'";

	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
*  Met � jour les parametre d'une �tape d'un parcours.
* 
*   @param integer : l'identifiant du parcours
*   @param integer : l'identifiant de l'�tape
*   @param varchar : lib�ll� de l'�tape (alias!!)
*   @param bool : obligation de l'�tape
*   @param bool : �tape fin de page?
*   @return bool : true si l'affectation a bien �t� �ffectu�e.
*/
function maj_etape_parcours($parcours, $etape, $libelle_type_etape, $obligation, $chrono, $finpage, $type = "") {
	if (VERSION_BASE > VERSION) {
		$sql = "select contraintes.af_maj_etape_parcours($parcours, $etape,varchar '$libelle_type_etape',  $obligation,$chrono, $finpage)";
		//echo "$sql<br>";
		return pg_query($sql);
	} else
		$res = maj_etape_parcours_old($parcours, $etape, $libelle_type_etape, $obligation, $chrono, $finpage, $type);
	return $res;
}

function set_etape_titre($libelle){
	if (VERSION_BASE > VERSION) {
		$sql = "select contraintes.af_set_etape('$libelle',9)";
		//echo "$sql<br>";
		$ins=pg_query($sql);
		$new = pg_fetch_result($ins,0,0);
		return $new;
	} else
		$res = set_etape_titre_old($libelle);
	return $res;
}

/**
	Supprime les resultats pour une ou plusieurs etapes pour un individu (old)
	@param integer : formation
	@param integer : individu
	@param array : les etapes
	@return res req
*/
function del_etape_resultat_individu_old($formation,$individu,$etape,$parcours){

}
/**
	Supprime les resultats pour une ou plusieurs etapes pour un individu 
	@param integer : formation
	@param integer : individu
	@param array : les etapes
	@param array : parcours
	@return res req
*/
function del_etape_resultat_individu($formation,$individu,$etapes,$parcours){
	if (VERSION_BASE > VERSION) {
		$sql_etapes=int_array_to_plpgsql_array($etapes);
		$sql_parcours=int_array_to_plpgsql_array($parcours);
		$sql="select * from contraintes.af_del_etape_resultat_individu($formation,$individu,$sql_etapes,$sql_parcours)";
//		echo "sql=$sql<br>";
		return pg_query($sql);
	}
	else
		return del_etape_resultat_individu_old($formation,$individu,$etapes,$parcours);
}

/**
	Supprime les resultats tentative pour une ou plusieurs etapes pour un individu 
	@param integer : formation
	@param integer : individu
	@param array : les etapes
	@param integer : parcours
	@return res req
*/
function del_etape_resultat_tentative_individu($formation,$individu,$etapes,$parcours){
	if (VERSION_BASE > VERSION) {
		$sql_etapes=int_array_to_plpgsql_array($etapes);
		$sql="select * from contraintes.af_del_etape_resultat_tentative_individu($formation,$individu,$sql_etapes,$parcours)";
		//echo "sql=$sql<br>";
		return pg_query($sql);
	}
	else
		return del_etape_resultat_tentative_individu_old($formation,$individu,$etape,$parcours);
}

/**
 * Retourne le type entier et le libelle entier d'une etape
 * @param integer : etape
 * @param integer : type
 * @return res req : exemple pour une serie de blanc (4_1_0_3,(- s�rie (remplir les blancs))
 */
 function get_etape_type_sous_type($etape,$type,$libelle){
 	$sql="select * from contraintes.af_get_etape_type_sous_type($etape,$type,'$libelle')" ;
 	//echo "sql=$sql<br>";
 	return pg_query($sql);	
 }


?>