<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fonctionnalit chat
	@package chat
	@modulegroup plpgsql
	@module plpgsql_chat
*/		 


/**
	Enregistre une etape chat
	
	@param string : le libell de l'tape
	
	
	@return integer : l'identifiant de l'tape forum cre
*/
function set_etape_chat($libelle){
	$sql = "SELECT * FROM contraintes.af_set_etape_chat('$libelle')";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	$id=pg_fetch_result($res, 0, 0);
	
	return $id;
}

/**
	Obtenir les infos d'une tape chat
	@param integer : le numero de l'tape chat
	@return integer : le resultat de la requete : (id int4,libelle_etape varchar,type int4,date_creation timestamp)
*/
function get_etape_chat($etape){
	$sql="select * from contraintes.af_get_etape($etape) as 
	(id int4,libelle_etape varchar,type int4,date_creation timestamp)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Mettre  jour une etape chat
	@param integer : etape
	@param string : le libell de l'tape
	
	@return integer : res req
*/
function maj_etape_chat($etape,$libelle){
	$sql="select * from contraintes.af_maj_etape_chat($etape,'$libelle')";
	return pg_query($sql);
}


?>