<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoEtapeForum.
 * Un DoEtapeForum est l'objet servant  gerer l'avancement des
 * Etapes Forum d'un parcours.
 * 
 * @package forum
 */
class DoEtapeForum extends DoEtapeRenewable{

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'EtapeForum
	 */
	function DoEtapeForum($formation,$individu,$parcours,$etape){
		messageDebug("DoEtapeForum::DoEtapeForum($formation,$individu,$parcours,$etape)");
		parent::DoEtapeRenewable($formation,$individu);
		$this->initDoEtapeForum($parcours,$etape);
	}

	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * 
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'EtapeForum
	 */	
	function initDoEtapeForum($parcours,$etape){
		messageDebug("DoEtapeForum::initDoEtapeTitre($parcours,$etape)");
		parent::initDoEtapeRenewable($parcours,$etape, TYPE_ETAPE_FORUM);
	}
	
	
	
	
	/**
	 * Construction de l'objet associ  l'tape.
	 * La mthode beginCurrentEtape() doit avoir t appelle au moins 1 fois auparavent.
	  * L'identifiant du forum est enregistr en session
	 * @return object Etape : L'objet correspondant  l'tape (au DoNode) 
	 */
	function &performCurrentEtape(&$obj_NodeFactory){
		messageDebug("DoEtapeRenewable::performCurrentEtape($obj_NodeFactory)");
		$tmp=&parent::performCurrentEtape($obj_NodeFactory);
		// enregistre le forum en session
		$s_forum=$this->obj_node->getForum();
		if(!session_is_registered("s_forum")){
			session_register("s_forum");
		}
		if(!session_is_registered("formation") ){
			session_register("formation");
		}
		return $tmp;
		

	}
	
	/**
	 * Termine l'tape.
	 * Enregistre et met  jour la dure de l'tape (cumul des dures) et detruit les attributs de l'objet inutiles (resultat et obj_node).
	 * L'identifiant du forum est supprim de la  session
	 * @param object ResultatEtape $obj_resultat  Resultat associ  l'objet associ  l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succs ou non de la mthode.
	 */
	function endCurrentEtape($obj_resultat=null){
		
		messageDebug(" DoEtapeForum::endCurrentEtape($obj_resultat)");
		
			if(!parent::endCurrentEtape($obj_resultat)){
				die("Erreur DoEtapeForum::endCurrentEtape(): L'tape n'a pas t termine.<br>");
				return false;
			}else{
				
				session_unregister("s_forum");
				session_unregister("formation");
				return true;
			}
			
		
		
		
	}	
	
	
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir l'objet correspondant  l'tape 
	 * @return object EtapeForum l'objet correspondant  l'tape
	 */			
	function &getEtapeForum(){
		return parent::getObjEtape();
	}
}
?>
