<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe EtapeForum.
 *	Un EtapeForum est un objet driv d'Etape.
 *
 *	@package forum
 */
class EtapeForum extends Etape{

	var $forum;
	var $libelle_forum;
	var $description;
	var $moderation;
	var $moderateur;
	var $fils;
	var $messages;
	var $upload;
	var $theme;
	var $configuration;

	/**
	 * Construit une EtapeForum.
	 * L'EtapeForum peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du ParcoursOriente
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 * @param integer $id forum
	 * @param string $libelle forum
	 * @param string $description
	 * @param boolean $moderation
	 * @param string $moderateur
	 * @param integer $fils
	 * @param integer $messages
	 * @param boolean $upload
	 * @param string $theme
	 * @param integer $configuration
	 */
	 
	 // forum int4,libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar,configuration int4,date_creation timestamp
	 
	function EtapeForum($id, $libelle="Forum", $date_creation="27.11.2006",$forum=0,$libelle_forum="",$description="",$moderation=false,$moderateur="",$fils=0,$messages=0,$upload=false,$theme="",$configuration=0){
		messageDebug("EtapeForum::EtapeForum($id, $libelle, $date_creation,)");
		if(func_num_args()==1){
			$res_etape=get_etape_forum($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$forum=$row_etape[2];
			$libelle_forum=$row_etape[3];
			$description=$row_etape[4];
			$moderation=$row_etape[5];
			$moderateur=$row_etape[6];
			$fils= $row_etape[7];
			$messages=$row_etape[8];
			$upload=$row_etape[9];
			$theme=$row_etape[10];
			$configuration=$row_etape[11];
			$date_creation=$row_etape[12];
		}else{
			
		}
		parent::Etape($id, $libelle,$date_creation, TYPE_ETAPE_FORUM);
		$this->initEtapeForum($forum,$libelle_forum,$description,$moderation,$moderateur,$fils,$messages,$upload,$theme,$configuration);
	}

	/**
	 * Initialise les attributs propres  l'EtapeForum.
	 * Ne fait rien.
	 */	
	function initEtapeForum($forum,$libelle_forum,$description,$moderation,$moderateur,$fils,$messages,$upload,$theme,$configuration){
		$this->forum=$forum;
		$this->libelle_forum=$libelle_forum;
		$this->description=$description;
		$this->moderation=$moderation;
		$this->moderateur=$moderateur;
		$this->fils=$fils;
		$this->messages=$messages;
		$this->upload=$upload;
		$this->theme=$theme;
		$this->configuration=$configuration;
	}
	
	/**
	* Obtenir l'identifiant du forum
	* @return integer l'identifiant du forum
	*/
	function getForum(){
		return $this->forum;
	}
	
	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string Le nom du fichier icone
	 */
	function getIcone(){
		return "ico_forum.gif";
	}
}
?>