<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fonctionnalit forum
	@package forum
	@modulegroup plpgsql
	@module plpgsql_forum
*/		 


/**
	Enregistre une etape forum
	Le fichier, l'espace et la section peuvent tre nulls.
	@param string : le libell de l'tape
	@param integer : forum
	
	@return integer : l'identifiant de l'tape forum cre
*/
function set_etape_forum($libelle, $forum,$theme){
	$sql = "SELECT * FROM contraintes.af_set_etape_forum('$libelle',$forum)";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	$id=pg_fetch_result($res, 0, 0);
	set_categorie_element_theme(61,$theme,$id);
	
	return $id;
}

/**
	Obtenir les infos d'une tape forum
	@param integer : le numero de l'tape forum
	@return integer : le resultat de la requete : (id int4,libelle varcha, forum int4, libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar,configuration int4,date_creation timestamp)
*/
function get_etape_forum($etape){
	$sql="select * from contraintes.af_get_etape_forum($etape) as 
	(id int4,libelle_etape varchar,forum int4,libelle varchar,description varchar,moderation bool,moderateur_pwd varchar,fils int4,messages int4,upload bool,theme varchar,configuration int4,date_creation timestamp)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Mettre  jour une etape forum
	@param integer : etape
	@param string : le libell de l'tape
	@param integer : forum
	@return integer : res req
*/
function maj_etape_forum($etape,$libelle,$forum){
	$sql="select * from contraintes.af_maj_etape_forum($etape,'$libelle',$forum)";
	return pg_query($sql);
}

/**
 * Supprime une etape forum
 * 
 * 
 */


?>