<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe EtapeRessource.
 *	Une EtapeRessource est un objet driv d'Etape.
 *
 *	@package ressource
 */
class EtapeRessource extends Etape{
	
	var $espace;
	var $section;
//	var $ressource;
	var $fichier;
	var $fichier_type;
	var $mots_cles;

	/**
	 * Construit l'EtapeRessource.
	 * L'EtapeRessource peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de l'EtapeRessource
	 * @param string $libelle Libell de l'EtapeRessource
	 * @param string $date_creation date de cration (format SQL)
	 */	
	function EtapeRessource($id, $libelle="Etape Ressource", $date_creation="27.11.2006",$espace=0, $section=0, $ressource=0, $fichier=0,$mots_cles=""){
		messageDebug("EtapeRessource::EtapeRessource($id, $libelle, $date_creation)");
		if(func_num_args()==1){
			$res_etape=get_etape_ressource($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[7];
			$espace=$row_etape[2];
			$section=$row_etape[3];
			$fichier= $row_etape[4];
			$fichier_type=$row_etape[5];
			$mots_cles=$row_etape[6];
		}else{
			
		}
		parent::Etape($id, $libelle,$date_creation, TYPE_ETAPE_RESSOURCE);
		$this->initEtapeRessource($espace,$section,$fichier,$fichier_type,$mots_cles);
	}

	/**
	 * Initialise les attributs propres  l'EtapeRessource.
	 * 
	 * @param integer $espace Identifiant de l'Espace associ  l'EtapeRessource.
	 * @param integer $section Identifiant de la Section associe  l'EtapeRessource.
	 * @param integer $ressource Identifiant de la Ressource associe  l'EtapeRessource.
	 * @param integer $fichier Identifiant du Fichier associ  l'EtapeRessource.
	 * @param string $mots_cles Mots cls permettant d'effectuer une recherche sur la ressource.
	 */	
	function initEtapeRessource($espace, $section, $fichier,$fichier_type,$mots_cles){
		
		messageDebug("EtapeRessource::initEtapeRessource($espace, $section, $fichier,$fichier_type,$mots_cles)");
		parent::initEtape();
		$this->espace=$espace;
		$this->section=$section;
		$this->fichier_type=$fichier_type;
		$this->fichier=$fichier;
		$this->mots_cles=$mots_cles;
	}
	
	/**
	* Obtenir l'identifiant de l'espace
	* @return integer l'identifiant de l'espace
	*/
	function getEspace(){
		return $this->espace;
	}
	
	function getObjEspace(){
		if(!empty($this->espace))
			return new Espace($this->espace);
		else
			return null;
	}
	
	/**
	* Obtenir l'identifiant de la section
	* @return integer l'identifiant de la section
	*/
	function getSection(){
		return $this->section;
	}
	
	function getObjSection(){
		if(!empty($this->section))
			return new Section($this->section);
		else
			return null;
	}
	
//	 /**
//	* Obtenir l'identifiant de la ressource
//	* @return integer l'identifiant de la ressource
//	*/
//	function getRessource(){
//		return $this->ressource;
//	}
	
	/**
	* Obtenir l'identifiant du fichier de la ressource
	* @return integer l'identifiant du fichier de la ressource
	*/
	function getFichier(){
		return $this->fichier;
	}
	
	function getFichierType(){
		return $this->fichier_type;
	}
	
	function getMotsCles(){
		return $this->mots_cles;
	}
	
//		/**
//	* Obtenir l'identifiant du fichier de la ressource
//	* @return integer l'identifiant du fichier de la ressource
//	*/
//	function getObjFichier(){
//		if(!empty($this->fichier))
//			return new FichierRessource($this->fichier);
//		else
//			return null;
//	}
	
	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string Le nom du fichier icone
	 */
	function getIcone(){
		return "ico_ressource.gif";
	}
	
	/**
	 * Obtenir le chemin relatif du Fichier associ au Scnario
	 * @param string $racine Racine  partir de laquelle le chemin chemin relati est calcul. 
	 * @return string Le chemin relatif du Fichier
	 */
	function getFichierChemin($racine){
		$chemin=get_fichier_chemin_relatif($this->fichier, pg_fetch_result(get_categorie_element_themes(1,$this->fichier),0,0), 1);
		if(file_exists($racine.$chemin))return $racine.$chemin;
		else return false;
	}
	
	function getFichierExtension(){
		//extension
		return get_fichier_extension( $this->fichier);
	}
}
?>