<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package ressource
 * @modulegroup plpgsql
 * @module plpgsql_ressource
 */
		 
/**
*   Obtenir les themes associs  un fichier de ressource  (OLD)
*  
*   @param integer : le numero de la ressource
*   @param char : le type de la ressource (t=texte et f=fichier)
*   @return integer : (id int4, libelle varchar)
*/
function get_etape_ressource_themes_old($ressource){
    
    $sql="SELECT DISTINCT T.num_themedir, T.nom_theme FROM themedir T, ressource_gest G, gestparcours P, gestionnaire GE 
		WHERE G.num_gest_res=$ressource
		AND G.num_cal=GE.g_num_cal
		AND P.g_num_parcours=GE.g_num_parcours
		AND P.num_etape=1
		AND P.num_thematik=T.num_themedir ";
	//echo "$sql<br>";
    $res=pg_query($sql);
    return $res;
}


/**
*  Obtenir les themes associs  un fichier de ressource  
*  
*   @param integer : le numero de la ressource
*   @return integer : (id int4, libelle varchar)
*/
function get_etape_ressource_themes($ressource){
    if(VERSION_BASE>VERSION){
        return get_categorie_element_themes(39,$ressource);
    }
    else
        $res=get_etape_ressource_themes_old($ressource);
    return ($res);
}

/**
	Enregistre une etape ressource.
	Le fichier, l'espace et la section peuvent tre nulls.
	@param string : le libell de l'tape
	@param integer : ressource
	@param integer : espace
	@param integer : section
	@param integer : le theme de la ressource
	@return integer : l'identifiant de l'tape ressource cre
*/
function set_etape_ressource($libelle, $ressource,$espace,$section, $theme){
	$sql = "SELECT * FROM contraintes.af_set_etape_ressource('$libelle',$ressource,$espace,$section)";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	$id=pg_fetch_result($res, 0, 0);
	set_categorie_element_theme(39,$theme,$id);
	return $id;
}

/**
	Obtenir les infos d'une tape ressource
	@param integer : le numero de l'tape ressource
	@return integer : le resultat de la requete : (id int4,libelle varchar,espace, section, ressource int4, fichier int4,mots_cles text,date_creation timestamp)
*/
function get_etape_ressource($etape){
	$sql="select * from contraintes.af_get_etape_ressource($etape) as (id int4,libelle varchar,espace int4, section int4, fichier int4, type_fichier int4,mots_cles text,date_creation timestamp)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
 * Obtenir les infos d'une ressource
 * @param integer: le numero d'espace
 * @param integer: le numero de section
 * @param integer: le numero de ressource
 * @return integer: le resultat de la requete :(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut date,fin date,nouveau int4,icone int4)
 */
function get_etape_ressource_infos($espace,$section,$ressource){
	$sql="select * from contraintes.af_get_etape_ressource_infos($espace,$section,$ressource) as(ressource int4,fichier int4,espace int4,libelle_espace varchar,section int4,libelle_section varchar,titre varchar,formation int4,type int4,mots_cles text,debut date,fin date,nouveau int4,icone int4)";
//	echo"$sql";
	return pg_query($sql);
}

/**
	Modifie une etape ressource.
	Le fichier, l'espace et la section peuvent tre nulls.
	@param integer : identifiant de l'tape
	@param string : le libell de l'tape
	@param integer : ressource
	@param integer : espace
	@param integer : section
	@return integer : t ou f selon qu'une mise a jour ait t effectue ou non
*/
function maj_etape_ressource($etape,$libelle, $ressource,$espace,$section){
	$sql = "SELECT * FROM contraintes.af_maj_etape_ressource($etape,'$libelle',$ressource,$espace,$section)";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	$ok=pg_fetch_result($res, 0, 0);
	return $ok;
}
?>