<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoEtapeTitre.
 * Un DoEtapeTitre sert  grer l'avancement des Etapes de type EtapeTitre.
 * 
 * @package etape_titre
 */
class DoEtapeTitre extends DoEtapeDynamique{

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'ExotlcPlateforme
	 * @param object EtapeFactory &$obj_EtapeFactory La fabrique d'objet Etape.
	 */	
	function DoEtapeTitre($formation,$individu,$parcours,$etape,$obj_EtapeFactory){
		messageDebug("DoEtapeTitre::DoEtapeTitre($formation,$individu,$parcours,$etape)");
		parent::DoEtapeDynamique($formation,$individu);
		$this->initDoEtapeTitre($parcours,$etape,$obj_EtapeFactory);
	}

	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * 
	 * @param integer $parcours Identifiant du parcours courant.
	 * @param integer $etape Identifiant de l'tape courante.
	 * @param object EtapeFactory &$obj_EtapeFactory La fabrique d'objet Etape.
	 */		
	function initDoEtapeTitre($parcours,$etape,$obj_EtapeFactory){
		messageDebug("DoEtapeTitre::initDoEtapeTitre($parcours,$etape)");
		parent::initDoEtapeDynamique($parcours,$etape, TYPE_ETAPE_TITRE);
		//$this->beginCurrentEtape($obj_EtapeFactory);
	}
//	
//	/**
//	 * Dbut de l'tape et fin de l'tape.
//	 * Dbut:Initialise l'avancement de l'tape courante.
//	 * Cration de l'identifiant rsultat et enregistrement de la date de dbut de l'tape.
//	 * Si l'identifiant rsultat existe dj, une erreur est gnre.
//	 * Fin:Enregistre la date de fin de l'tape et detruit les attributs de l'objet inutiles (resultat et obj_node). 
//	 * Cette mthode ncssite un identifiant Resultat, et donc un appel prcdant  la methode beginCurrentEtape().
//	 * Elle ncessite aussi un objet Resultat en parametre, qui est obtenu par la methode getCurrentResultat()
//	 * 
//	 * @param object EtapeFactory &$obj_EtapeFactory La fabrique d'objet Etape.
//	 * @return object EtapeTitre  L'objet correspondant  l'avancement
//	 */
//	function beginCurrentEtape(&$obj_EtapeFactory){
//		messageDebug("DoEtapeTitre::beginCurrentEtape()");
//		parent::beginCurrentEtape();
//		$obj_tmp=parent::performCurrentEtape($obj_EtapeFactory);
//		parent::endCurrentEtape();
//		return $obj_tmp;
//	}
	
	/**
	 * IMPLEMEBTATION METHODE ABSTRAITE
	 * Appele automatiquement par l'objet d'avancement, cette mthode permet de faire l'tape titre automatiquement
	 * pour que le curseur ne s'arrete pas dessus.
	 * @param object &$obj_elementEntity DoElementEntity L'objet d'avancement 
	 */
	function &perform(&$obj_elementEntity){
		$obj_do_etape_factory=$obj_elementEntity->getDoEtapeFactory();
	
		messageDebug("DoEtapeTitre::beginCurrentEtape()");
		parent::beginCurrentEtape();
		$obj_tmp=parent::performCurrentEtape($obj_do_etape_factory->getEtapeFactory());
		parent::endCurrentEtape();
		return $obj_elementEntity->nextDoNode();
		
	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir l'objet EtapeTitre associ  cet objet d'avancement.
	 * @return object EtapeTitre L'objet EtapeTitre associ. 
	 */
	function getEtapeTitre(){
		return parent::getObjEtape();
	}
	
	
}
?>
