<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * D�finition d'un DoEvaluation.
 * Un DoEvaluation est l'objet de base servant � gerer l'avancement des
 * Evaluations d'une Liste.
 * Ainsi, chaque objet d'avancement des diff�rents types d'Evaluations 
 * d'une Liste doivent h�riter de cette classe.
 * 
 * Note: Cet objet ne connait pas l'identifiant de formation.
 * 
 * @package evaluation
 */
class DoEvaluation extends DoNode {
	
//	/**
//	 * @var integer Identifiant de l'Evaluation.
//	 */
//	var $node;
//	
//	/**
//	 * @var integer Type d'Evaluation'.
//	 */
//	var $node_type;
//	
//	/**
//	 * @var object Node Objet correspondant au Node.
//	 */
//	var $obj_node;
//	
//	/**
//	 * @var object Resultat Objet Resultat associ� au Node
//	 */
//	var $obj_resultat;
//
//	/**
//	 * @var integer Identifiant du resultat en base de donn�es
//	 * Cet identifiant est correspond � une combinaison unique
//	 * d'identifiants de Formation, Parcours, Individu et Etape.
//	 */
//	var $resultat;

	/**
	 * @var integer Indice du DoEvaluation
	 */
	var $indice;
	
	/**
	 * @var object EvaluationFactory  La fabrique des objets concern�s par l'avancement.
	 */		
	var $obj_EvaluationFactory;

	/**
	 * Constucteur.
	 * Affecte les attributs de la classe � 
	 * partir des param�tres.
	 * 
	 * @param integer $resultat Identifiant du r�sultat d'avancement.
	 * @param integer $evaluation Identifiant de l'Evaluation concern�e par l'avancement.
	 * @param integer $type Identifiant du type de de l'Evaluation concern�e par l'avancement.
	 * @param integer $indice Indice de l'�valuation.
	 * @param object EvaluationFactory &$obj_EvaluationFactory La fabrique d'objet Evaluation.
	 */
	function DoEvaluation($resultat,$evaluation,$type,$indice,&$obj_EvaluationFactory){
		messageDebug("DoEvaluation::DoEvaluation($resultat,$evaluation,$type,$indice,&\$obj_EvaluationFactory)");
		
		
		//on recupere le resultat correspondant pour obtenir la s�rie , la formation, l'individu et le parcours
		$row_resultat=get_resultat($resultat);
//		echo "AA=";
//		print_rr($row_resultat);
		parent::DoNode( $row_resultat[3],$row_resultat[2]);
		//pour affecter sa date de d�but
//		$this->debut=$row_resultat[5];
//		$this->resultat=$row_resultat[0];
//		$this->duree=$row_resultat[6];
		
		$this->initDoEvaluation($resultat,$row_resultat[4],$evaluation,$type,$indice,$obj_EvaluationFactory);
	}
	
	/**
	 * V�rifie les attributs de la classe.
	 * En cas d'attributs invalide, g�n�re une erreur.
	 * 
	 * @param integer $resultat Identifiant du r�sultat d'avancement.
	 * @param integer $evaluation Identifiant de l'Evaluation concern�e par l'avancement.
	 * @param integer $type Identifiant du type de de l'Evaluation concern�e par l'avancement.
	 * @param integer $indice Indice de l'�valuation.
	 * @param object EvaluationFactory &$obj_EvaluationFactory La fabrique d'objet Evaluation.
	 */
	function initDoEvaluation($resultat,$serie,$evaluation,$type,$indice,&$obj_EvaluationFactory){
		messageDebug("DoEvaluation::initDoEvaluation($resultat,$evaluation,$type,$indice,&\$obj_EvaluationFactory)");
		parent::initDoNode($serie,$evaluation, $type);

		if(!empty($resultat)&&!empty($evaluation)&&!empty($type)&&is_object($obj_EvaluationFactory)){
			$this->resultat=$resultat;
//			$this->node=$evaluation;
//			$this->node_type=$type;
			
			$row_res=pg_fetch_row(get_resultat_serie_evaluation($this->resultat,$this->node));
			$this->debut=$row_res[2];
			$this->fin=$row_res[3];
//			print_rr($row_res);
			$this->indice=$indice;
			
			
			$this->obj_EvaluationFactory=&$obj_EvaluationFactory;
//			print_rr($this);
		}else{
			die("Erreur DoEvaluation::initDoEvaluation($resultat,$evaluation,$type,$indice,&$obj_EvaluationFactory): L'objet ne peut etre initialis�.");
		}	
	}
	
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	
	/**
	 * Commence l'�valuation.
	 * Ne fait aucun traitement.
	 * @return boolean Retourne toujours true
	 */
	function begin(){
		messageDebug("DoEvaluation::begin()");
		if(empty($this->debut)){
			$this->debut=set_resultat_serie_debut($this->getResultat(), $this->getEvaluation());
			if(empty($this->debut)){
//				print_rr($this);
				die("Erreur DoEvaluation::begin(): L'�valuation n'a pas �t� commenc�e.<br>");
				return false;
			}
		}else{
			//print_rr($this);			
			die("Erreur DoEvaluation::begin(): L'�valuation a d�ja �t� commenc�e.<br>");
			return false;
		}
		return true;
	}
	
	/**
	 * Effectue l'�valuation.
	 * Cr�e l'objet Evaluation et l'objet ResultatEvaluation associ�s.
	 * @return object Evaluation L'objet Evaluation associ� � cet objet DoEvaluation, ou null s'il n'a pu etre cr��.
	 */
	function &perform($obj_liste,$chrono_restant){
		messageDebug("DoEvaluation::perform()$chrono_restant yyyyyyy<br>");
			
		if(!empty($this->resultat)&&!empty($this->debut)){
			$this->obj_resultat= ResultatEvaluationFactory::createResultatEvaluation($this->getType());				
			$this->obj_node=$this->obj_EvaluationFactory->createEvaluation($this->getEvaluation(),$this->getType());
			$ok=$this->isChronoValid($obj_liste,$chrono_restant);
			if(!$ok){
				messageDebug("DoEvaluation::ANNULATION!<br>");
				$this->abord();
			}else{
				messageDebug("DoEvaluation::OK!<br>");
			}
			return $this->obj_node;
		}else{
			die("Erreur DoEvaluation::perform(): L'�valuation n'a pas �t� commenc�e.<br>");
			return null;
		}
	}

	/**
	 * Termine l'�valuation.
	 * Enregistre l'avancement au sein de la s�rie.
	 * @param object ResultatEvaluation $obj_resultat : Resultat associ� � l'objet associ� � l'avancement.
	 * @return boolean true si l'evaluation � bien �t� termin�e, false sinon. 
	 */
	function end($obj_resultat){
		//print_rr($obj_resultat);
		messageDebug("DoEvaluation::end(\$obj_resultat)");
		if(is_object($obj_resultat)&&$obj_resultat->verify($this->obj_node)){
			$this->fin=set_resultat_serie_fin($this->getResultat(), $this->getEvaluation());
			if(!$this->fin){
				die("Erreur DoEvaluation::end(): L'�valuation n'a pas �t� termin�e.<br>");
			}
		}else{
			
			print("Erreur DoEvaluation::end(): L'�valuation n�cessite en paramatre un objet Resultat valide pour �tre termin�e.et toc<br>");
		}
		return true;
	}	
	
	
		
	/**
	 * Termine l'evaluation  courante 
	 * Enregistre la date de fin de l'�valuation si besoin et detruit les attributs de l'objet inutiles.
	 * @param object ResultatSerie $obj_resultat : Resultat associ� � l'objet associ� � l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succ�s ou non de la m�thode.
	 */
	function abord(){
		messageDebug("DoEvaluation::abord()");
		if(!empty($this->resultat)){
			$this->fin=set_resultat_serie_fin($this->getResultat(), $this->getEvaluation());
			if(!$this->fin){
				die("Erreur DoEvaluation::abord(): L'�valuation n'a pas �t� abandonn�e.<br>");
				return false;
			}else{
				unset($this->obj_node);
				return true;
			}
		}
		else{
			die("Erreur DoEtape::abordCurrentEtape(): Une �tape peut etre abandonn�e seulemenent si elle a �t� commenc�e.<br>");
			return false;
		}
		
	}
//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------

	/**
	 * Indique si l'Evaluation est finie ou non.
	 * @return boolean TRUE ou FALSE.
	 */
	function isEnd(){
		if(!$this->isBegin())return false;
		
		$row_resultat=pg_fetch_row(get_resultat_serie_evaluation($this->getResultat(), $this->getEvaluation()));
		if(!empty($row_resultat[3]))return true;
		
		return false;	
	}

	/**
	 * Indique si l'Evaluation est commenc�e ou non.
	 * @return boolean TRUE ou FALSE.
	 */
	function isBegin(){
		$row_resultat=pg_fetch_row(get_resultat_serie_evaluation($this->getResultat(), $this->getEvaluation()));
		if(!empty($row_resultat[2]))return true;
		
		return false;	
	}	
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	function getResultat(){
		return $this->resultat;
	}
	
	function getType(){
		return $this->node_type;;
	}

	function getLibelleType(){
		return get_evaluation_type_libelle($this->getType());
	}
		
	function getLibelle(){
		return $this->obj_node->getLibelle();
	}
	
	function getEvaluation(){
		return $this->node;
	}
	
	function &getObjEvaluation(){
		return $this->obj_node;
	}
	
	function &getSrcEvaluation(){
		return EvaluationFactory::createEvaluation($this->node, $this->node_type);
	}
	
	function &getEvaluationFactory(){
		return $this->obj_EvaluationFactory;
	}	
	
	function getIndice(){
		return $this->indice;
	}
	
//	function getChrono(){
//		$res=get_serie_evaluation($this->getEntity(),$this->getEvaluation());
//		$chrono_evaluation=pg_fetch_result($res,0,6);
//		
//		return $chrono_evaluation;
//	}
	
	
	/**
	 * Retourne le temps restant pour le chrono,  en secondes.
	 * Attention, ce temps est calcul� par rapport � la somme des dur�es des �valuations.
	 * Les �valuation non termin�es ne sont donc pas prises en compte.
	 */
	function getChronoRestant($obj_liste,$chrono_restant=null){
		
			if(is_null($chrono_restant))
				$tmp_chrono=$obj_liste->getChronoEvaluation($this->getEvaluation());
			else
				$tmp_chrono=$chrono_restant;
				
			if($this->debut&&$tmp_chrono)
					
			return  get_seconds_from_timestamp($this->debut,$tmp_chrono);
	}
	
	
	function isChronoValid($obj_liste,$chrono_restant){
		
		$chrono_evaluation=$obj_liste->getChronoEvaluation($this->getEvaluation());
		if(is_null($chrono_restant)&&is_null($chrono_evaluation)){
//			echo "chrono valide car innexistant";
			return true;
		}
		
		$chrono_restant=$this->getChronoRestant($obj_liste,$chrono_restant);
//		echo"\$chrono_restant=$chrono_restant<br>";
		if(!is_null($chrono_restant)&&$chrono_restant<=0){
			
//		echo "IIIIIIIIINNNNNNNNNNNVVVVVVVALID!";
			return false;
		}else{
			return true;
		}
	}
	
}
?>
