<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets d'avancement pour les Evaluations.
 * 
 * La fabrique doit tre initialise avec des identifiants de Formation, d'Individu ainsi qu'avec une
 * fabrique permettant de crer les objets associs aux objets d'avancement.
 * 
 * Cet objet permet ensuite d'obtenir, par la mthode createDoEvaluation(), un objet d'avancement pour le rsultat et l'Evaluation spcifie (identifiant et type).
 * 
 * @package evaluation
 */
class DoEvaluationFactory extends DoNodeFactory{
	
	/**
	 * Constructeur de la fabrique.
	 * @param integer $formation Identifiant de la formation.
	 * @param integer $individu Identifiant de l'individu.
	 * @param object EvaluationFactory &$obj_EvaluationFactory Fabrique des objets associs aux objets d'avancement. 
	 */
	function DoEvaluationFactory($formation,$individu,&$obj_EvaluationFactory){
		parent::DoNodeFactory($formation,$individu,&$obj_EvaluationFactory);
	}
	
	/**
	 * Cre un objet d'avancement pour une Evaluation.
	 * @param integer $resultat identifiant du rsultat (formation, individu, parcours et tape)
	 * @param integer $evaluation identifiant de l'valuation.
	 * @param integer $type identifiant du type de l'valuation.
	 * @param integer $indice Indice de l'valuation.
	 * 
	 * @return  object DoEvaluation  l'objet d'avancement dsir
	 */
	function &createDoEvaluation($resultat,$evaluation,$type, $indice){
		
		switch($type){
			case TYPE_EVALUATION_QCM;
				return new DoQcm($resultat,$evaluation,$indice,$this->getEvaluationFactory());
				break;
			case TYPE_EVALUATION_SONDAGE;
				return new DoSondage($resultat,$evaluation,$indice,$this->getEvaluationFactory());
				break;
			case TYPE_EVALUATION_FTB;
				return new DoFtb($resultat,$evaluation,$indice,$this->getEvaluationFactory());
				break;
			case TYPE_EVALUATION_QRC;
				return new DoQrc($resultat,$evaluation,$indice,$this->getEvaluationFactory());
				break;
			case TYPE_EVALUATION_SRC;
				return new DoSrc($resultat,$evaluation,$indice,$this->getEvaluationFactory());
				break;
			case TYPE_EVALUATION_QUESTION_POSITIONNEMENT;
				return new DoQuestionPositionnement($resultat,$evaluation,$indice,$this->getEvaluationFactory());
				break;
			default:
				die("Erreur createDoEvaluation(".$this->getEvaluationFactory()."$resultat,$evaluation,$type,$indice): Le type '$type' est inconnu.<br>");																				
		}
	}
	
	/**
	 * Obtenir la fabrique des objets associs (Evaluations).
	 * @return  object EvaluationFactory la fabrique des objets associs aux objets d'avancement de cette fabrique.
	 */
	function &getEvaluationFactory(){
		return parent::getNodeFactory();
	}
}
?>
