<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Evaluation.
 *	Une Evaluation est un objet driv de Node.
 *
 *	@package evaluation
 */
class Evaluation extends Node{

	/**
	 * Construit une Evaluation.
	 * L'Evaluation peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de l'Evaluation
	 * @param string $libelle Libell
	 * @param string $type Type de QuestionReponse (QCM, Sondage, QSRC, ....)
	 * @param string $date_creation date de cration (format SQL)
	 */		
	function Evaluation($id, $libelle="Evaluation", $type="", $date_creation=""){
		messageDebug("Evaluation::Evaluation($id, $libelle, $type, $date_creation)");
		if(func_num_args()==1){
			$evaluation = get_evaluation($id);
			$row_evaluation=pg_fetch_row($evaluation,0);
			$libelle=$row_evaluation[1];
			//echo "lib=$libelle<br>";
			$type=$row_evaluation[2];
			$date_creation=$row_evaluation[3];
		}else{
		
		}
		parent::Node($id, $libelle, $type, $date_creation);
	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		$res_parent=parent::verifyInsert(&$message);
		$verif=Evaluation::verify(&$message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate(&$message);
		$verif=Evaluation::verify(&$message);
		
		return $res_parent && $verif && true;
	}
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Ne vrifie aucun attribut.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes (toujours), false si non (jamais).
	 */
	function verify(&$message){
		return true;
	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
		
	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string L'URL de l'icone
	 */	
	function getIcone(){
		global $serverback;
		return "http://$serverback/bo/images/txt.gif";
	}

	/**
	 * Obtenir l'icone associe au type de l'Etape.
	 * @return string L'URL de l'icone
	 */		
	function getIconeType(){
		return get_evaluation_type_icone($this->type);
	}
	
	function isNotable(){
		die("Evaluation :: isNotable() la mthode doit tre surcharge");
	}
	
}
?>