<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de d�finition de la classe Evaluation.
 *	Une Evaluation est un objet d�riv� de Node.
 *
 *	@package evaluation
 */
class EvaluationCorrection {

	var $obj_Evaluation;
	
	var $obj_EtapeCorrection;
	
	var $resultat;
	
	var $debut;

	var $fin;	
//	var $commentaire;

//	
//	var $points;
//	
//	var $chrono;
//	
//	var $bareme;
	
	/**
	 * Construit une Evaluation.
	 * L'Evaluation peut �tre construit � partir d'un identifiant (1 seul parametre), auquel cas les donn�es sont r�cup�r�es en base de donn�es,
	 * ou � partir de l'ensemble des donn�es (tous les parametres), pour ensuite �tre enregistr� en base.
	 *  
	 */		
	function EvaluationCorrection($obj_EtapeCorrection, $obj_Evaluation){
		messageDebug("EvaluationCorrection::EvaluationCorrection($obj_EtapeCorrection, $obj_Evaluation)");
		//print_rr($obj_Evaluation);
		$this->obj_Evaluation = $obj_Evaluation;
		$this->obj_EtapeCorrection=$obj_EtapeCorrection;
		$this->initEvaluationCorrection();
	}
	
	function initEvaluationCorrection(){
		
		//(id int8, evaluation int4, date_debut timestamp, date_fin timestamp)"; 
		$res=$this->obj_EtapeCorrection->resultat;
		
		$res_resultat=get_resultat_serie_evaluation($this->obj_EtapeCorrection->resultat, $this->obj_Evaluation->getId());
		if($res_resultat&&(pg_num_rows($res_resultat)==1)){
			$row_resultat=pg_fetch_row($res_resultat);
			$this->resultat=$row_resultat[0];
			$this->debut=$row_resultat[2];
			$this->fin=$row_resultat[3];
//			$this->date_creation=$row_resultat[2];
//			$this->commentaire=$row_resultat[3];
//			$this->bareme=$row_resultat[4];
//			$this->chrono=$row_resultat[5];
//			$this->points=$row_resultat[6];
		}
		else
			$this->resultat=$res;
		//on ne fait pas se test car il est possible qu'une valuation n'ai pas t faite
//		else{
//			die("Erreur EvaluationCorrection::EvaluationCorrection($obj_EtapeCorrection,$obj_Evaluation): L'objet d'avancement ne poss�de pas d'identifiant de r�sultat.(Le DoEtape a-t-il bien �t� commenc�?aa)");
//		}
	}
	
	function getNote(){
		die("EvaluationCorrection::getNote(): La mthode doit etre surcharge.");
	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir l'identifiant du parcours pourlequel l'objet d'avancement est utilis�.
	 * @return integer identifiant du parcours
	 */
	function getParcours(){
		return $this->obj_DoEvaluation->getParcours();
	}
	
	/**
	 * Obtenir l'identifiant de la formation pour laquelle l'objet d'avancement est utilis�.
	 * @return integer identifiant de la formation
	 */
	function getFormation(){
		return $this->obj_DoEvaluation->getFormation();
	}

	/**
	 * Obtenir le type de l'�tape 
	 * @return integer le type de l'objet d'avancement
	 */	
	function getType(){
		return $this->obj_Evaluation->getType();
	}
	
	function getLibelleType(){
		return get_evaluation_type_libelle($this->obj_Evaluation->getType());
	}
	
	function getLibelle(){
		return $this->obj_Evaluation->getLibelle();
	}
		
	function getDebut(){
		return $this->debut;
	}
	function getFin(){
		return $this->fin;
	}	
	
	function getDuree(){
		//echo $this->fin."-".$this->debut."=".($this->fin-$this->debut)."<br>";
		//return ($this->fin - $this->debut);
		return sec_to_txt(compte_temps($this->fin,$this->debut));
	}
	
//	function getCommentaire(){
//		return $this->commentaire;
//	}
	/**
	 * Obtenir l'identifiant resultat en base de donn�es.
	 * @return integer l'identifiant resultat en base de donn�es.
	 */	
	function getResultat(){
		return $this->resultat;
	}
	
	function getDureeFormate(){
    	return sql_interval_to_string($this->getDuree());
    }
    	
	function getDoEtape(){
		return $this->obj_EtapeCorrection->obj_DoEtape;
	}

	function getEtapeCorrection(){
		return $this->obj_EtapeCorrection;
	}
		
	/**
	 * Obtenir l'objet Evaluation.
	 * @param object EvaluationFactory &$obj_EvaluationFactory La fabrique pour constuire l'objet retourn�
	 * @return object Evaluation l'objet correspondant � l'�valuation.
	 */	
	function getEvaluation(){
		return $this->obj_Evaluation;
	}

	/**
	 * Obtenir l'objet Evaluation.
	 * @param object EvaluationFactory &$obj_EvaluationFactory La fabrique pour constuire l'objet retourn�
	 * @return object Evaluation l'objet correspondant � l'�valuation.
	 */	
	function getId(){
		return $this->obj_Evaluation->getId();
	}


	function isNotable(){
		return $this->obj_Evaluation->isNotable();
	}
//	function getBareme(){
//		return $this->bareme;
//	}
//	
//	function getObjBareme(){
//		return pg_fetch_object(get_bareme($this->bareme));
//	}
//	
//	function getChrono(){
//		return $this->chrono;
//	}
//	
//	function getPoints(){
//	return $this->points;
//}
}
?>