<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets EvaluationCorrectionAleatoire.
 * 
 * Cet objet permet d'obtenir, par la m�thode createEvaluation(), un objet EvaluationCorrection correspondant � un objet particulier.
 * 
 * @package evaluation
 */
class EvaluationCorrectionFactoryAleatoire extends EvaluationFactory{
	
	/**
	 * Cr�e un objet Evaluation.
	 * @param object $evaluation Identifiant de l'Evaluation � cr�er.
	 * @return object Evaluation l'objet Evaluation souhait�.
	 */	
	function createEvaluationCorrection($obj_EtapeCorrection, $obj_Evaluation){
		if(!is_object($obj_EtapeCorrection)||!is_object($obj_Evaluation)){
			die("EvaluationCorrectionFactoryAleatoire::createEvaluationCorrection($obj_EtapeCorrection, $obj_Evaluation): Le parametre est invalide.<br>");
		}
		
		switch($obj_Evaluation->getType()){
			case TYPE_EVALUATION_QCM;
				return new QcmCorrectionAleatoire($obj_EtapeCorrection, $obj_Evaluation);
				break;
			case TYPE_EVALUATION_SONDAGE;
				return new SondageCorrectionAleatoire($obj_EtapeCorrection, $obj_Evaluation);
				break;
			case TYPE_EVALUATION_FTB;
				return new FtbCorrectionAleatoire($obj_EtapeCorrection, $obj_Evaluation);
				break;
			case TYPE_EVALUATION_QRC;
				return new QrcCorrectionAleatoire($obj_EtapeCorrection, $obj_Evaluation);
				break;
			case TYPE_EVALUATION_SRC;
				return new SrcCorrectionAleatoire($obj_EtapeCorrection, $obj_Evaluation);
				break;
			case TYPE_EVALUATION_QUESTION_POSITIONNEMENT;
				return new QuestionPositionnementCorrectionAleatoire($obj_EtapeCorrection, $obj_Evaluation);
				break;
			default:
				die("Erreur createEvaluationCorrectionAleatoire($obj_EtapeCorrection, $obj_Evaluation): Le type '".$obj_DoEvaluation->getType()."' est inconnu.<br>");																				
		}
	}
}
?>
