<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique des objets Evaluation.
 * 
 * Cet objet permet d'obtenir, par la mthode createEvaluation(), un objet Evaluation correspondant  un objet particulier.
 * 
 * @package evaluation
 */
class EvaluationFactory extends NodeFactory{
	
	/**
	 * Cre un objet Evaluation.
	 * @param integer $evaluation Identifiant de l'Evaluation  crer.
	 * @param integer $type Type de l'Evaluation
	 * @return object Evaluation l'objet Evaluation souhait.
	 */	
	function createEvaluation($evaluation, $type){
		switch($type){
			case TYPE_EVALUATION_QCM;
				return new Qcm($evaluation);
				break;
			case TYPE_EVALUATION_SONDAGE;
				return new Sondage($evaluation);
				break;
			case TYPE_EVALUATION_FTB;
				return new Ftb($evaluation);
				break;
			case TYPE_EVALUATION_QRC;
				return new Qrc($evaluation);
				break;
			case TYPE_EVALUATION_SRC;
				return new Src($evaluation);
				break;
			case TYPE_EVALUATION_QUESTION_POSITIONNEMENT;
				return new QuestionPositionnement($evaluation);
				break;
			default:
				die("Erreur createEvaluation($evaluation, $type): Le type '$type' est inconnu.<br>");																				
		}
	}
}
?>
