<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique d'objets drivs de la classe Resultat.
 * Ces objets sont requis par les mthode endCurrentEtape() des
 * classes DoNode.
 * Dfini les valeurs ncessaires  la fin des Nodes et fourni des mthodes
 * de d'initialisation et de vrification de ces valeurs.
 * 
 * @package evaluation
 */
class ResultatEvaluationFactory extends ResultatFactory{
	
	/**
	 * Constructeur de la fabrique.
	 */
	function ResultatEvaluationFactory(){
		messageDebug("ResultatEvaluationFactory::ResultatFactory()");
	}
	
	/**
	 * Cre un objet ResultatEvaluation
	 * @param integer type d'valuation pour lequel l'objet ResultatEvaluation est requis.
	 * @return object ResultatEvaluation l'objet ResultatEvaluation souhait.
	 */
	function &createResultatEvaluation($type){
		messageDebug("ResultatEvaluationFactory::createResultatEvaluation($type)");

		switch($type){
			case TYPE_EVALUATION_QCM;
				return new ResultatQcm();
			case TYPE_EVALUATION_SONDAGE;
				return new ResultatSondage();
			case TYPE_EVALUATION_FTB;
				return new ResultatFtb();
			case TYPE_EVALUATION_QRC;
				return new ResultatQrc();
			case TYPE_EVALUATION_SRC;
				return new ResultatSrc();
			case TYPE_EVALUATION_ELEMENT_POSITIONNEMENT;
				return new ResultatQuestionPositionnement();
			default:
				die("ResultatEvaluationFactory::createResultatEvaluation($type): Le type '$type' est inconnu.<br>");																				
		}
		
	}
}
?>
