<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
 * Created on May 9, 2006
 *
 * @author Rmi Cocquet
 * @package evaluation
 * @modulegroup fonctions
 */

/**
 * Retourne le type d'evaluation  partir du code (lettre).
 * Le code peut etre q,s,f,m ou o.
 * La valeur retourne depend du shema de la base.
 * Renvoie le code si on est sur l'ancienne base, le numero si on est sur la nouvelle.
 * @param varchar: le code du type
 * @return interger : l'entier correspondant au code ou  le code lui meme.
 */
function get_evaluation_type_old_new($old_type) {
	if (VERSION_BASE > VERSION) {
		switch ($old_type) {
			case "q" :
				return 1;
			case "s" :
				return 2;
			case "f" :
				return 3;
			case "m" :
				return 4;
			case "o" :
				return 5;
			default :
				return $old_type;
		}
	} else {
		return $old_type;
	}
}

/**
 * Retourne le type d'evaluation  partir du numero (nouvelle base).
 * Le code retourn peut etre q,s,f,m ou o.
 * La valeur retourne depend du shema de la base.
 * Renvoie le numero si on est sur la nouvelle base, le code si on est sur l'ancienne.
 * @param integer: le code du type
 * @return varchar : le code correspondant a l'entier ou  l'entier lui meme.
 */
function get_evaluation_type_new_old($new_type) {
	if (VERSION_BASE > VERSION) {
		switch ($new_type) {
			case 1 :
				return "q";
			case 2 :
				return "s";
			case 3 :
				return "f";
			case 4 :
				return "m";
			case 5 :
				return "o";
			default :
				return $new_type;
		}
	} else {
		return $new_type;
	}
}

/**
 * Retourne le type d'evaluation  partir du code (lettre).
 * Fonction inverse de get_evaluation_type_old_new()
 * Le code peut etre q,s,f,m ou o.
 * La valeur retournee depend du shema de la base.
 * Renvoie le numero si on est sur l'ancienne base, le code si on est sur la nouvelle.
 * @param varchar: le code du type
 * @return interger : l'entier correspondant au code ou  le code lui meme.
 */
function get_evaluation_type_old_new_r($old_type) {
	if (VERSION_BASE < VERSION) {
		switch ($old_type) {
			case "q" :
				return 1;
			case "s" :
				return 2;
			case "f" :
				return 3;
			case "m" :
				return 4;
			case "o" :
				return 5;
			default :
				return $old_type;
		}
	} else {
		return $old_type;
	}
}

/**
 * Retourne le type d'evaluation  partir du numero (nouvelle base).
 * Fonction inverse de get_evaluation_type_new_old().
 * Le code retourn peut etre q,s,f,m ou o.
 * La valeur retourne depend du shema de la base.
 * Renvoie le code  si on est sur la nouvelle base, le numero si on est sur l'ancienne.
 * @param integer: le code du type
 * @return varchar : le code correspondant a l'entier ou  l'entier lui meme.
 */
function get_evaluation_type_new_old_r($new_type) {
	if (VERSION_BASE < VERSION) {
		switch ($new_type) {
			case 1 :
				return "q";
			case 2 :
				return "s";
			case 3 :
				return "f";
			case 4 :
				return "m";
			case 5 :
				return "o";
			default :
				return $new_type;
		}
	} else {
		return $new_type;
	}
}

function get_evaluation_type_libelle($type) {
	global $MSG_547, $MSG_1483, $MSG_1372, $MSG_1863, $MSG_1864;

	switch ($type) {
		case 'q' :
		case 1 :
			$libelle = $MSG_547; //QCM
			break;
		case 's' :
		case 2 :
			$libelle = $MSG_1483; //SONDAGE
			break;
		case 'f' :
		case 3 :
			$libelle = $MSG_1372; //FTB
			break;
		case 'm' :
		case 4 :
			$libelle = $MSG_1863; //QRC
			break;
		case 'o' :
		case 5 :
			$libelle = $MSG_1864; //SRC
			break;
		default :
			$libelle = "Erreur fonction get_evaluation_type_libelle($type) :type d'evaluation non reconnu($type)";
	}
	return $libelle;
}

function get_evaluation_type_icone($type) {
global $serverback;
//print("cherche icone pour le type $type");
	switch ($type) {
		case 'q' :		
		case 1 :
			$img_type = "http://$serverback/bo/images/ico_type/ico_qcm.gif";//QCM
			break;
		case 's' :
		case 2 :
			$img_type = "http://$serverback/bo/images/ico_type/ico_sondage.gif";//SONDAGE
			break;
		case 'f' :						
		case 3 :
			$img_type = "http://$serverback/bo/images/ico_type/ico_ftb.gif";//FTB
			break;
		case 'm' :			
		case 4 :
			$img_type = "http://$serverback/bo/images/ico_type/ico_qrc.png"; //QRC
			break;
		case 'o' :			
		case 5 :
			$img_type = "http://$serverback/bo/images/ico_type/ico_src.png"; //SRC
			break;
		case 6 :
			$img_type = "http://$serverback/bo/images/ico_type/ico_vide.gif"; //ELEMENT DE TEST
		default : //SERIE (multievaluations)
			$img_type="http://$serverback/bo/images/ico_type/ico_vide.gif";
	}
	return $img_type;
}

/**
	Savoir si une evaluation a des resultats
	* @param integer idendifiant de l'evaluation
	* @return integer: vrai si resultat, faux sinon
*/
function is_evaluation_resultats($evaluation){
	$res=get_evaluation_resultats($evaluation);
	if(pg_num_rows($res)>0)
		return true;
	return false;
}


/**
 * Savoir si une evaluation est modifiable ou supprimable.
 * 2: l' evaluation est supprimable
 * 1: elle n'est que modifible 
 * 0: elle n'est ni modifiable ni supprimable
 *  
 * @param integer idendifiant de l'evaluation
 * @return integer: 0,1,ou 2
 */
function get_evaluation_actions($evaluation, $type='NULL'){
    
    $action=2;

    // test si le qsrc est dans une serie
    $res_series=get_evaluation_series($evaluation, $type);
    $nb_series=pg_num_rows($res_series);
    if($nb_series>0&&pg_fetch_result($res_series,0,0)!='NULL'){
    	$action=1;
    	
    	// aucune action si l'evaluation est enregistre (il y a des resultats)
		if(is_evaluation_resultats($evaluation))
			$action=0;
		else{
			$action=1;
		}
		
    	//on  rcupere les actions pour chacunes des sries
//    	for($i=0; $i<$nb_series;$i++){
//    		$action_serie=get_serie_actions(pg_fetch_result($res_series,0,0));
//    		if($action_serie==0){
//    			$action=0;
//				return $action;
//    		}
//			/*
//			else{
//				// il faut tester si l'valuation est enregistre (A Suivre ...)
//			}
//			*/
//    	}
    }
    return $action;
}


?>
