<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
 * @package evaluation
 *@modulegroup plpgsql
 *@module plpgsql_evaluation
 */

include ("$root/lib/evaluation/plpgsql_deprecated_evaluation.inc");

///**
//      Obtenir le numero de srie pour une valuation donne (OLD)
//
//    @param integer : le numero d'exo
//    @param char : le type d'exo
//    @return integer : le resultat de la requete
//*/
//function get_evaluation_serie_old($evaluation, $type = 'NULL') {
//	if ($type)
//		$sql = "SELECT id_serie FROM asso_exo_serie WHERE id_exo=$evaluation AND type_exo='$type'";
//	else
//		print ("A implmenter");
//	$res = pg_query($sql);
//	return $res;
//}

///**
//    Obtenir le numero de srie pour une valuation donne
//
//    @param integer : le numero d'exo
//    @param char : le type d'exo
//    @return integer : le resultat de la requete
//*/
//function get_evaluation_serie($evaluation, $type = 'NULL', $id_qcm = 0) {
//	if (VERSION_BASE > VERSION) {
//		//$sql="select id_serie,id_eval from contraintes.af_get_evaluation_series($id_qcm) as (id_serie int4,id_eval int4)";
//		//echo "sql=$sql<br>";
//		$res = pg_query($sql);
//	} else
//		$res = get_evaluation_serie_old($evaluation, $type);
//	return $res;
//}

///**
//	Obtenir les numeros et noms de formation pour une valuation donne (OLD)
//
// 	@param integer : le numero d'exo
//    @param char : le type d'exo
//	@param char : ordre de classement
//    @return integer : le resultat de la requete
//*/
//function get_evaluation_formations_infos_old($evaluation, $type = 'NULL', $desc = "") {
//	$sql = "select distinct C.num_cal,C.nom_cal from gestparcours G1,gestionnaire G2,calendrier C where num_c_q_e_d in
//				(select distinct id_serie from asso_exo_serie where id_exo=$evaluation and type_exo='$type')
//				and type_etape='B' and G1.g_num_parcours=G2.g_num_parcours and G2.g_num_cal=C.num_cal
//				order by C.nom_cal $desc";
//	//echo "sql=$sql<br>";
//	return (pg_query($sql));
//}
///**
//	Obtenir les numeros et noms de formation pour une valuation donne
//
// 	@param integer : le numero d'exo
//    @param char : le type d'exo
//	@param char : ordre de classement
//    @return integer : le resultat de la requete
//*/
//function get_evaluation_formations_infos($evaluation, $type = 'NULL', $desc = "") {
//	if (VERSION_BASE > VERSION) {
//		//$sql="select id_serie,id_eval from contraintes.af_get_evaluation_series($id_qcm) as (id_serie int4,id_eval int4)";
//		//echo "sql=$sql<br>";
//		$res = pg_query($sql);
//	} else
//		$res = get_evaluation_formations_infos_old($evaluation, $type, $desc);
//	return $res;
//}

/**
	Obtenir les series pour une valuation et une formation donnes (OLD)

 	@param integer : le numero d'valuation
	@param integer : le numero de formation
 	@return integer : le resultat de la requete
*/
function get_evaluation_series_infos_formation_old($evaluation, $formation, $type = "") {
	if ($formation != 'NULL')
		$sql = "select distinct titre from serie_exo,asso_exo_serie where id in
						(select num_c_q_e_d from gestionnaire,gestparcours where gestionnaire.g_num_parcours=gestparcours.g_num_parcours and g_num_cal=$formation)
						and id=id_serie and id_exo=$evaluation order by titre";
	else
		$sql = "select distinct titre from asso_exo_serie A,serie_exo S where id_exo=$evaluation and A.id_serie=S.id
						and S.id not in (select num_c_q_e_d from gestparcours where type_etape='B')
						and type_exo='$type' order by titre";
	//echo "sql=$sql<br>";
	return (pg_query($sql));
}
/**
	Obtenir les series pour une valuation et une formation donnes

 	@param integer : le numero d'valuation
	@param integer : le numero de formation
 	@return integer : le resultat de la requete
*/
function get_evaluation_series_infos_formation($evaluation, $formation, $type = "") {
	if (VERSION_BASE > VERSION) {
		$res = pg_query($sql);
	} else
		$res = get_evaluation_series_infos_formation_old($evaluation, $formation, $type);
	return $res;
}

/**
	Obtenir les numero et nom des classes pour une evaluation donne (OLD)

 	@param integer : le numero d'valuation
 	@param char : le type d'valuation
 	@param string : l'ordre pour classement
 	@return integer : le resultat de la requete
*/
function get_evaluation_classes_infos_old($evaluation, $type, $desc) {
	$sql = "select distinct C.id,C.nom from gestparcours G1,gestionnaire G2,classe C where num_c_q_e_d in
				(select id_serie from asso_exo_serie where id_exo=$evaluation and type_exo='$type')
				and type_etape='B' and G1.g_num_parcours=G2.g_num_parcours and G2.g_num_gest_g=C.id order by C.nom $desc";
	//echo "sql=$sql<br>";
	return (pg_query($sql));
}
/**
	Obtenir les numero et nom des classes pour une evaluation donne

 	@param integer : le numero d'valuation
 	@param char : le type d'valuation
 	@param string : l'ordre pour classement
 	@return integer : le resultat de la requete
*/
function get_evaluation_classes_infos($evaluation, $type, $desc) {
	if (VERSION_BASE > VERSION) {
		$res = pg_query($sql);
	} else
		$res = get_evaluation_classes_infos_old($evaluation, $type, $desc);
	return $res;
}

/**
	Obtenir les numeros et noms de formation pour une evaluation et une classe donns (OLD)

	@param integer : le numero d'valuation
	@param integer : le numero de classe
 	@param char : le type d'exo
 	@return integer : le resultat de la requete
*/
function get_evaluation_formations_infos_classe_old($evaluation, $classe, $type) {
	$sql = "select distinct C.num_cal,C.nom_cal from gestparcours G1,gestionnaire G2,calendrier C where num_c_q_e_d in
				(select distinct id_serie from asso_exo_serie where id_exo=$evaluation and type_exo='$type')
				and type_etape='B' and G2.g_num_parcours=G1.g_num_parcours and G2.g_num_gest_g=$classe and G2.g_num_cal=C.num_cal order by C.nom_cal";
	return (pg_query($sql));
}
/**
	Obtenir les numeros et noms de formation pour une evaluation et une classe donns

	@param integer : le numero d'valuation
	@param integer : le numero de classe
 	@param char : le type d'exo
 	@return integer : le resultat de la requete
*/
function get_evaluation_formations_infos_classe($evaluation, $classe, $type) {
	if (VERSION_BASE > VERSION) {
		$res = pg_query($sql);
	} else
		$res = get_evaluation_formations_infos_classe_old($evaluation, $classe, $type);
	return $res;
}

/**
	Obtenir le nombre de resulats pour une evaluation et un type donnes (OLD)

 	@param integer : le numero de l'evaluation
 	@return integer : le resultat de la requete
*/
function get_evaluation_nombre_resultats_old($evaluation, $type) {
	$sql = "select * from res_serie_exo R,asso_exo_serie A
				where A.id_serie=R.id_serie and A.type_exo='$type' and ordre=ordre_etape
				and id_exo=$evaluation";
	return (pg_query($sql));
}
/**
	Obtenir le nombre de resulats pour une evaluation et un type donnes

 	@param integer : le numero de l'evaluation
 	@return integer : le resultat de la requete
*/
function get_evaluation_nombre_resultats($evaluation, $type) {
	if (VERSION_BASE > VERSION) {
		$res = pg_query($sql);
	} else
		$res = get_evaluation_nombre_resultats_old($evaluation, $type);
	return $res;
}

/**
	Obtenir le nombre de resultats d'un element de question_reponse pour  pour un type donne (OLD)

	@param integer : le numero d'evaluation
	@param integer : le numero d'element
	@param string : le type d'element
 	@return integer :   le resultat de la requete
*/
function get_evaluation_element_nombre_resultats_old($evaluation, $element, $type) {
	$sql = "select * from res_serie_exo R,asso_exo_serie A
				where A.id_serie=R.id_serie and R.reponse=$element
				and A.type_exo='$type' and ordre=ordre_etape
				and id_exo=$evaluation";
	return (pg_query($sql));
}
/**
	Obtenir le nombre de resultats d'un element de question_reponse pour  pour un type donne

	@param integer : le numero d'evaluation
	@param integer : le numero d'element
	@param string : le type d'element
 	@return integer :   le resultat de la requete
*/
function get_evaluation_element_nombre_resultats($evaluation, $element, $type) {
	if (VERSION_BASE > VERSION) {
		$res = pg_query($sql);
	} else
		$res = get_evaluation_element_nombre_resultats_old($evaluation, $element, $type);
	return $res;
}

/**
 * Supprimme une valuation
 * 
 */
function del_evaluation($evaluation) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_del_evaluation($evaluation)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		print ("La fonction del_evaluation($evaluation) n'existe pas pour la version " .
		VERSION);

	return $res;
}

/**
    Obtenir les numeros de sries dans lesquelles une valuation est utilise (OLD)

    @param integer : le numero d'exo
    @param char : le type d'exo
    @return integer : le resultat de la requete (serie int4,libelle varchar, evaluation int4)
*/
function get_evaluation_series_old($evaluation, $type, $classement="ASC") {
	$sql = "SELECT id_serie, titre, id_exo FROM asso_exo_serie, serie_exo WHERE id_exo=$evaluation AND type_exo='$type' AND id_serie=id ORDER BY titre $classement";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les numeros de sries dans lesquelles une valuation est utilise 

    @param integer : le numero d'exo
    @param char : le type d'exo
	@param char : ordre de classement (ASC ou DESC)
    @return integer : le resultat de la requete (serie int4,libelle varchar, evaluation int4)
*/
function get_evaluation_series($evaluation, $type = 'NULL', $classement="ASC") {
	if (VERSION_BASE > VERSION) {
		if($classement=="DESC")$ordre="order by libelle DESC";
		else $ordre="";
		$sql = "select * from contraintes.af_get_evaluation_series($evaluation) as (serie int4,libelle varchar, evaluation int4) $ordre";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_evaluation_series_old($evaluation, $type, $classement);
	return $res;
}

/**
 * Crer une valuation
 * @param string : le libelle de l'evaluation
 * @return integer : l'identifiant de la nouvelle evaluation
 */
function set_evaluation($libelle, $type) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_set_evaluation('$libelle', $type)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = set_evaluation_old($libelle);
	return pg_fetch_result($res, 0, 0);
}

/**
 * Met a jour le libell d'une valuation
 * @param integer : le numero de l'evaluation
 * @param string : le libelle de l'evaluation
 * @return integer : l'identifiant de la nouvelle evaluation
 */
function maj_evaluation($evaluation, $libelle) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_maj_evaluation($evaluation, '$libelle')";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		print ("La fonction maj_evaluation($evaluation, $libelle) n'existe pas pour la version " .
		VERSION);
	return pg_fetch_result($res, 0, 0);
}

/**
 * Obtenir une valuation (OLD)
 * @param integer : l'identifiant de l'evaluation
 * @param char : le type de l'valuation (q,s,f,m ou o)
 * @return integer : le resultat de la requete (id int4, libelle varchar, type int4)
 */
function get_evaluation_old($evaluation, $type='type manquant') {
	switch ($type) {
		case 'q':
		case 1:
			$sql="	SELECT num_question, libelle_question, 'q'
					FROM question
					WHERE num_question=$evaluation";
			break;
		case 's':
		case 2:
			$sql="	SELECT num_sondage, question, 's'
					FROM question_sondage
					WHERE num_sondage=$evaluation";
			break;
		case 'f':
		case 3:
			$sql="	SELECT id, text, 'f'
					FROM gest_ftb
					WHERE id=$evaluation";
			break;
		case 'm':
		case 'o':
		case 4:
		case 5:
			$sql = "SELECT id_test, titre, '$type' 
					FROM test, serie_exo 
					WHERE id_test=$evaluation
					AND id=id_test";
			break;
		default:
			die("Erreur fonction get_evaluation_old():<br> type d'evaluation non reconnu ($type)");
			break;
	}
	//echo "$sql<br>";
	return pg_query($sql);
}

/**
 * Obtenir une valuation
 * @param integer : l'identifiant de l'evaluation
 * @return integer : le resultat de la requete (id int4, libelle varchar, type int4)
 */
function get_evaluation($evaluation, $type='') {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_evaluation($evaluation) AS (id int4, libelle varchar, type int4, date_modification timestamp)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_evaluation_old($evaluation,$type);
	return $res;
}

function get_evaluation_types(){
	$sql = "select * from contraintes.af_get_evaluation_types() AS (id int4, libelle varchar, code varchar, couleur char(6))";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	return $res;
}
function get_evaluation_type($type){
	$sql = "select * from contraintes.af_get_evaluation_type($type) AS (id int4, libelle varchar, code varchar, couleur char(6))";
//	echo "sql=$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
	Supprime les resultats pour une ou plusieurs evaluations pour un individu (old)
	@param integer : id resultat
	@param array : les evaluations
	@return res req
*/
function del_evaluation_resultat_individu_old($resultat,$evaluations){

}
/**
	Supprime les resultats pour une ou plusieurs evaluations pour un individu 
	@param integer : id resultat
	@param array : les evaluations
	@return res req
*/
function del_evaluation_resultat_individu($resultat,$evaluations){
	if (VERSION_BASE > VERSION) {
		$sql_evaluations=int_array_to_plpgsql_array($evaluations);
		$sql="select * from contraintes.af_del_evaluation_resultat_individu($resultat,$sql_evaluations)";
		//echo "sql=$sql<br>";
		return pg_query($sql);
	}
	else
		return del_evaluation_resultat_individu_old($resultat,$evaluations);
}

/**
   Obtenir les resultat pour une evaluation
   @param integer : id evaluation
   @return res req
*/
function get_evaluation_resultats($evaluation){
	 if (VERSION_BASE > VERSION) {
		  $sql="select * from contraintes.af_get_evaluation_resultats($evaluation) as (id int8,evaluation int4,date_creation timestamp,date_fin timestamp)";
		  //echo "sql=$sql<br>";
		  return pg_query($sql);
	 }
	else
		return get_evaluation_resultats_old($evaluation);
}
?>