<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fichier de fonctions evenement
	@package evenement
	@modulegroup plpgsql
	@module plpgsql_evenement
*/

/**
	Retourne les intervenants des evenements  (OLD)
	@param integer : modalite
	@return integer : resultat req (id,nom,prenom)
*/
function get_evenement_intervenants_old($modalite){
	$sql="select distinct num_user,nom,prenom from utilisateurs,gest_cal where num_user=num_intervenant";
	if($modalite!=0)
		$sql .=" and num_type=$modalite";
	$res=pg_query($sql);
}
/**
	Retourne les intervenants des evenements 
	@param integer : modalite
	@return integer : resultat req (id,nom,prenom)
*/
function get_evenement_intervenants($modalite=0){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_evenement_intervenants($modalite) as (id int4,nom varchar,prenom varchar)";
		$res=pg_query($sql);
	}
	else
		return get_evenement_intervenants_old($modalite);
	return $res;
}
?>