<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoExotlc.
 * Un DoExotlc est l'objet servant  gerer l'avancement des
 * Etapes de type Exotlc d'un parcours.
 * 
 * @package exotlc
 */
class DoExotlc extends DoEtapeRenewable{
	
	/**
	 * @var string Date de correction de l'Exotlc au format SQL
	 */
	var $date_correction;
	
	/**
	 * @var string Commentaire associ  la correction de l'Exotlc
	 */
	var $commentaire;

	/**
	 * @var boolean Indique si la correction de l'Exotlc est tlchargeable par le stagiaire si elle existe
	 */	
	var $correction;

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'Exotlc
	 */
	function DoExotlc($formation,$individu,$parcours,$etape){
		messageDebug("DoExotlc::DoExotlc($formation,$individu,$parcours,$etape)");
		parent::DoEtape($formation,$individu);
		$this->initDoExotlc($parcours,$etape);
	}

	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * 
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'EtapeForum
	 */		
	function initDoExotlc($parcours,$etape){
		messageDebug("DoExotlc::initDoExotlc($parcours,$etape)");
		parent::initDoEtapeRenewable($parcours,$etape, TYPE_ETAPE_EXOTLC);
	}
	
//-----------------------------------------------------
//			METHODES
//-----------------------------------------------------
	
//	/**
//	 * Surcharge de la fonction parente.
//	 * Identique  la fonction de la classe pre, mais ne provoque pas d'erreur si l'tape est dja commence mais 
//	 * recupere et affecte l'identifiant resultat a l'objet.
//	 * @return integer idenfiant rsultat en base de donnes
//	 */
//	function beginCurrentEtape(){
//		messageDebug("DoExotlc::beginCurrentEtape()");
//		return parent::beginCurrentEtape();
//		$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
//		if(pg_num_rows($res_resultat)==1){
//			$row_resultat=pg_fetch_row($res_resultat);
//			$id_resultat=$row_resultat[0];
//			$duree_resultat=$row_resultat[6];
//		}
//		if(!empty($id_resultat)){
//			if(!empty($duree_resultat)){
//				$this->resultat=$id_resultat;
//			}else{
//				die("Erreur DoEtape::beginCurrentEtape(): l'tape a dj t commence et n'est pas termine.<br/>");				
//			}
//		}else{
//			$this->resultat=set_resultat_debut($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape() );
//		}
//		return $this->resultat;
//	}

	/**
	 * Construction de l'objet associ  cet objet d'avancement.
	 * Cette mthode ncssite un identifiant rsultat. Ainsi, si cet identifiant n'est pas dj valu, on le recupre en base de donnes.
	 * Si cet identifiant n'a jamais t cr (par un appel prcdent  beginCurrentEtape()), une erreur est gnre.
	 * Dans le cas contraire, l'objet Exotlc est cr et retourn par la mthode.
	 * @param object EtapeFactory &$obj_EtapeFactory Fabrique servant  crr les objets, dont l'Exotlc
	 * @return object Exotlc : L'objet associ  cet objet d'avancement.
	 */	
	function performCurrentEtape(&$obj_EtapeFactory){
		messageDebug("DoExotlc::performCurrentEtape($obj_EtapeFactory)");
//		return parent::performCurrentEtape($obj_NodeFactory);
		parent::perform($obj_EtapeFactory);
		if(empty($this->resultat)){
			$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
			if(pg_num_rows($res_resultat)==1){
				$row_resultat=pg_fetch_row($res_resultat);
				$id_resultat=$row_resultat[0];
				if(!empty($id_resultat)){
					$this->resultat=$id_resultat;
				}
			}
		}
		if(!empty($this->resultat)&&is_object($obj_EtapeFactory)){
			$res=get_resultat_exotlc($this->resultat);
			$row=pg_fetch_row($res);
//				print_rr($row);
			if(!empty($row)){
				
			
	//			$this->fichier_rendu=$row[9];
				$this->commentaire=$row[7];
				$this->correction=sql2Bool($row[8]);
				$this->date_correction=$row[10];
				$this->obj_node=&$obj_EtapeFactory->createEtape($this);
				$this->obj_resultat= ResultatEtapeFactory::createResultatEtape($this->getType());
			}
		}else{
			die("Erreur DoEtape::performCurrentEtape(".$obj_EtapeFactory."): L'tape n'a pas t commence.<br>");
		}
		return $this->obj_node;
	}

//	/**
//	 * Termine l'tape.
//	 * Enregistre la date de fin de l'tape et detruit les attributs de l'objet inutiles (resultat et obj_node). 
//	 * Cette mthode ncssite un identifiant rsultat, et donc un appel prcdant  la methode beginCurrentEtape().
//	 * Elle ncessite aussi un objet Resultat en parametre, qui est obtenu par la methode getCurrentResultat()
//	 * 
//	 * @param object ResultatExotlcPlateforme $obj_resultat : Resultat associ  l'objet associ  l'avancement.
//	 * @return boolean true ou false suivant le succs ou non de la mthode.
//	 */	
//	function endCurrentEtape($obj_resultat){
//		messageDebug("DoExotlc::endCurrentEtape($obj_resultat)");
//		parent::end($obj_resultat);
//		if(!empty($this->resultat)){
//			$fin=set_resultat_fin($this->resultat);
//		}
//		if(!$fin){
//			die("Erreur DoExotlc::endCurrentEtape($obj_resultat): L'valuation n'a pas t termine.<br>");
//			return false;
//		}
//		return true;
//	}		

//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir l'objet correspondant  l'tape 
	 * @return object Exotlc l'objet correspondant  l'tape
	 */		
	function getExotlc(){
		return parent::getObjEtape();
	}

	/**
	 * Obtenir la date de correction de l'tape au format SQL
	 * @return string la date de correction de l'tape 
	 */			
	function getDateCorrection(){
		return $this->date_correction;
	}		

	/**
	 * Obtenir la date de correction formate.
	 * La date est retourne sous la forme d'un format affichable, en tenant compte de la langue actuelle de la plate-forme
	 * @return string la date de correction de l'tape formate.
	 */		
	function getDateCorrectionFormatee(){
		return sql_timestamp_to_string($this->date_correction);
	}	

	/**
	 * Obtenir le commentaire de correction 
	 * @return string le commentaire de correction 
	 */	
	function getCommentaire(){
		return $this->commentaire;
	}	

//	/**
//	 * Savoir si l'on doit permettre le tlchargement de la correction
//	 * @return bool true si on doit le rendre disponible, false sinon. 
//	 */		
//	function isCorrection(){
//		return $this->correction;
//	}

	/**
	 * Savoir si l'Exotlc  t corrig
	 * @return bool true si corrig, false sinon
	 */		
	function isCorrected(){
		
		$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
		if(pg_num_rows($res_resultat)==1){
			$row_resultat=pg_fetch_row($res_resultat);
			$id_resultat=$row_resultat[0];
	
			if(!empty($id_resultat)){
				$res=get_resultat_exotlc($id_resultat);
				$row=pg_fetch_row($res);
				//print_rr($row);
				if(!empty($row[10]))
					return true;
			}
		}
		return false;
	}		
	
	/**
	 * Savoir si la correction est disponible.
	 * Une correction est toujours disponible si elle a t corrige.
	 * @param integer Identifiant de la formation
	 * @param integer Identifiant du parcours
	 * @return boolean true si la srie est bloquante, false sinon.
	*/
	function isCorrectionDisponible(){
		return $this->isCorrected();
	}
}
?>
