<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fabrique d'Exotlc
 * @package exotlc
 */
class DoExotlcFactory extends DoNodeFactory{
	
	/**
	 * Constructeur de la fabrique.
	 * @param integer $formation Identifiant de la formation.
	 * @param integer $individu Identifiant de l'individu.
	 * @param object ExotlcFactory &$obj_ExotlcFactory Fabrique des objets associs aux objets d'avancement. 
	 */
	function DoExotlcFactory($formation,$individu,&$obj_ExotlcFactory){
		messageDebug("DoExotlcFactory::DoExotlcFactory()");
		parent::DoNodeFactory($formation,$individu,&$obj_ExotlcFactory);
	}
	
	/**
	 * Cre un objet DoExotlc
	 * @param integer $resultat identifiant de resultat
	 * @param integer $exotlc identifiant de l'exotlc
	 * @param integer $type_rendu idendifiant du type de rendu
	 * @return object Exotlc l'objet Exotlc souhait.
	 */
	function &createDoExotlc($resultat,$exotlc,$type_rendu){
		messageDebug("DoExotlcFactory::createDoExotlc($resultat,$exotlc,$type_rendu)");
		switch($type_rendu){
			case TYPE_EXOTLC_MAIL:
				return new DoExotlcMail($resultat,$exotlc,$this->getExotlcFactory());
				break;
			case TYPE_EXOTLC_PLATEFORME:
				return new DoExotlcPlateForme($resultat,$exotlc,$this->getExotlcFactory());
				break;
			default:
				die("Erreur createDoExotlc($resultat,$exotlc,$type_rendu): Le type '$type_rendu' est inconnu.<br>");																				
		}
		
	}
}
?>
