<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoExotlcMail.
 * Un DoExotlcMail est l'objet servant  gerer l'avancement des
 * Etapes de type DoExotlcMail d'un parcours.
 * 
 * @package exotlc
 */
class DoExotlcMail extends DoExotlc{

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'ExotlcMail
	 */
	function DoExotlcMail($formation,$individu,$parcours,$etape){
		messageDebug("DoExotlcMail::DoExotlcMail($formation,$individu,$parcours,$etape)");
		parent::DoExotlc($formation,$individu,$parcours,$etape);
	}
	
	/**
	 * Termine l'tape.
	 * 
	 * L'Etape n'est jamais termine, elle ne l'est que lorsque le formateur effectue la corresction.
	 * Cette tape, si obligatoire et donc non libre, bloque donc le parcours tant qu'elle n'est pas corrige.
	 * @param object ResultatExotlcPlateforme $obj_resultat : Resultat associ  l'objet associ  l'avancement.
	 * @return boolean true ou false suivant le succs ou non de la mthode.
	 */		
	function endCurrentEtape(){
		messageDebug("DoExotlcMail::endCurrentEtape()");
		//return parent::endCurrentEtape(null);
		return true;
	}		
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	/**
	 * Obtenir l'objet correspondant  l'tape 
	 * @return object ExotlcMail l'objet correspondant  l'tape
	 */		
	function &getExotlcMail(){
		return parent::getObjEtape();
	}
	
	function isFichierRendu(){
		return false;
	}
}
?>
