<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoExotlcPlateforme.
 * Un DoExotlcMail est l'objet servant  gerer l'avancement des
 * Etapes de type DoExotlcPlateforme d'un parcours.
 * 
 * @package exotlc
 */
class DoExotlcPlateforme extends DoExotlc{

	/**
	 * @var integer Identifiant du fichier rendu par le Stagiaire
	 */
	var $fichier_rendu;

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant de l'ExotlcPlateforme
	 */	
	function DoExotlcPlateforme($formation,$individu,$parcours,$etape){
		messageDebug("DoExotlcPlateforme::DoExotlcPlateforme($formation,$individu,$parcours,$etape)");
		parent::DoExotlc($formation,$individu,$parcours,$etape);
		$this->initDoExotlcPlateforme();
	}
	
	
//-----------------------------------------------------
//			METHODES
//-----------------------------------------------------
	
	function initDoExotlcPlateforme(){
		if(!empty($this->resultat)){
			$res=get_resultat_exotlc($this->resultat);
			$row=pg_fetch_row($res);
//			print_rr($row);
			$this->commentaire=$row[7];
			$this->correction=$row[8];
			$this->fichier_rendu=$row[9];
			$this->date_correction=$row[10];
		}	
	}
	/**
	 * Construction de l'objet associ  cet objet d'avancement.
	 * Cette mthode ncssite un identifiant rsultat. Ainsi, si cet identifiant n'est pas dj valu, on le recupre en base de donnes.
	 * Si cet identifiant n'a jamais t cr (par un appel prcdent  beginCurrentEtape()), une erreur est gnre.
	 * Dans le cas contraire, l'objet Exotlc est cr et retourn par la mthode.
	 * Il est aussi possible de forcer l'execution de la mthode sans appel pralable  beginCurrentEtape(), cad sans identifiant rsultat.
	 * @param object EtapeFactory &$obj_EtapeFactory Fabrique servant  crr les objets, dont l'Exotlc
	 * @param boolean $force A true, ce parametre permet de forcer l'execution de la mthode sans appel pralable  beginCurrentEtape(), cad sans identifiant rsultat. A false par dfaut. 
	 * @return object ExotlcPlateforme : L'objet associ  cet objet d'avancement.
	 */		
	function &performCurrentEtape(&$obj_EtapeFactory,$force=false){
		messageDebug("DoExotlcPlateforme::performCurrentEtape($obj_EtapeFactory)");
		parent::perform($obj_EtapeFactory);
		if(empty($this->resultat)){
			$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
			if(pg_num_rows($res_resultat)==1){
				$row_resultat=pg_fetch_row($res_resultat);
				$id_resultat=$row_resultat[0];
				if(!empty($id_resultat)){
					$this->resultat=$id_resultat;
				}
			}
		}
		
		if(!empty($this->resultat)&&is_object($obj_EtapeFactory)){
			$res=get_resultat_exotlc($this->resultat);
			$row=pg_fetch_row($res);
//			print_rr($row);
			$this->commentaire=$row[7];
			$this->correction=$row[8];
			$this->fichier_rendu=$row[9];
			$this->date_correction=$row[10];
			$this->obj_node=&$obj_EtapeFactory->createEtape($this);
			$this->obj_resultat= ResultatEtapeFactory::createResultatEtape($this->getType()."_".TYPE_EXOTLC_PLATEFORME);
		}else{
			if(!$force&&empty($this->obj_node))die("Erreur DoExotlcPlateforme::performCurrentEtape(".$obj_EtapeFactory."): L'tape n'a pas t commence.<br>");
		}
		return $this->obj_node;
	}

	/**
	 * Termine l'tape.
	 * Enregistre la date de fin de l'tape et detruit les attributs de l'objet inutiles (resultat et obj_node). 
	 * Cette mthode ncssite un identifiant Resultat, et donc un appel prcdant  la methode beginCurrentEtape().
	 * Elle ncessite aussi un objet Resultat en parametre, qui est obtenu par la methode getCurrentResultat()
	 * 
	 * @param object ResultatExotlcPlateforme $obj_resultat : Resultat associ  l'objet associ  l'avancement.
	 * @return boolean true ou false suivant le succs ou non de la mthode.
	 */		
	function endCurrentEtape($obj_resultat){
		messageDebug("DoExotlcPlateforme::endCurrentEtape($obj_resultat)");
		if(is_object($obj_resultat)&&$obj_resultat->verify()){
			parent::endCurrentEtape($obj_resultat);
			//print_rr($this);
//			if(!empty($this->resultat)){
//				if(empty($this->duree)){
					$fin=set_resultat_exotlc_plateforme($this->resultat,$obj_resultat->getFichierRendu());
//				}else{
//					$fin=maj_resultat_exotlc_plateforme($this->resultat,$obj_resultat->getFichierRendu());
//				}
//			}
//			echo "\$fin=$fin";
			if(empty($fin)){
				die("Erreur DoExotlcPlateforme::endCurrentEtape($obj_resultat): L'exotlc n'a pas t termine.<br>");
			}else{
				$this->fichier_rendu=$obj_resultat->getFichierRendu();
			}
		}
//		else{	$this->debut=$row_resultat[5];
//					$this->duree=$row_resultat[6];
//			die("Erreur DoExotlcPlateforme::endCurrentEtape($obj_resultat): Le DoExotlcPlateForme ncessite en paramatre un objet Resultat valide pour tre termin.<br>");
//		}
		return true;
	}			


//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	/**
	 * Obtenir l'objet correspondant  l'tape 
	 * @return object ExotlcPlateforme l'objet correspondant  l'tape
	 */		
	function &getExotlcPlateforme(){
		return parent::getObjEtape();
	}
	
	/**
	 * Obtenir l'identifiant du fichier rendu par le Stagiaire.
	 * @return integer l'identifiant du fichier
	 */		
	function getFichierRendu(){
		return $this->fichier_rendu;
	}

	function isFichierRendu(){
		return !empty($this->fichier_rendu);
	}
	
	/**
	 * Obtenir l'objet correspondant au fichier rendu par le Stagiaire.
	 * @return objetc FichierExotlcRendu Le fichier rendu par le Stagiaire
	 */		
	function getObjFichierRendu(){
		if(!empty($this->fichier_rendu))
			return new FichierExotlcRendu($this->fichier_rendu,parent::getIndividu(),$this->getEtape(), $this->getParcours(),$this->getFormation(),$this->obj_node->getFichierRendu());
		else
			return null;
	}	
	
	/**
	 * Indique que l'Etape n'est finie quand un fichier  t rendu par le stagiaire
	 * @return boolean Toujours false. 
	 */
	function isEnd(){
		return !empty($this->fichier_rendu);	
	}
	/**
	 * Calculer et obtenir le status de l'Etape.
	 * Le status est obtenu  partir des donnes en base.
	 * L'tape peut avoir les status suivants:
	 * DO_ETAPE_NONE, DO_ETAPE_BEGIN et DO_ETAPE_END.
	 */
	 function getStatus(){
		$status=parent::getStatus();	 	
	 	if($status==DO_ETAPE_END&&empty($this->fichier_rendu)){
	 		$status=DO_ETAPE_BEGIN;
	 	}
//	 	print_rr($this);
	 	return $status;
	}
}
?>
