<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe Exotlc.
 *	Un Exotlc est un objet driv d'Etape.
 *
 *	@package exotlc
 */
class Exotlc extends Etape{
	
	/**
	 * @var string Commentaire 
	 */
	var $commentaire;

	/**
	 * @var string Texte 
	 */	
	var $texte;
	
	/**
	 * @var string Enonc 
	 */
	var $enonce;
	
	/**
	 * @var string Remarque 
	 */
	var $remarque;
	
	/**
	 * @var integer type de rendu 
	 */
	var $type_rendu;
	
	/**
	 * Construit un Exotlc.
	 * L'Exotlc peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de l'Exotlc
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 * @param string $commentaire Commentaire
	 * @param string $texte Texte
	 * @param string $enonce Enonc
	 * @param string $remarque Rmarque
	 * @param integer $type_rendu Type de rendu (mail, plate-forme, ...)
	 */
	function Exotlc($id, $libelle="Etape Exotlc", $date_creation="27.11.2006", $commentaire="", $texte="", $enonce="",$remarque="",$type_rendu=0){
		messageDebug("Exotlc::Exotlc($id, $libelle, $date_creation)");
		if(func_num_args()==1){
			$res_etape=get_exotlc($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[8];
			$commentaire=$row_etape[3];
			$texte=$row_etape[4];
			$enonce=$row_etape[5];
			$remarque=$row_etape[6];
			$type_rendu=$row_etape[7];
			
		}else{
			$libelle=$libelle;
			$date_creation=$date_creation;
			$commentaire=$commentaire;
			$texte=$texte;
			$enonce=$enonce;
			$remarque=$remarque;
			$type_rendu=$type_rendu;
		}
		parent::Etape($id, $libelle,$date_creation, TYPE_ETAPE_EXOTLC);
		$this->initExotlc($commentaire, $texte, $enonce,$remarque,$type_rendu);
	}
	
	/**
	 * Initialise les attributs propres  l'Exotlc.
	 *  
	 * @param string $commentaire Commentaire
	 * @param string $texte Texte
	 * @param string $enonce Enonc
	 * @param string $remarque Rmarque
	 * @param integer $type_rendu Type de rendu (mail, plate-forme, ...)
	 */
	function initExotlc( $commentaire, $texte, $enonce,$remarque,$type_rendu){
		parent::initEtape();
		$this->type_rendu=$type_rendu;
		$this->commentaire=$commentaire;
		$this->texte=$texte;
		$this->enonce=$enonce;
		$this->remarque=$remarque;
	}
	
	/**
	 * Indique si l'Etape peut donner lieu  une correction.
	 * Retourne toujours true, car un Exotlc donne lieu  une correction.
	 * @return boolean Retourne true.
	 */
	function isCorrectable(){
		return true;
	}

	/**
	 *   Obtenir les fichiers proposs en tlchargement aux stagiaires.
	 *   @return integer les infos de l'exercice (id int4,libelle varchar)
	 */
	function getFichiers(){
		return get_exotlc_fichiers($this->id);
	}
	
	/**
	 * Obtenir le chemin relatif de l'emplacement d'un fichier.
	 * @param integer $fichier L'identifiant du fichier
	 * @param string $racine La racine  partir de laquelle on calcul le chemin relatif
	 * @return string Le chemin relatif
	 */
	function getFichierCheminRelatif($fichier,$racine){
		$chemin=get_fichier_chemin_relatif($fichier, pg_fetch_result(get_categorie_element_themes(TYPE_CATEGORIE_FICHIER_EXOTLC,$fichier),0,0), TYPE_CATEGORIE_FICHIER_EXOTLC);
		if(file_exists($racine.$chemin)){
			return $racine.$chemin;	
		}
		else{
			echo "le fichier ".$racine.$chemin." n'existe pas<br>";
			return false;	
		}
	}

	/**
	 * Obtenir l'URL de l'emplacement d'un fichier.
	 * @param integer $fichier L'identifiant du fichier
	 * @param string $racine La racine  partir de laquelle on calcule l'URL
	 * @return string L'URL du Fichier
	 */	
	function getFichierURL($fichier,$racine){
		$chemin=get_fichier_chemin($fichier, pg_fetch_result(get_categorie_element_themes(TYPE_CATEGORIE_FICHIER_EXOTLC,$fichier),0,0), TYPE_CATEGORIE_FICHIER_EXOTLC);
		if($chemin)return $chemin;
		else{
			print("getFichierURL($fichier,$racine) le fichier '$racine$chemin' n'existe pas.");			
			return false;
		} 
	}
	
	/**
	 * Obtenir les fichiers de correction d'un exercice  tlcharger
	 *
	 * @return integer les infos des fichiers de correction  (id int4,libelle varchar)
	 */
	function getCorrections(){
		return get_exotlc_fichiers_correction($this->id);
	}
	
	/**
	 * Obtenir le type de rendu de l'Exotlc
	 * @return integer Identifiant du type.
	 */
	function getTypeRendu(){
		return $this->type_rendu;
	}
	
	/**
	 * Obtenir la remarque.
	 * @return string La remarque
	 */
	function getRemarque(){
		return get_fo_libelle($this->remarque);
	}
	
	/**
	 * Obtenir l'nonc.
	 * @return string L'nonc.
	 */	
	function getEnonce(){
		return get_fo_libelle($this->enonce);
	}

	/**
	 * Obtenir le texte.
	 * @return string Le texte.
	 */		
	function getTexte(){
		return get_fo_libelle($this->texte);
	}
	
	/**
	 * Obtenir le commentaire.
	 * @return string Le commentaire.
	 */		
	function getCommentaire(){
		return get_fo_libelle($this->commentaire);
	}

	/**
	 * Obtenir l'icone associe  l'Etape.
	 * @return string Le nom du fichier icone
	 */
	function getIcone(){
		return "ico_exotlc.png";
	}
	
	function getModeleCorrection(){
		$row=get_exotlc_modele_correction($this->id);
		return $row[0];
	}
	
		/**
	 * Obtenir le type entier de la serie (en fonction de ses valuations)
	 * @return string le type entier de la serie
	 */
	 function getTypeCalcule(){
	 	return TYPE_ETAPE_EXOTLC;
	 }	
}
?>