<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un ExotlcCorrection.
 * Un ExotlcCorrection est l'objet  utilis pour exploiter la correction d'un Exotlc.
 * Cet objet de correction est constuit  partir d'un DoExotlc, l'objet d'avancement des Exotlc.
 * 
 * @package serie
 */
class ExotlcCorrection extends EtapeCorrection{ 

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param object DoExotlc Exotlc 
	 */
	function ExotlcCorrection($obj_DoExotlc){
		messageDebug("ExotlcCorrection::ExotlcCorrection( $obj_DoExotlc)");
		parent::EtapeCorrection($obj_DoExotlc);
		$this->initExotlcCorrection();
	}
	
	function initExotlcCorrection(){
		messageDebug("ExotlcCorrection::initExotlcCorrection()");
		if(!empty($this->resultat)){
			$res=get_resultat_exotlc($this->resultat);
			$row_resultat=pg_fetch_row($res);
			$this->resultat=$row_resultat[0];
			$this->debut=$row_resultat[5];
			$this->duree=$row_resultat[6];
			$this->commentaire=$row_resultat[7];
			$this->correction=sql2Bool($row_resultat[8]);
			$this->fichier_rendu=$row_resultat[9];
			$this->date_correction=$row_resultat[10];
		}else{
			die("Erreur ExotlcCorrection::initExotlcCorrection(): Identifiant rsultat manquant.(L'tape a-t-elle t commence?)<br>");
		}
	}

	/**
	 * Obtenir l'identifiant du fichier rendu par le Stagiaire.
	 * @return integer l'identifiant du fichier
	 */		
	function getFichierRendu(){
		return $this->fichier_rendu;
	}
	
	/**
	 * Obtenir l'identifiant du parcours pourlequel cet objet d'avancement est utilis.
	 * @return integer identifiant du parcours
	 */
	function getParcours(){
		return $this->obj_DoEtape->getParcours();
	}
	
	/**
	 * Obtenir l'identifiant de la formation pour laquelle cet objet d'avancement est utilis.
	 * @return integer identifiant de la formation
	 */
	function getFormation(){
		return $this->obj_DoEtape->getFormation();
	}
	
	/**
	 * Obtenir l'identifiant de l'individu pour lequel cet objet d'avancement est utilis.
	 * @return integer identifiant de l'individu
	 */
	function getIndividu(){
		return $this->obj_DoEtape->getIndividu();
	}
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	function getSousCritere($souscritere){
		$res=get_resultat_exotlc_sous_crirere($this->resultat,$souscritere);
		return pg_fetch_row($res,0);
	}

	function getSousCriteres(){
		$res=get_resultat_exotlc_sous_criteres($this->resultat);
		return $res;
	}
	
	function getCriteres(){
		
		$res=get_resultat_exotlc_criteres($this->resultat);
		return $res;
	}
	
	function getCritere($critere){
		$res=get_resultat_exotlc_critere($this->resultat,$critere);
		return pg_fetch_row($res,0);
	}
	
	function getCritereSousCriteres($critere){
		$res=get_resultat_exotlc_critere_sous_criteres($this->resultat,$critere);
		return $res;
	}


//	function getCritereSousCriteres($critere){
//		$res=get_exotlc_critere_sous_criteres($this->resultat,$critere);
//		return $res;
//	}

	function getCommentaire(){
		return $this->commentaire;
	}
	
	function getDateCorrection(){
		return $this->date_correction;
	}
	
	function getDateCorrectionFormatee(){
		return sql_timestamp_to_string($this->date_correction);
	}
	
	function getNote(){
		return pg_fetch_result(get_resultat_exotlc_moyenne($this->resultat),0,0);
	}
	
	function getFichiersCorrection(){
		return get_exotlc_fichiers_correction($this->getId());
	}
	
	function getNoteMax(){
		return ETAPE_NOTE_MAX_DEFAULT;
	}

	/**
	 * Savoir si l'on doit permettre le tlchargement de la correction
	 * @return bool true si on doit le rendre disponible, false sinon. 
	 */		
	function isCorrection(){
		return $this->correction;
	}

}
?>
