<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un ExotlcCorrection.
 * Un ExotlcCorrection est l'objet  utilis pour exploiter la correction d'un Exotlc.
 * Cet objet de correction est constuit  partir d'un DoExotlc, l'objet d'avancement des Exotlc.
 * 
 * @package serie
 */
class ExotlcCorrectionSousCritere { 

	var $id;
	var $resultat;
	var $libelle;
	var $note;
	var $note_max;
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param object DoExotlc Exotlc 
	 */
	function ExotlcCorrectionSousCritere($id,$libelle,$resultat,$note=null,$note_max=null){
		messageDebug("ExotlcCorrectionSousCritere::ExotlcCorrectionSousCritere( $id,$libelle,$resultat,$note=null,$note_max=null)");
		$this->initExotlcCorrectionSousCritere($id,$libelle,$resultat,$note,$note_max);
	}
	
	function initExotlcCorrectionSousCritere($id,$libelle,$resultat,$note,$note_max){
		messageDebug("ExotlcCorrectionSousCritere::initExotlcCorrectionSousCritere($id,$libelle,$resultat,$note,$note_max)");
		$this->id=$id;
		$this->libelle=$libelle;
		$this->resultat=$resultat;
		$this->note=$note;
		$this->note_max=$note_max;
	}


//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	
	function getId(){
		return $this->id;
	}
	
	function getLibelle(){
		return $this->libelle;
	}
	
	function getResultat(){
		return $this->resultat;
	}
	
	function getNote(){
		return $this->note;
	}
	
	function getNoteMax(){
		return $this->note_max;
	}
	
}
?>
