<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Builder
 */
class ExotlcFactory {
	
	/**
	 * Constructeur de la fabrique.
	 */
	function ExotlcFactory(){
		messageDebug("ExotlcFactory::ExotlcFactory()");
	}
	
	/**
	 * Cre un objet Exotlc
	 * @param DoEtape $param1 Objet d'avancement de l'exotlc que l'on souhaite crer ou identifiant de l'exotlc (Integer)
	 * @param Integer $param2 type de rendu
	 * @return Exotlc l'objet Exotlc souhait.
	 */
	function &createExotlc($param1, $param2=0){
		messageDebug("ExotlcFactory::createExotlc($param1, $param2)");
		if(is_object($param1)){
			$exotlc=$param1->getId();
			$type_rendu=$param1->getTypeRendu();
		}
		else{
			$exotlc=$param1;
			$type_rendu=$param2;
			if(empty($type_rendu)){
				$type_rendu=get_exotlc_type($exotlc);
			}
		}
		if(empty($exotlc)||empty($type_rendu)){
			die("ExotlcFactory::createExotlc($param1, $param2):Erreur sur les parametres.");
		}
		
		switch($type_rendu){
			case TYPE_EXOTLC_MAIL:
				return new ExotlcMail($exotlc);
			case TYPE_EXOTLC_PLATEFORME:
				return new ExotlcPlateForme($exotlc);
			default:
				die("Erreur createExotlc($param1, $param2): Le type '$type_rendu' est inconnu.<br>");																				
		}
		
	}
}
?>
