<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe ExotlcMail.
 *	Un ExotlcMail est un objet driv d'Exotlc, lui meme driv d'Etape.
 *
 *	@package exotlc
 */
class ExotlcMail extends Exotlc{
	
	/**
	 * @var integer Identifiant du formateur associ  l'ExotlcMail
	 */
	var $formateur;
	
	/**
	 * Construit un ExotlcMail.
	 * L'ExotlcMail peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de l'ExotlcMail
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 */	
	function ExotlcMail($id, $libelle="Etape ExotlcMail", $date_creation="27.11.2006"){
		messageDebug("ExotlcMail::ExotlcMail($id, $libelle, $date_creation)");
		if(func_num_args()==1){
			$res_etape=get_exotlc_mail($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[8];
		}else{
			
		}
		parent::Exotlc($id, $libelle,$date_creation, $row_etape[3],$row_etape[4],$row_etape[5],$row_etape[6],TYPE_EXOTLC_MAIL);
		$this->initExotlcMail($row_etape[2]);
	}
	
	/**
	 * Initialise les attributs propres  l'ExotlcMail.
	 *  
	 * @param integer $formateur L'identifiant du Formateur
	 */
	function initExotlcMail($formateur){
		messageDebug("ExotlcMail::initExotlcMail($formateur)");
		if(!empty($formateur)){
			$this->formateur=$formateur;
		}else{
			die("Erreur initExotlcMail($formateur): L'objet ne peut etre initialis.");
		}
	}

	/**
	 * Obtenir l'objet Formateur Associ  l'ExotlcMail
	 * @return object Formateur L'objet Formateur
	 */
	function getFormateurObj(){
		echo "ExotlcMail::getFormateurObj() est dprcie. Utilisez getObjFormateur()";
		return $this->getObjFormateur();
	}
		/**
	 * Obtenir l'objet Formateur Associ  l'ExotlcMail
	 * @return object Formateur L'objet Formateur
	 */
	function getObjFormateur(){
		return new Individu($this->formateur);// pg_fetch_object(get_individu($this->formateur));
	}

	/**
	 * Obtenir l'identifiant du formateur associ  l'ExotlcMail
	 * @return integer L'identifiant du Formateur
	 */
	function getFormateur(){
		return $this->formateur;
	}
	
	function isAutocorrection(){
		return false;
	}
}
?>