<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe ExotlcPlateforme.
 *	Un ExotlcPlateforme est un objet driv d'Exotlc, lui meme driv d'Etape.
 *
 *	@package exotlc
 */
class ExotlcPlateforme extends Exotlc{

	/**
	 * @var string Libll du Fichier que doit rendre les stagiaires
	 */	
	var $fichier_rendu;
	var $autocorrection;

	/**
	 * Construit un ExotlcPlateforme.
	 * L'ExotlcPlateforme peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant de l'ExotlcMail
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 */		
	function ExotlcPlateforme($id, $libelle="Etape ExotlcPLateforme", $date_creation="27.11.2006"){
		messageDebug("ExotlcPlateforme::ExotlcPLateforme($id, $libelle, $date_creation)");
		if(func_num_args()==1){
			$res_etape=get_exotlc_plate_forme($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[8];
		}else{
		}
		parent::Exotlc($id, $libelle,$date_creation, $row_etape[3],$row_etape[4],$row_etape[5],$row_etape[6],TYPE_EXOTLC_PLATEFORME);
		$this->initExotlcPlateforme($row_etape[2],sql2Bool($row_etape[9]));
	}

	/**
	 * Initialise les attributs propres  l'ExotlcPlateforme.
	 *  
	 * @param string $fichier_rendu Libll du Fichier que doit rendre les stagiaires
	 */	
	function initExotlcPlateforme($fichier_rendu,$autocorrection){
		messageDebug("ExotlcPlateforme::initExotlcPlateforme($fichier_rendu)");
		if(!empty($fichier_rendu)){
			$this->fichier_rendu=$fichier_rendu;
		}else{
			die("Erreur initExotlcExotlcPlateforme($fichier_rendu): L'objet ne peut etre initialis.");
		}
		$this->autocorrection=$autocorrection;
	}

	/**
	 * Obtenir le libll du Fichier que doit rendre les stagiaires
	 * @return string Libll du Fichier que doit rendre les stagiaires
	 */
	function getFichierRendu(){
		return $this->fichier_rendu;
	}
	
	function isAutocorrection(){
		return $this->autocorrection;
	}

}
?>