<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition de la classe ResultatExotlcPlateforme.
 * Cet objet est requis par la mthode endCurrentEtape() de la
 * classe DoExotlcPlateforme.
 * Dfini les valeurs ncessaires  la fin de l'Etape et fourni des mthodes
 * de d'initialisation et de vrification de ces valeurs.
 * 
 * @package exotlc
 */
class ResultatExotlcPlateforme extends ResultatEtape{
	
	/**
	 * @var integer Identifiant du Fichier rendu par le stagiaire.
	 */
	var $fichier_rendu;
	
	/**
	 * Affecter les valeurs des attributs de l'objet.
	 * @param $fichier_rendu integer Identifiant du Fichier rendu par le stagiaire
	 */
	function init($fichier_rendu){
		messageDebug("ResultatExotlcPlateforme::init($fichier_rendu)");
		$this->fichier_rendu=$fichier_rendu;
	}
	
	/**
	 * Vrifie les valeurs des attributs.
	 * @return boolean true si les valeurs sont correctes, false sinon.
	 */
	function verify(){
		messageDebug("ResultatExotlcPlateforme::verify()");
		if(empty($this->fichier_rendu))return false;
		return true;
	}
	
	/**
	 * Obtenir l'identifiant du Fichier rendu par le stagiaire.
	 * @return integer Identifiant du Fichier rendu par le stagiaire.
	 */
	function getFichierRendu(){
		return $this->fichier_rendu;
	}
}
?>
