<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Fichier de fonction pour exotlc
	@package exotlc
	@modulegroup fonctions
*/
// parsing des textes avec image
function parse_html_txt($texte){
    global $serverfront, $nomrep,$ams_langue;
	if(VERSION_BASE>VERSION){
		$address= 'http://' . $serverfront . "/fo/data/contenus/$nomrep/6/$ams_langue/";
	}
	else 
		$address = 'http://' . $serverfront . "/data/exostlc/$nomrep/media_exo/";
	//echo "adresse=$address<br>";
    //$address = 'http://$serverfront/data/exostlc/'.$nomrep."/media_exo/";
    $texte = preg_replace('/(<img[ ]+src=")([^"]*)\/([^"]+)("[^>]*>)/i', "\\1$address\\3\\4" , $texte);
    return $texte;
}

// retourne un tableau des medias exotlc
function medias_exotlc_en_tab($theme){
	global $nom_rep,$chemin_fo;
	$tabfich=array();
	// recup des fichier connects
	$res=get_theme_medias_exotlc($theme);
	$nb=pg_numrows($res);
	//echo "nb=$nb<br>";
	if(VERSION_BASE>VERSION){
		for($t=0;$t<$nb;$t++){
			$row=pg_fetch_row($res,$t);
			$fich=$row[0].".".get_fichier_extension($row[1]);
			$tabfich[$fich]="$row[1]";
		}
		//print_r($tabfich);
		return $tabfich;
	}
	for($t=0;$t<$nb;$t++){
		$row=pg_fetch_row($res,$t);
		$tabfich[]=$row[1];
	}
	//$nom_rep = $racine . $nom_rep . "/" . $liste_cat[$cat][1];
	$nom_rep=$chemin_fo."/data/exostlc/".$nom_rep."/media_exo";
	// LECTURE DU REPERTOIRE ET CLASSEMENT DES FICHIERS
	$handle=@opendir($nom_rep);
	if ($handle){
		while ($fichier = readdir($handle)){
			if($fichier!="." && $fichier!=".." && !is_dir($nom_rep . "/" . $fichier)){
				if(in_array($fichier,$tabfich))
					$liste[$fichier]="";
			 }
		}
		closedir($handle);
	}
	return $liste;
}

/**
 * Obtenir les actions autorises sur un exotlc.
 * 2: l'exotlc est supprimable
 * 1: il n'est que modifible 
 * 0: il n'est ni modifiable ni supprimable
 * 
 * @param integer identifiant de l'exotlc
 * @param integer le code de retour de l'action
 */
function get_exotlc_actions($exotlc){
	//initialisation , tout est permis
    $action_exotlc=2;
    
    // test si l'exotlc est dans un parcours
    //$res=get_serie_parcourss($serie);
	$res=get_etape_parcourss($exotlc);
    if(pg_num_rows($res)>0){
    	//modif uniquement
        $action_exotlc=1;
        
    }

    
    
    //test si l'exotlc  t fait par un stagiaire
    //$res_max=get_serie_avancement_max($serie);
	// NOTE : VOIR AVEC REMI
	/*
	$res_max=get_exotlc_avancement_max($exotlc);
    if( (pg_num_rows($res_max)>0) && pg_fetch_result($res_max,0,0) ){
    	//rien n'est permis
    	$action_exotlc=0;
    }
	*/
	$res=get_etape_resultats($exotlc);
	if(pg_num_rows($res)>0)
		$action_exotlc=0;
	
    return $action_exotlc;
}

/**
	Obtenir le nom de fichier sur le disque d'un exotlc rendu par un stagiaire. 
	@param integer $exotlc identifiant de l'exotlc
	@param integer $fichier_rendu identifiant du fichier rendu
	@param integer $parcours identifiant du parcours
	@param integer $stagiaire identifiant du stagiaire
	@return string : le nom du fichier sur le disque
*/
function get_exotlc_fichier_nom($exotlc,$fichier_rendu,$parcours,$stagiaire ){
	$tmp_ext=get_fichier_extension(pg_fetch_result(get_fichier($fichier_rendu),0,1));
	return $parcours."_".$stagiaire."_".$exotlc.".".$tmp_ext;
}
?>