<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package exotlc
 * @modulegroup plpgsql
 * @module plpgsql_exotlc
 */

/**
	Obtenir les stagiaires qui on ete corriges pour un exercice
	
	num_user | nomprenom 
	
	@param integer numero de l'exercice
	@param integer numero de la formation
	@param integer numero du groupe
	@param integer numero du formateur
	@return integer resultat de la requete
*/
function get_exotlc_stagiaires_corriges_old($exo,$formation,$groupe, $formateur){
	
	$req="	select num_user, textcat( textcat(nom, text ' '), prenom) AS nomprenom, lower(nom) AS ordre 
									FROM UTILISATEURS
									where categorie like '%u%' 
									and num_user in (
										select gu_num_user 
										from GESTIONUTIL
										where gu_num_gest_gr='$groupe' 
										and gu_num_gest_gr in(
											select distinct g_num_gest_g 
											from GESTIONNAIRE 
											where g_num_user='$formateur'
										)
									)
									and num_user in (
										select gesttlc_user 
										from GESTEXOTLC 
										where gesttlc_exo='$exo' 
										and num_cal='$formation'
									)
		                        	order by ordre;";	
		                        	
	return(pg_query($req));
}

/**
	Obtenir les stagiaires qui on ete corriges pour un exercice
	
	num_user | nomprenom 
	
	@param integer numero de l'exercice
	@param integer numero de la formation
	@param integer numero du groupe
	@param integer numero du formateur
	@return integer resultat de la requete
*/
function  get_exotlc_stagiaires_corriges($exo,$formation,$groupe, $formateur){
	
	if(VERSION_BASE>VERSION){
       
    }
    else
        return get_exotlc_stagiaires_corriges_old($exo,$formation,$groupe, $formateur);
}


/**
	Obtenir les stagiaires qui n'ont pas ete corrigs pour un 
	exercice.

	Les stagiares peuvent avoir rendu ou non leur exercice.

	num_user | nomprenom | rendu ou non rendu
	
	@param integer numero de l'exercice
	@param integer numero de la formation
	@param integer numero du groupe
	@param integer numero du formateur
	@return integer resultat de la requete
*/
function get_exotlc_stagiaires_non_corriges_old($exo,$formation,$groupe, $formateur=""){
	
	$req="	(select num_user, textcat( textcat(nom, text ' '), prenom) AS nomprenom, 'non rendu', lower(nom) AS ordre 
									FROM UTILISATEURS
									where categorie like '%u%' 
									and num_user in (
										select gu_num_user 
										from GESTIONUTIL
										where gu_num_gest_gr=$groupe 
										and gu_num_gest_gr in(
											select distinct g_num_gest_g 
											from GESTIONNAIRE 
											where g_num_cal=$formation ";
	if(!empty($formateur))$req.="	and g_num_user=$formateur";
	$req.="							)
									)
									and num_user not in (
										select gesttlc_user 
										from GESTEXOTLC 
										where gesttlc_exo=$exo
										and num_cal=$formation
									)
									and num_user not in(
										select num_stag
										FROM reception_exostlc
										WHERE num_exo=$exo
										AND num_cal=$formation
									)
					)
					UNION(
						select num_user, textcat( textcat(nom, text ' '), prenom) AS nomprenom, 'rendu', lower(nom) AS ordre 
									FROM UTILISATEURS
									where categorie like '%u%' 
									and num_user in (
										select gu_num_user 
										from GESTIONUTIL
										where gu_num_gest_gr=$groupe 
										and gu_num_gest_gr in(
											select distinct g_num_gest_g 
											from GESTIONNAIRE 
											where g_num_cal=$formation";
if(!empty($formateur))$req.="	and g_num_user=$formateur";
$req.="							)
									)
									and num_user not in (
										select gesttlc_user 
										from GESTEXOTLC 
										where gesttlc_exo=$exo 
										and num_cal='$formation'
									)
									and num_user in(
										select num_stag
										FROM reception_exostlc
										WHERE num_exo=$exo
										AND num_cal=$formation
									)
					)
					order by ordre;";	
	//echo $req."<BR>";                	
	return(pg_query($req));
}

/**
	Obtenir les stagiaires qui n'ont pas ete corriges pour un 
	exercice.

	Les stagiares peuvent avoir rendu ou non leur exercice.

	num_user | nomprenom | rendu ou non rendu
	
	@param integer numero de l'exercice
	@param integer numero de la formation
	@param integer numero du groupe
	@param integer numero du formateur
	@return integer resultat de la requete
*/
function get_exotlc_stagiaires_non_corriges($exo,$formation,$groupe, $formateur=""){
	
	if(VERSION_BASE>VERSION){
       
    }
    else
        return get_exotlc_stagiaires_non_corriges_old($exo,$formation,$groupe, $formateur);
}

/**
	Obtenir les donnees d'un exercice a telechager. (OLD)

	num_exo | titre | formateur |  commentaire | texte | enonce | remarque | nomfic_rendu | mode_rendu
	
	@param integer numero de l'exercice
	@param integer les infos de l'exercice
*/
function get_exotlc_infos_old($exo){

	$req="	select num_exo, titre, formateur,  commentaire, texte, enonce, remarque, nomfic_rendu, mode_rendu 
				from exotlc 
				where num_exo=$exo";	
		                        	
	return(pg_query($req));
}

/**
	Obtenir les donnees d'un exercice a telechager.

	num_exo | titre | formateur |  commentaire | texte | enonce | remarque | nomfic_rendu | mode_rendu
	
	@param integer numero de l'exercice
	@param integer les infos de l'exercice
*/
function get_exotlc_infos($exo){
	
	if(VERSION_BASE>VERSION){
       
    }
    else
        return get_exotlc_infos_old($exo);
}

/**
	Obtenir les donnees d'un exercice a telechager. (OLD)

	num_exo | titre | formateur |  commentaire | texte | enonce | remarque | nomfic_rendu | mode_rendu
	
	@param integer numero de l'exercice
	@param integer les infos de l'exercice
*/
function get_exotlc_themes_old($exo){

	$req= "	select distinct num_themedir, nom_theme 
							from themedir 
							where num_themedir in (
								select num_themedir 
								from fictlc where num_fic 
								in (
									select gestfic_num_fic 
									from gestfic 
									where gestfic_num_exo='$exo'
								)
							);";	
		                        	
	return(pg_query($req));
}

/**
	Obtenir les donnees d'un exercice a telechager.

	num_exo | titre | formateur |  commentaire | texte | enonce | remarque | nomfic_rendu | mode_rendu
	
	@param integer numero de l'exercice
	@param integer les infos de l'exercice
*/
function get_exotlc_themes($exo){
	
	if(VERSION_BASE>VERSION){
		return get_categorie_element_themes(33, $exo);
    }
    else
        return get_exotlc_themes_old($exo);
}

/**
* Obtenir les donnes d'un exercice a telechager .  (OLD)
*
* @param integer numero de l'exercice
* @return integer le resultat de la requete (id int4,libelle varchar, formateur int4,commentaire varchar,texte varchar,enonce varchar,remarque varchar,fichier_rendu varchar,type int4)
*/
function get_exotlc_old($exo){
    $sql="select num_exo,titre, formateur, commentaire, texte, enonce, remarque,nomfic_rendu,mode_rendu from EXOTLC where num_exo=$exo;";
    return (pg_query($sql));
}

/**
* Obtenir les donnes d'un exercice a telechager.
*
* @param integer numero de l'exercice
* @return integer le resultat de la requete (id integer,libelle character varying,fichier_rendu character varying ou formateur integer,commentaire character varying,texte character varying,enonce character varying,remarque character varying,type integer, date_creation timestamp)
*/
function get_exotlc($exo){
    //if(VERSION_BASE>VERSION){
		if(empty($type))
			$type=get_exotlc_type($exo);
//		echo "type=$type<br>";
		if($type==1 || $type=='pf')
			return get_exotlc_plate_forme($exo);
		else
			return get_exotlc_mail($exo);
	/*
    }
    else
        return get_exotlc_old($exo);
	*/
}

/**
    Obtenir les donnes d'un exercice a telechager de type mail.(OLD)
*
*   @param integer numero de l'exercice
* 	@return integer le resultat de la requete (id int4,libelle varchar, formateur int4,commentaire varchar,texte varchar,enonce varchar,remarque varchar,fichier_rendu varchar,type int4)
*/
function get_exotlc_mail_old($exo){
    $sql="select num_exo,titre,formateur, commentaire, texte, enonce, remarque,  mode_rendu  from EXOTLC where num_exo=$exo;";
    return (pg_query($sql));
}

/**
    Obtenir les donnes d'un exercice a telechager de type mail.
*
*   @param integer numero de l'exercice
* 	@return integer le resultat de la requete (id int4,libelle varchar, formateur int4,commentaire varchar,texte varchar,enonce varchar,remarque varchar,type int4, date_creation timestamp)
*/
function get_exotlc_mail($exo){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_exotlc_mail($exo) as  
		(id int4,libelle varchar, formateur int4,commentaire text,texte text,enonce text,remarque text,type int4, date_creation timestamp)";
//		echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        return get_exotlc_mail_old($exo);
	return $res;
}

/**
*    Obtenir les donnes d'un exercice a telechager de type plate_forme.(OLD)
*
* @param integer numero de l'exercice
* @return integer le resultat de la requete (id int4,libelle varchar, formateur int4,commentaire varchar,texte varchar,enonce varchar,remarque varchar,fichier_rendu varchar,type int4)
*/
function get_exotlc_plate_forme_old($exo){
    $sql="select num_exo,titre, nomfic_rendu,formateur,  commentaire, texte, enonce, remarque,  mode_rendu from EXOTLC where num_exo=$exo;";
	//echo "sql=$sql<br>";
    return (pg_query($sql));
}

/**
    Obtenir les donnes d'un exercice a telechager de type plate_forme.
*
* @param integer numero de l'exercice
* @return integer le resultat de la requete (id integer,libelle character varying,fichier_rendu character varying,commentaire character varying,texte character varying,enonce character varying,remarque character varying,type integer, date_creation timestamp)
*/
function get_exotlc_plate_forme($exo){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_exotlc_plate_forme($exo)   
		AS (id integer,libelle character varying,fichier_rendu character varying,commentaire text,texte text ,enonce text,remarque text,type integer, date_creation timestamp,autocorrection boolean)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        return get_exotlc_plate_forme_old($exo);
	return $res;
}

/**
    Obtenir les libelles des fichiers d'un exercice  tlcharger  (OLD)
*   @deprecated : utiliser get_exotlc_fichiers
*   @param integer numero de l'exercice
*   @param integer les infos de l'exercice
*/
function get_exotlc_noms_fichier_old($exo){
    $sql="select nom_fic from FICTLC where num_fic in
                (select gestfic_num_fic from GESTFIC where gestfic_num_exo=$exo) order by nom_fic;";
    return (pg_query($sql));
}
/**
    Obtenir les libelles des fichiers d'un exercice  tlcharger
*    @deprecated : utiliser get_exotlc_fichiers
*   @param integer numero de l'exercice
*   @param integer les infos de l'exercice
*/
function get_exotlc_noms_fichier($exo){
    if(VERSION_BASE>VERSION){

    }
    else
        return get_exotlc_noms_fichier_old($exo);
}

 /**
    Obtenir les libelles des fichiers d'un exercice  tlcharger  (OLD)
*   @param integer numero de l'exercice
*   @param integer les infos de l'exercice
*/
function get_exotlc_fichiers_old($exo){
	
    $sql="select num_fic,nom_fic from FICTLC where num_fic in
                (select gestfic_num_fic from GESTFIC where gestfic_num_exo=$exo) order by nom_fic;";
	 //echo "sql=$sql<br>";
	//$sql="select gestfic_num_fic,fic_correction from gestfic where gestfic_num_exo=$exo";
    return (pg_query($sql));
}

/**
 *   Obtenir les fichiers d'un exercice  tlcharger proposs en tlchargement aux stagiaires 
 *   @param integer $exotlc numero de l'exercice
 *   @param integer les infos de l'exercice (id int4,libelle varchar)
 */
function get_exotlc_fichiers($exotlc){
    if(VERSION_BASE>VERSION){
	    $sql="select * from contraintes.af_get_exotlc_fichiers($exotlc) as (id int4,libelle varchar)";
		$res=pg_query($sql);
    }
    else
        return get_exotlc_fichiers_old($exotlc);
	return $res;
}

/**
 * Obtenir le fichier de correction d'un exercice  tlcharger  (OLD)
 *
 * @param integer $exotlc numero de l'exercice
 * @param integer les infos de l'exercice
 */
function get_exotlc_fichiers_correction_old($exotlc){
    $sql="select fic_correction,fic_correction from GESTFIC where gestfic_num_exo=$exo order by fic_correction;";
    return (pg_query($sql));
}

/**
 * Obtenir les fichiers de correction d'un exercice  tlcharger
 *
 * @param integer $exotlc numero de l'exercice
 * @param integer les infos des fichiers de correction  (id int4,libelle varchar)
 */
function get_exotlc_fichiers_correction($exotlc){
     if(VERSION_BASE>VERSION){
	     $sql="select * from contraintes.af_get_exotlc_fichiers_correction($exotlc) as  (id int4,libelle varchar)";
	     //echo "sql=$sql<br>";
		 $res=pg_query($sql);
    }
    else
        return get_exotlc_fichiers_correction_old($exotlc);
	return $res;
}

/**
    Obtenir les fichiers pour un exotlc donn (OLD)
*
*   @param integer numero de l'exercice
*   @param integer les infos de l'exercice
*/
/*
function get_exotlc_fichiers_old($exo){
    $sql="select gestfic_num_fic,fic_correction from gestfic where gestfic_num_exo=$exo";
    return (pg_query($sql));
}
*/
/**
    Obtenir les fichiers pour un exotlc donn
*
*   @param integer numero de l'exercice
*   @param integer les infos de l'exercice
*/
/*
function get_exotlc_fichiers($exo){
    if(VERSION_BASE>VERSION){

    }
    else
        return get_exotlc_fichiers_old($exo);
}
*/
/**
    Mettre  jour un exercice  tlcharger (OLD)
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero de formateur
*   @param string : le titre de l'exercice
*   @param string : le commentaire de l'exercice
*   @param string : le texte de l'exercice
*   @param string : l'nonc de l'exercice
*   @param string : la remarque de l'exercice
*   @param string : le nom du fichier rendu
*   @param string : le mode de renu du fichier (m=mail et pf=plateforme)
*   @return integer : le resultat de la requete
*/
function maj_exotlc_old($exo,$formateur,$titre,$commentaire,$texte,$enonce,$remarque,$fichier_rendu,$mode_rendu){
    $sql="update exotlc set formateur=$formateur,titre='$titre',commentaire='$commentaire',texte='$texte',
                enonce='$enonce',remarque='$remarque',nomfic_rendu='$fichier_rendu',mode_rendu='$mode_rendu'
                where num_exo=$exo";
    return (pg_query($sql));
}
/**
    Mettre  jour un exercice  tlcharger
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero de formateur
*   @param string : le titre de l'exercice
*   @param string : le commentaire de l'exercice
*   @param string : le texte de l'exercice
*   @param string : l'nonc de l'exercice
*   @param string : la remarque de l'exercice
*   @param string : le nom du fichier rendu
*   @param string : le mode de renu du fichier (m=mail et pf=plateforme)
*   @return integer : le resultat de la requete
*/
function maj_exotlc($exo,$formateur,$titre,$commentaire,$texte,$enonce,$remarque,$fichier_rendu,$mode_rendu,$autocorrection=false){
    if(VERSION_BASE>VERSION){
		if($mode_rendu==2 || $mode_rendu=='pf')
			$sql="select * from contraintes.af_maj_exotlc_plate_forme($exo,'$titre','$commentaire','$texte','$enonce','$remarque',$fichier_rendu,$autocorrection)";
		else
			$sql="select * from contraintes.af_maj_exotlc_mail($exo,'$titre','$commentaire','$texte','$enonce','$remarque',$formateur)";
		
//		echo $sql;
		$res=pg_query($sql);
		
    }
    else
        return maj_exotlc_old($exo,$formateur,$titre,$commentaire,$texte,$enonce,$remarque,$fichier_rendu,$mode_rendu);
	return $res;
}

/**
    Enregistre un exercice  tlcharger (OLD)
*
*   @param integer : le numero de formateur
*   @param string : le titre de l'exercice
*   @param string : le commentaire de l'exercice
*   @param string : le texte de l'exercice
*   @param string : l'nonc de l'exercice
*   @param string : la remarque de l'exercice
*   @param string : le nom du fichier rendu
*   @param string : le mode de renu du fichier (m=mail et pf=plateforme)
*   @return integer : le numero de l'exercice
*/
function set_exotlc_old($formateur,$titre,$commentaire,$texte,$enonce,$remarque,$fichier_rendu,$mode_rendu){
    $sql="insert into exotlc(formateur,titre,commentaire,texte,enonce,remarque,nomfic_rendu,mode_rendu)
                values($formateur,'$titre','$commentaire','$texte','$enonce','$remarque','$fichier_rendu','$mode_rendu')";
    $ins=pg_query($sql);
    $oid=pg_getlastoid($ins);
    $sql="select num_exo from exotlc where oid=$oid";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
    Enregistre un exercice  tlcharger
*
*   @param integer : le numero de formateur
*   @param string : le titre de l'exercice
*   @param string : le commentaire de l'exercice
*   @param string : le texte de l'exercice
*   @param string : l'nonc de l'exercice
*   @param string : la remarque de l'exercice
*   @param string : le nom du fichier rendu
*   @param string : le mode de renu du fichier (m=mail et pf=plateforme)
*   @return integer : le numero de l'exercice
*/
function set_exotlc($formateur,$titre,$commentaire,$texte,$enonce,$remarque,$fichier_rendu,$mode_rendu,$theme,$autocorrection=false){
    if(VERSION_BASE>VERSION){
		switch($mode_rendu){
			case 'pf':
			case 1 :
				$mode=1;
				$sql="select * from contraintes.af_set_exotlc_plateforme('$titre','$commentaire','$texte','$enonce','$remarque','$fichier_rendu',$autocorrection)";
			break;
			case 'm':
			case 2 :
				$mode=2;
				$sql="select * from contraintes.af_set_exotlc_mail('$titre','$commentaire','$texte','$enonce','$remarque',$formateur)";
			break;
		}
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
		// enregistre dans theme_categorie
		set_categorie_element_theme(33,$theme,pg_fetch_result($res,0,0));
		return pg_fetch_result($res,0,0);
    }
    else
        return set_exotlc_old($formateur,$titre,$commentaire,$texte,$enonce,$remarque,$fichier_rendu,$mode_rendu);
	
}

/**
    Supprime les fichiers associs  un exercice  tlcharger (OLD)
*
*   @param integer : le numero de l'exercice
*   @return integer : le resultat de la requete
*/
function del_exotlc_fichiers_old($exo){
    $sql="delete from gestfic where gestfic_num_exo=$exo";
    return (pg_query($sql));
}
/**
    Supprime les fichiers associs  un exercice  tlcharger
*
*   @param integer : le numero de l'exercice
*   @return integer : le resultat de la requete
*/
function del_exotlc_fichiers($exo){
    if(VERSION_BASE>VERSION){
	    $sql="select * from contraintes.af_del_exotlc_fichiers($exo)";
		$res=pg_query($sql);
    }
    else
        return del_exotlc_fichiers_old($exo);
	return $res;
}

/**
    Enregistre un fichier d'un exercice  tlcharger (OLD)
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero de fichier
*   @param string : le nom du fichier de correction
*   @return integer : le resultat de la requete
*/
function set_exotlc_fichier_old($exo,$numero_fichier,$fichier_correction){
    $sql="insert into gestfic(gestfic_num_exo,gestfic_num_fic,fic_correction) values($exo,$numero_fichier,'$fichier_correction')";
    return (pg_query($sql));

}
/**
    Enregistre un fichier d'un exercice  tlcharger
*
*   @param integer : le numero de l'exercice
*   @param integer : le numero de fichier
*   @param string : le nom du fichier de correction
*   @return integer : le resultat de la requete
*/
function set_exotlc_fichier($exo,$numero_fichier,$fichier_correction){
    if(VERSION_BASE>VERSION){
	    //$sql="select * from contraintes.af_set_exotlc_fichier
    }
    else
        return set_exotlc_fichier_old($exo,$numero_fichier,$fichier_correction);
}

/**
    Supprimer un exercice  tlcharger (OLD)
*
*   @param integer : le numero de l'exercice
*   @return integer : le resultat de la requete
*/
function del_exotlc_old($exo){
    $sql="delete from exotlc where num_exo=$exo";
    return (pg_query($sql));
}
/**
    Supprimer un exercice  tlcharger
*
*   @param integer : le numero de l'exercice
*   @return integer : le resultat de la requete
*/
function del_exotlc($exo){
    if(VERSION_BASE>VERSION){
	    $sql="select * from contraintes.af_del_etape($exo)";
		$res=pg_query($sql);
    }
    else
        return del_exotlc_old($exo);
	return $res;
}

/**
    Supprimer la correction d'un stagiaire pour une formation donne (OLD)
*
*   @param integer : le numero de formation
*   @param integer : le numero de l'individu
*   @param integer : le numero de l'exo
*   @return integer : le resultat de la requete
*/
function del_exotlc_correction_stagiaire_old($formation,$individu,$exo){
    pg_query("delete from GESTEXOTLC where gesttlc_exo='$numexo' and gesttlc_user='$individu' and num_cal='$formation';");
    pg_query("delete from COMMENTUSERRUB where num_user='$individu' and num_exo='$numexo' and num_cal='$formation';");
    return (pg_query("delete from RESEXOUSER where num_user='$individu' and num_exo='$numexo' and num_cal='$formation';"));
}
/**
    Supprimer la correction d'un stagiaire pour une formation donne
*
*   @param integer : le numero de formation
*   @param integer : le numero de l'individu
*   @param integer : le numero de l'exo
*   @return integer : le resultat de la requete
*/
function del_exotlc_correction_stagiaire($formation,$individu,$exo){
    if(VERSION_BASE>VERSION){

    }
    else
        return del_exotlc_correction_stagiaire_old($exo);
}

/**
	Obtenir le numero de l'exotlc correspondant  un fichier

	@param integer : le numero du fichier
    @return integer : le numero de l'exotlc correspondant
*/
function get_exotlc_fichier($fichier){
	
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_exotlc_fichier($fichier)";
        $res=pg_query($req);
    }
    else
       print("A implmenter...");
    return pg_fetch_result($res,0,0);
}

/**
	Enregistre les fichiers et fichiers correction pour un exotlc (OLD)
	@param integer : numero exotlc
	@param array : tableau de fichiers
	@param array : tableau de fichiers correction
*/
function set_exotlc_fichiers_all_old($exotlc,$tab_fichier,$tab_fichier_correction){
	$sz=sizeof($tab_fichier);
	for($i=0;$i<$sz;$i++){
	if(empty($tab_fichier_correction[$i]))
		$tab_fichier_correction[$i]="NULL";
	$res=	set_exotlc_fichier($exotlc,$tab_fichier[$i],$tab_fichier_correction[$i]);
	}
	return $res;
}
/**
	Enregistre les fichiers et fichiers correction pour un exotlc (OLD)
	@param integer : numero exotlc
	@param array : tableau de fichiers
	@param array : tableau de fichiers correction
*/
function set_exotlc_fichiers_all($exotlc,$tab_fichier,$tab_fichier_correction){
	if(VERSION_BASE>VERSION){
		// preparation des tableaux
		$sz=sizeof($tab_fichier);
		$tab_fich="_int4 '{";
		for($i=0;$i<$sz -1;$i++)
			$tab_fich.=$tab_fichier[$i].",";
		$tab_fich.=$tab_fichier[$sz -1]."}'";
		
		$sz=sizeof($tab_fichier_correction);
		$tab_corr="_int4 '{";
		for($i=0;$i<$sz -1;$i++)
			$tab_corr.=$tab_fichier_correction[$i].",";
		$tab_corr.=$tab_fichier_correction[$sz -1]."}'";
		
		$sql="select * from contraintes.af_set_exotlc_fichiers_all($exotlc,$tab_fich,$tab_corr)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=set_exotlc_fichiers_all_old($exotlc,$tab_fichier,$tab_fichier_correction);
	return $res;
}

/**
	Enregistre les fichiers  pour un exotlc (OLD)
	@param integer : numero exotlc
	@param array : tableau de fichiers
	@param array : tableau de fichiers correction
*/
function set_exotlc_fichiers_old($exotlc,$tab_fichier){
	$sz=sizeof($tab_fichier);
	for($i=0;$i<$sz;$i++){
	
	$res=	set_exotlc_fichier($exotlc,$tab_fichier[$i]);
	}
	return $res;
}
/**
	Enregistre les fichiers pour un exotlc (OLD)
	@param integer : numero exotlc
	@param array : tableau de fichiers
	@param array : tableau de fichiers correction
*/
function set_exotlc_fichiers($exotlc,$tab_fichier){
	if(VERSION_BASE>VERSION){
		// preparation tableau
		$sz=sizeof($tab_fichier);
		$tab_fich="_int4 '{";
		for($i=0;$i<$sz -1;$i++)
			$tab_fich.=$tab_fichier[$i].",";
		$tab_fich.=$tab_fichier[$sz -1]."}'";
		$sql="select * from contraintes.af_set_exotlc_fichiers($exotlc,$tab_fich)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else
		$res=set_exotlc_fichiers_old($exotlc,$tab_fichier);
	return $res;
}

/**
	Teste si un exotlc est supprimable (OLD)
	@param integer : numero exotlc
	@return bool : true supprimable,false non supprimable
*/
function check_exotlc_supprimable_old($exotlc){
	$sql="select * from gestparcours where type_etape='E' and num_c_q_e_d=$exotlc";
	$res=pg_query($sql);
	if(pg_num_rows($res)==0)
		return true;
	return false;
}
/**
	Teste si un exotlc est supprimable 
	@param integer : numero exotlc
	@return bool : true supprimable,false non supprimable
*/
function check_exotlc_supprimable($exotlc){
	if(VERSION_BASE>VERSION){
		 $res=!fk_finder('exotlc','id',$exotlc);
	}
	else
		$res=check_exotlc_supprimable_old($exotlc);
	return $res;
}

/**
	Obtenir le type d'un exotlc (OLD)
	@param integer : numero exotlc
	@return : le type de l'exotlc (m ou pf)
*/
function get_exotlc_type_old($exotlc){
	$sql="select mode_rendu from exotlc where num_exo=$exotlc";
	//echo "sql=$sql<br>";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0);
}
/**
	Obtenir le type d'un exotlc 
	@param integer : numero exotlc
	@return : le type de l'exotlc (1=plateforme,2=mail)
*/
function get_exotlc_type($exotlc){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_exotlc_type($exotlc)";
		$res=pg_query($sql);
		return pg_fetch_result($res,0,0);
	}
	else
		$res=get_exotlc_type_old($exotlc);
	return $res;
}

/**
    Obtenir les parcours d'un exotlc (OLD)

    @param integer : le numero de l'exotlc
    @return integer : le resultat de la requete (id int4, libelle varchar, filiere int4, duree bool)
*/
function get_exotlc_parcourss_old($exotlc,$desc=""){
	if($desc=='DESC')$ordre=" DESC";
    else $ordre="";
    $sql="	select distinct G1.g_num_parcours, nom_parcours, G2.num_c_q_e_d, affiche_fo ,lower(nom_parcours)from gestparcours G1,gestparcours G2, parcours 
			where G1.num_c_q_e_d=$exotlc 
			and G1.type_etape='E'
			AND G1.g_num_parcours=num_parcours
			AND G2.g_num_parcours=num_parcours
			AND G2.num_etape='1'
			ORDER BY lower(nom_parcours)  $ordre";
			
	//echo "$sql<br>";			
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les parcours d'un exotlc

    @param integer : le numero de lexotlc
    @param string : pour croissant (ASC, par dfaut) ou decroissant(DESC)
    @return integer : le resultat de la requete (id int4, libelle varchar, filiere int4, duree bool)
*/
function get_exotlc_parcourss($exotlc, $desc=""){
    if(VERSION_BASE>VERSION){
        return get_etape_parcourss($exotlc,$desc);
    }
    else
        $res=get_exotlc_parcourss_old($exotlc,$desc);
    return $res ;
}

/**
 * Donne l'avancement maximum d'unexotlc
 * 
 * @param integer : l'identifiant de l'exotlc
 * @return integer : le resultat de la requete (formation int4, utilisateur int4, pere int4, exotlc int4, type int4 )
 */
function get_exotlc_avancement_max_old($exotlc){
	//on verifie la table res_serie_exo car la table res_serie n'est remplie que lorsque tous les exos de la srie sont faits
	$sql="	SELECT DISTINCT id_formation, gu_num_gest_gr, id_stag, g_num_parcours, ordre_etape,num _resexouser
			FROM resexouser, gestionutil, gestionnaire
			WHERE num _resexouser=$exotlc
			AND gu_num_user=id_stag
			AND g_num_cal=num_cal
			AND g_num_gest_g=gu_num_gest_gr
			GROUP BY num_cal, gu_num_gest_gr,g_num_parcours, id_stag, ordre_etape, num _resexouser
			HAVING ordre_etape=MAX(ordre_etape)";
 	return (pg_query($sql));
}

/**
 * Donne l'avancement maximum d'unexotlc
 * 
 * @param integer : l'identifiant de lexotlc
 * @return integer : le resultat de la requete (formation int4, utilisateur int4, pere int4, exotlc int4 )
 */
function get_exotlc_avancement_max($exotlc){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_exotlc_avancement_max($exotlc) as (formation int4,classe int4, utilisateur int4,parcours int4, pere int4, exotlc int4 )";
		//echo $sql;
		$res=pg_query($sql); 
    }
    else
        $res=get_exotlc_avancement_max_old($exotlc);
    return $res ;	
}

/**
* Enregistrer le fichier d'un stagiaire pour un exotlc.
*
* @param integer : identifiant de l'exotlc
* @param integer : identifiant du stagiaire
* @param integer : identifiant de la formation
* @param integer : identifiant du parcours
* @param varchar : libelle du fichier
* 
* @return integer : Le numro du nouveau fichier, null si erreur
*/
function set_exotlc_fichier_stagiaire($exotlc,$stagiaire,$formation,$parcours, $libelle) {
	if (VERSION_BASE > VERSION) {
		$tmp_ext=get_fichier_extension($libelle);
    	$nomfic=$parcours."_".$stagiaire."_".$exotlc.".".$tmp_ext;
		$sql="select * from contraintes.af_set_fichier('$libelle',13, 'TRUE')";
		$res=pg_fetch_result(pg_query($sql),0,0);
	} else
		die("set_exotlc_fichier_stagiaire($exotlc,$stagiaire, $parcours, $libelle) OLD  implementer");
	return $res;
}

/**
* Supprimer le fichier d'un stagiaire pour un exotlc. OLD
*
* @param integer : identifiant de l'exotlc
* @param integer : identifiant du stagiaire
* @param integer : identifiant de la formation
* @param integer : identifiant du parcours
* 
* @return bool : TRUE ou FALSE selon que la suppression aie russi ou non.
*/
function del_exotlc_fichier_stagiaire_old($exotlc,$stagiaire, $formation, $parcours) {
	$sql = "delete from reception_exostlc where num_exo=$exotlc and num_stag=$stagiaire and num_cal=$formation";
	return (pg_query($sql));
}

/**
* Supprimer le fichier d'un stagiaire pour un exotlc.
*
* @param integer : identifiant de l'exotlc
* @param integer : identifiant du stagiaire
* @param integer : identifiant de la formation
* @param integer : identifiant du parcours
* @param integer : identifiant du fichier
* 
* @return bool : TRUE ou FALSE selon que la suppression aie russi ou non.
*/
function del_exotlc_fichier_stagiaire($exotlc,$stagiaire, $formation, $parcours, $fichier) {
	global $chemin_fo;
	if (VERSION_BASE > VERSION) {
		$tmp_ext=get_fichier_extension(pg_fetch_result(get_fichier($fichier),0,1));
    	$nomfic=$parcours."_".$stagiaire."_".$exotlc.".".$tmp_ext;
		del_fichier($chemin_fo.UPLOAD_EXOTLC_DIR."$formation/$nomfic");
	} else
		del_exotlc_fichier_stagiaire_old($exotlc,$stagiaire, $formation, $parcours);
	return $res;
}

/**
	Obtenir les stagiaires corrigs pour un exotlc
	@param integer : identifiant de l'exotlc
	@param integer : identifiant du parcours
	@param integer : identifiant de la formation
	@return integer : resultat requete (id_stagiaire,nom,prenom)
*/
function get_exotlc_stagiaires_corriges_formation($exotlc,$parcours,$formation){
	$sql="select * from contraintes.af_get_exotlc_stagiaires_corriges_formation($exotlc,$parcours,$formation,true) 
			as (id int4,nom varchar,prenom varchar)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir les stagiaires non corrigs pour un exotlc
	@param integer : identifiant de l'exotlc
	@param integer : identifiant du parcours
	@param integer : identifiant de la formation
	@return integer : resultat requete (id_stagiaire,nom,prenom)
*/
function get_exotlc_stagiaires_non_corriges_formation($exotlc,$parcours,$formation){
	$sql="select * from contraintes.af_get_exotlc_stagiaires_corriges_formation($exotlc,$parcours,$formation,false) 
			as (id int4,nom varchar,prenom varchar)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir les stagiaires qui ont rendu leur fichier pour un exotlc (old)
	@param integer : formation
	@param integer : parcours
	@param integer : exotlc
	@return integer : res req
*/
function get_exotlc_stagiaires_fichier_rendu_old($formation,$parcours,$exotlc){

}
/**
	Obtenir les stagiaires qui ont rendu leur fichier pour un exotlc 
	@param integer : formation
	@param integer : parcours
	@param integer : exotlc
	@return integer : res req
*/
function get_exotlc_stagiaires_fichier_rendu($formation,$parcours,$exotlc){
	if(VERSION_BASE>VERSION){
		 $sql="select * from contraintes.af_get_exotlc_stagiaires_fichier_rendu($formation,$parcours,$exotlc) 
				as (id int4,nom varchar,prenom varchar,fichier_rendu int4)";
		 //echo "sql=$sql<br>";
		 $res=pg_query($sql);
	}
	else
		$res=get_exotlc_stagiaires_fichier_rendu_old($formation,$parcours,$exotlc);
	return $res;
}

/**
*   Obtenir les formations qui utilisent l'exotlc
*
*   @param integer : le numro exotlc
*   @return integer : le rsultat de la requte (id int4, libelle varchar)
*/
function get_exotlc_formations($exotlc,$desc){
     if(VERSION_BASE>VERSION){
        return get_etape_formations($exotlc,$desc);
    }
    else
        return get_exotlc_formations_old($exotlc,$desc);
}

/**
    Obtenir les infos sur les groupe qui utilisent l'exotlc donne en paramtre

    @param integer : le numero exotlc
    @param string : 'ASC' pour croissant(par dfaut) ou 'DESC' pour decroissant 
    @return integer : le resultat de la requete (id int4, libelle varchar)
*/
function get_exotlc_classes($exotlc,$desc){
    if(VERSION_BASE>VERSION){
        return get_etape_classes($exotlc,$desc);
    }
    else
        $res=get_exotlc_classes_old($exotlc,$desc);
    return $res ;
}

/**
    Obtenir les infos sur les formations d'un groupe qui utilise l'exotlc donne en paramtre (OLD)

    @param integer : le numero exotlc
    @param integer : le numero de la classe
    @param string : 'ASC' pour croissant(par dfaut) ou 'DESC' pour decroissant 
    @return integer : le resultat de la requete (id int4, libelle varchar
*/
function get_exotlc_formations_classe($exotlc,$classe, $desc=""){
    if(VERSION_BASE>VERSION){
		return get_etape_formations_classe($exotlc,$classe, $desc="");
    }
    else
        $res=get_exotlc_formations_classe_old($exotlc,$classe, $desc);
    return $res ;
}

/**
    Obtenir les infos sur les filieres des parcours qui utilisent l'exotlc donne en paramtre

   	@param integer : le numero exotlc
    @param string : pour croissant ou decroissant
    @param char : le type de la serie
    @return integer : le resultat de la requete (id int4, libelle  varchar, pere int4, parcours int4)
*/
function get_exotlc_filieres($exotlc,$desc, $type=""){
    if(VERSION_BASE>VERSION){
    	return get_etape_filieres($exotlc,$desc);
    }
    else
        $res=get_exotlc_filieres_old($exotlc,$desc,$type);
    return $res ;
}


function get_exotlc_modele_correction($exotlc){
	if(VERSION_BASE>VERSION){
		 $sql="select * from contraintes.af_get_exotlc_modele_correction($exotlc) 
				as (id int4,libelle varchar)";
		 //echo "sql=$sql<br>";
		 $res=pg_fetch_row(pg_query($sql),0);
	}
	else
		die("get_exotlc_modele_correction: n'existe pas pour la version ".VERSION);
		
	return $res;
}

/**
 * Mettre  jour le modele de correction d'un exo pf autocorrige
 * @param integer : le numero exotlc
 * @param integer : le modele de correction
 * @return integer : res req
 */
 function maj_exotlc_modele_correction($exotlc,$modele){
 	$sql="select * from contraintes.af_maj_exotlc_modele_correction($exotlc,$modele)";
 	//echo "sql=$sql<br>";
 	return pg_query($sql);
 }
?>