<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
 * @package fichier
 * @modulegroup fonctions
 */

/**
	Convertis la taille  d'un fichier en une taille en kilo ou m�ga.
	@param integer: la taille du fichier
	@param string : l'unit� de le taille (octet par exemple)
	@return string : une chaine avec la taille au format d�sir�. 

*/
function FormatTailleFichier($Taille, $unite) {
//echo "\$Taille=$Taille";
	if ($Taille == 0)
		$format = "";
	else
		if ($Taille <= 1024)
			$format = $Taille." $unite";
		else
			if ($Taille <= (10 * 1024))
				$format = sprintf("%d k %s", ($Taille / 1024), $unite);
			else
				if ($Taille <= (100 * 1024))
					$format = sprintf("%d k %s", ($Taille / 1024), $unite);
				else
					if ($Taille <= (1024 * 1024))
						$format = sprintf("%d k %s", ($Taille / 1024), $unite);
					else
						if ($Taille <= (10 * 1024 * 1024))
							$format = sprintf("%d M %s", ($Taille / (1024 * 1024)), $unite);
						else
							if ($Taille <= (100 * 1024 * 1024))
								$format = sprintf("%d M %s", ($Taille / (1024 * 1024)), $unite);
							else
								$format = sprintf("%d M %s", ($Taille / (1024 * 1024)), $unite);

	return $format;
}

/**
	Obtenir la taille d'un fichier.
	Fonctionne aussi avec les fichiers textes 
	@param string : le chemin du fichier ou le contenu du fichier
	@param string : l'unit� (o, b, ...)..
	@return string: une chaine format�e pr�sentant la taille du fichier
*/
function get_fichier_taille($fichier, $size_unit) {
	if (file_exists($fichier)) {
		$taille = filesize($fichier);
		if ($taille >= 1073741824) {
			$taille = (round($taille / 1073741824 * 100) / 100)." G".$size_unit;
		}
		elseif ($taille >= 1048576) {
			$taille = (round($taille / 1048576 * 100) / 100)." M".$size_unit;
		}
		elseif ($taille >= 1024) {
			$taille = (round($taille / 1024 * 100) / 100)." K".$size_unit;
		} else {
			$taille = $taille." ".$size_unit;
		}
	} else {
		$taille = strlen($fichier)." ".$size_unit;
	}
	if ($taille == 0) {
		$taille = "-";
	}

	return $taille;
}

/**
	Savoir si un fichier est �ditable par la plate forme.
	Un fichier est �ditable si c'est un fichier texte avec une extention classique (.php , .html, . cgi, etc...)
	@param string : le nom du fichier
	@return boolean : true si le fichier est dans un format �ditable, false sinon
*/
function is_editable($fichier) {
	$retour = false;
	if (eregi("\.txt$|\.sql$|\.php$|\.php3$|\.phtml$|\.htm$|\.html$|\.cgi$|\.pl$|\.js$|\.css$|\.inc$", $fichier)) {
		$retour = true;
	}
	return $retour;
}

/**
	Savoir si un fichier est une image
	@param string: le nom du fichier
	@return boolean: true si image, false sinon
*/
function is_image($fichier) {
	$retour = false;
	if (eregi("\.png$|\.bmp$|\.jpg$|\.jpeg$|\.gif$", $fichier)) {
		$retour = true;
	}
	return $retour;
}
/**
 * Obtenir la date et l'heure de modification d'un fichier.
 * Selon les langues ($s_langue ), le format de sortie peut-etre diff�rent, car il est adapt� � la repr�sentation du pays.
 * @param string $fichier le chemin du fichier
 * @param boolean $date_only retourner uniquement la date si true
 * @return Array  un tableau dont le premier element contient la chaine date au format
 *	jour/mois/ann�e et dont le second contient l'heure au format heures/minutes/secondes.
 */
function get_fichier_date_modification($fichier,$date_only=false) {
	global $s_langue;
	if (file_exists($fichier)) {
		$tmp = filemtime($fichier);
		if($s_langue==1){
			$tmp=date("d/m/Y H:i:s", $tmp);
		}else{
			$tmp=date("Y/m/d H:i:s", $tmp);
		}
		$tab_date_heure=explode(' ',$tmp);
		if($date_only)
			return $tab_date_heure[0];
		else
			return $tab_date_heure;
	}else{
		return '-';
	}
}


/**
	Retourne l'image ou le libell� correspondant au type l'un fichier en fonction de son extension
	A ne pas utiliser dans les scripts!
	@deprecated utiliser plutot get_fichier_image_type($fichier) ou get_fichier_libelle_type($fichier)
	 
	@param string: le ch$MSG_2556emin du fichier
	@param string : "image" ou n'importe quoi
	@return string : le nom de l'image du fichier ou le libell� du type
*/
function mimetype($fichier, $quoi) {
	global $HTTP_USER_AGENT;
	global $MSG_1908, $MSG_1909, $MSG_1910, $MSG_1911, $MSG_1912, $MSG_1913, $MSG_1914, $MSG_1915, $MSG_1960;
	global $MSG_1961, $MSG_1916, $MSG_1917, $MSG_1918, $MSG_1919, $MSG_1920, $MSG_1921, $MSG_1922, $MSG_1950;
	global $MSG_1956, $MSG_1957, $MSG_1958, $MSG_1959, $MSG_1964, $MSG_1965, $MSG_1979, $MSG_1980, $MSG_1981;
	global $MSG_1982, $MSG_1983, $MSG_2008, $MSG_2009, $MSG_1923, $MSG_1991,$MSG_2556;
	if (!eregi("MSIE", $HTTP_USER_AGENT)) {
		$client = "netscape.gif";
	} 
	else {
		$client = "html.gif";
	}
	if (is_dir($fichier)) {
		$image = "dossier.gif";
		$nom_type = $MSG_1908;
	} 
	else
		if (eregi("\.mid$", $fichier)) {
			$image = "mid.gif";
			$nom_type = $MSG_1909;
		} 
		else
			if (eregi("\.txt$", $fichier)) {
				$image = "txt.gif";
				$nom_type = $MSG_1910;
			} 
			else
				if (eregi("\.sql$", $fichier)) {
					$image = "txt.gif";
					$nom_type = $MSG_1910;
				} 
				else
					if (eregi("\.js$", $fichier)) {
						$image = "js.gif";
						$nom_type = $MSG_1911;
					} 
					else
						if (eregi("\.gif$", $fichier)) {
							$image = "gif.gif";
							$nom_type = $MSG_1912;
						} 
						else
							if (eregi("\.jpg$", $fichier)) {
								$image = "jpg.gif";
								$nom_type = $MSG_1913;
							} 
							else
								if (eregi("\.jpeg$", $fichier)) {
									$image = "jpg.gif";
									$nom_type = $MSG_1913;
								} 
								else
									if (eregi("\.html$", $fichier)) {
										$image = $client;
										$nom_type = $MSG_1914;
									} 
									else
										if (eregi("\.htm$", $fichier)) {
											$image = $client;
											$nom_type = $MSG_1915;
										} 
										else
											if (eregi("\.rar$", $fichier)) {
												$image = "rar.gif";
												$nom_type = $MSG_1960;
											} 
											else
												if (eregi("\.gz$", $fichier)) {
													$image = "zip.gif";
													$nom_type = $MSG_1961;
												} 
												else
													if (eregi("\.tgz$", $fichier)) {
														$image = "zip.gif";
														$nom_type = $MSG_1961;
													} 
													else
														if (eregi("\.z$", $fichier)) {
															$image = "zip.gif";
															$nom_type = $MSG_1961;
														} 
														else
															if (eregi("\.ra$", $fichier)) {
																$image = "ram.gif";
																$nom_type = $MSG_1916;
															} 
															else
																if (eregi("\.ram$", $fichier)) {
																	$image = "ram.gif";
																	$nom_type = $MSG_1917;
																} 
																else
																	if (eregi("\.rm$", $fichier)) {
																		$image = "ram.gif";
																		$nom_type = $MSG_1917;
																	} 
																	else
																		if (eregi("\.pl$", $fichier)) {
																			$image = "pl.gif";
																			$nom_type = $MSG_1918;
																		} 
																		else
																			if (eregi("\.zip$", $fichier)) {
																				$image = "zip.gif";
																				$nom_type = $MSG_1919;
																			} 
																			else
																				if (eregi("\.wav$", $fichier)) {
																					$image = "wav.gif";
																					$nom_type = $MSG_1920;
																				} 
																				else
																					if (eregi("\.php$", $fichier)) {
																						$image = "php.gif";
																						$nom_type = $MSG_1921;
																					} 
																				else
																						if (eregi("\.php3$", $fichier)) {
																							$image = "php.gif";
																							$nom_type = $MSG_1922;
																						} 
																						else
																							if (eregi("\.phtml$", $fichier)) {
																								$image = "php.gif";
																								$nom_type = $MSG_1922;
																							} 
																							else
																								if (eregi("\.exe$", $fichier)) {
																									$image = "exe.gif";
																									$nom_type = $MSG_1950;
																								} 
																								else
																									if (eregi("\.bmp$", $fichier)) {
																										$image = "bmp.gif";
																										$nom_type = $MSG_1956;
																									} 
																									else
																										if (eregi("\.png$", $fichier)) {
																											$image = "gif.gif";
																											$nom_type = $MSG_1957;
																										} 
																										else
																											if (eregi("\.css$", $fichier)) {
																												$image = "css.gif";
																												$nom_type = $MSG_1958;
																											} 
																											else
																												if (eregi("\.mp3$", $fichier)) {
																													$image = "mp3.gif";
																													$nom_type = $MSG_1959;
																												} 
																												else
																													if (eregi("\.xls$", $fichier)) {
																														$image = "xls.gif";
																														$nom_type = $MSG_1964;
																													} 
																													else
																														if (eregi("\.doc$", $fichier)) {
																															$image = "doc.gif";
																															$nom_type = $MSG_1965;
																														} 
																														else
																															if (eregi("\.pdf$", $fichier)) {
																																$image = "pdf.gif";
																																$nom_type = $MSG_1979;
																															}
																															else
																																if (eregi("\.mov$", $fichier)) {
																																	$image = "mov.gif";
																																	$nom_type = $MSG_1980;
																																} 
																																else
																																	if (eregi("\.avi$", $fichier)) {
																																		$image = "avi.gif";
																																		$nom_type = $MSG_1981;
																																	} 
																																	else
																																		if (eregi("\.mpg$", $fichier)) {
																																			$image = "mpg.gif";
																																			$nom_type = $MSG_1982;
																																		} 
																																		else
																																			if (eregi("\.mpeg$", $fichier)) {
																																				$image = "mpeg.gif";
																																				$nom_type = $MSG_1983;
																																			} 
																																			else
																																				if (eregi("\.swf$", $fichier)) {
																																					$image = "flash.gif";
																																					$nom_type = $MSG_1991;
																																				} 
																																				else
																																					if (eregi("\.css$", $fichier)) {
																																						$image = "css.gif";
																																						$nom_type = $MSG_2008;
																																					} 
																																					else
																																						if (eregi("\.ppt$", $fichier)) {
																																							$image = "defaut.gif";
																																							$nom_type = $MSG_2009;
																																						} 
																																						else 
																																							if (eregi("\.tpl$", $fichier)) {
																																								$image = "defaut.gif";
																																								$nom_type = $MSG_2556;
																																							} 
																																							else {
																																								if (eregi("\.flv$", $fichier)) {
																																								$image = "defaut.gif";
																																								$nom_type = MSG_2690;
																																								} 
																																								else {
																																									$image = "typelink.gif";
																																									$nom_type = Lien;
																																								}
																																							}
	if ($quoi == "image") {
		return $image;
	} else {
		return $nom_type;
	}
}

/**
	Retourne le libelle correspondant au type l'un fichier en fonction de son extension
	 
	@param string: le nom du fichier
	@return string : le nom de l'image du fichier ou le libell\x{00E9} du type
*/
function get_fichier_type_libelle($fichier) {
	return mimetype($fichier, "libelle");
}

/**
	Retourne l'image correspondant au type l'un fichier en fonction de son extension
	 
	@param string: le nom du fichier
	@return string : le nom de l'image du fichier ou le libell\x{00E9} du type
*/
function get_fichier_type_image($fichier) {
	return mimetype($fichier, "image");
}

/**
	Remplace des chemins des balises d'un fichier HTML
	par les chemins correspondant � ceux de la plate-forme
	@param string : le chemin du fichier � parser
*/
function parse_html($fichier) {
	global $serverfront;
	if (!$read = @ fopen($fichier, 'rb'))
		$result = "Impossible d'ouvrir le fichier";
	else {

		if (!$doc = @ fread($read, filesize($fichier)))
			$result = "Impossible de lire le fichier";
		else {
			$address = 'http://<?php print ($serverfront);
										
													?>/data/exostlc/<?php print ($nomrep);
										
													?>/image/';
			$address_css = 'http://<?php print ($serverfront);
										
													?>/data/exostlc/<?php print ($nomrep);
										
													?>/css/';

			//image de fond dans le body
			$doc = preg_replace('/(background=")([^"]*)\/([^"]+)("[^>]*>)/i', "\\1$address\\3\\4", $doc);

			// essai
			// la methode ci dessus ne fonctionne pas si <img height=...src
			$doc = preg_replace('/(<img[ ]+.*src=")([^"]*)\/([^"]+)("[^>]*>)/i', "\\1$address\\3\\4", $doc);

			// frame
			$doc = preg_replace('/(<frame[ ]+.*src=")([^"]*)\/([^"]+)("[^>]*>)/i', "\\1$address\\3\\4", $doc);

			// href
			$doc = preg_replace('/(href="\/)([^"]*)\/([^"]+)("[^>]*>)/i', "href=\"$address\\3\\4", $doc);

			// test href=javascript
			$doc = preg_replace('/(href="javascript:)([^"]+)([(]{1})([\']{1})([^"]+)\/([^"]*)([\']{1})([)]{1})("[^>]*>)/i', "\\1\\2\\3\\4$address\\6\\7\\8\\9", $doc);

			//Pour flash
			$doc = preg_replace('/(<embed[ ]+.*src=")([^"]*)\/([^"]+)("[^>]*>)/i', "\\1$address\\3\\4", $doc);
			$doc = preg_replace('/(<param[ ]+name=movie)([ ]*)(value=")([^"]*)\/([^"]*)("[^>]*>)/i', "\\1\\2\\3$address\\5\\6", $doc);
			$doc = preg_replace('/(<param[ ]+name="movie")([ ]*)(value=")([^"]*)\/([^"]*)("[^>]*>)/i', "\\1\\2\\3$address\\5\\6", $doc);

			//Pour le css
			$doc = preg_replace('/(<link[ ]+rel=\"stylesheet\")([ ]*)(type=\"text\/css\")([ ]*)(href=")([^"]*)\/([^"]+)("[^>]*>)/i', "\\1\\2\\3\\4\\5$address_css\\7\\8", $doc);
			$taille = strlen($doc);

			fclose($read);
			if (!$fp = @ fopen($fichier, 'w'))
				$result = "Impossible d'ouvrir le fichier";
			else {
				fwrite($fp, $doc, $taille);
				fclose($fp);
			}
		}
	}
	return $result;

}

/**

*/
function nettoie($fichier) {
	if (!$read = @ fopen($fichier, 'rb+'))
		$result = "Impossible d'ouvrir le fichier";
	else {
		if (!$doc = @ fread($read, filesize($fichier)))
			$result = "Impossible de lire le fichier";
		else {

			$mot = '</html>';
			list ($tab) = split("$mot", $doc);
			if ($tab != "")
				$doc = $tab.'</html>';
			unlink($fichier);
			if (!$fp = @ fopen($fichier, 'w'))
				$result = "Impossible d'ouvrir le fichier";
			else {
				//rewind($read);
				fwrite($fp, $doc, strlen($doc));
				fclose($fp);
			}
			fclose($read);
		}
	}
}

/**
 Converti une chaine contenant des caract�res texte en caract�res html
 @param string : la chaine � convertir
 @return string : la chaine convertie
*/
function txt_vers_html($chaine) {

	$chaine = str_replace("&#8216;", "'", $chaine);
	$chaine = str_replace("&#339;", "oe", $chaine);
	$chaine = str_replace("&#8217;", "'", $chaine);
	$chaine = str_replace("&#8230;", "...", $chaine);
	$chaine = str_replace("&", "&amp;", $chaine);
	$chaine = str_replace("<", "&lt;", $chaine);
	$chaine = str_replace(">", "&gt;", $chaine);
	$chaine = str_replace("\"", "&quot;", $chaine);
	$chaine = str_replace("�", "&agrave;", $chaine);
	$chaine = str_replace("&", "&eacute;", $chaine);
	$chaine = str_replace("�", "&egrave;", $chaine);
	$chaine = str_replace("�", "&ugrave;", $chaine);
	$chaine = str_replace("�", "&acirc;", $chaine);
	$chaine = str_replace("�", "&ecirc;", $chaine);
	$chaine = str_replace("�", "&icirc;", $chaine);
	$chaine = str_replace("�", "&ocirc;", $chaine);
	$chaine = str_replace("�", "&ucirc;", $chaine);
	$chaine = str_replace("�", "&auml;", $chaine);
	$chaine = str_replace("�", "&euml;", $chaine);
	$chaine = str_replace("�", "&iuml;", $chaine);
	$chaine = str_replace("�", "&ouml;", $chaine);
	$chaine = str_replace("�", "&uuml;", $chaine);
	return $chaine;
}

/**
	Optenir un tableau tri� des fichiers contenus dans un r�pertoire.
	Les options de tris sont d�finies par les variables globales  $sens,$ordre et $size_unit
	permet de pr�ciser l'unit�.
	@param string : le chemin du repretoire
	@return array : un tableau contenant les fichiers, null sinon
*/
function lister_repertoire($nom_rep) {
	global $sens, $ordre, $size_unit;
	$handle = @ opendir($nom_rep);
	if ($handle) {
		while ($fichier = readdir($handle)) {
			if ($fichier != "." && $fichier != ".." && !is_dir($nom_rep."/".$fichier)) {
				$poidsfic = filesize("$nom_rep/$fichier");
				if ($ordre == "nom") {
					$liste_fic[$fichier] = get_fichier_type_image("$nom_rep/$fichier");
				} else
					if ($ordre == "taille") {
						$liste_fic[$fichier] = $poidsfic;
					} else
						if ($ordre == "mod") {
							$liste_fic[$fichier] = filemtime("$nom_rep/$fichier");
						} else
							if ($ordre == "type") {
								$liste_fic[$fichier] = get_fichier_type_libelle("$nom_rep/$fichier");
							} else {
								$liste_fic[$fichier] = get_fichier_type_image("$nom_rep/$fichier", "image");
							}
			}

		}

		closedir($handle);

		if (is_array($liste_fic)) {
			if ($ordre == "nom") {
				if ($sens == 0) {
					ksort($liste_fic);
				} else {
					krsort($liste_fic);
				}
			} else
				if ($ordre == "mod") {
					if ($sens == 0) {
						arsort($liste_fic);
					} else {
						asort($liste_fic);
					}
				} else
					if ($ordre == "taille" || $ordre == "type") {
						if ($sens == 0) {
							asort($liste_fic);
						} else {
							arsort($liste_fic);
						}
					} else {
						if ($sens == 0) {
							ksort($liste_fic);
						} else {
							krsort($liste_fic);
						}
					}
		}

		return $liste_fic;
	} else {
		return null;
	}

}

/**
//TODO
	Trier un tableau de fichiers (id, libelle, connected)
	Les options de tris sont definies par les variables globales  $sens,$ordre et $size_unit
	permet de preciser l'unite.
	Attention: le nom des fichiers doit etre unique!!
	@param array : le tableau contenant les fichiers � trier
	@param string : le repertoire dans lequel sont les fichiers
	@return array : le tableau tri� (libelle, ordre_value, id, connecte)
*/
function lister_repertoire_from_array($tableau, $repertoire) {
	global $sens, $ordre, $size_unit;
	if (!is_array($tableau)) {
		print ("Erreur fonction lister_repertoire_from_array: le parametre n'est pas un tableau");
		exit;
	}

	$size = count($tableau);
	//echo "size=$size<br>";
	for ($i = 0; $i < $size; $i ++) {

		//sauve et efface la ligne courante
		$tmp = $tableau[$i];
		unset ($tableau[$i]);

		//test l'unicit� de la cl�->erreur si la cl� n'est pas unique, cad si les noms de fichier ne sont
		//pas uniques
		if (!empty ($tableau[$tmp[1]])) {
//TODO			print ("<BR>Erreur: le tableau de fichiers pass� en parametre � la fonction lister_repertoire_from_array() contient des doublons!(".$tableau[$tmp[1]][0].")<BR>");
		}
		//met met le champ libelle en cl� et le champ de ordre en 1ere position
		if ($ordre == "nom") {
			$tableau[$tmp[1]][0] = get_fichier_type_image("$repertoire/".$tmp[1]);
		} else
			if ($ordre == "taille") {
				$tableau[$tmp[1]][0] = filesize("$repertoire/".$tmp[0].".".get_fichier_extension($tmp[1]));
			} else
				if ($ordre == "mod") {
					$tableau[$tmp[1]][0] = filemtime("$repertoire/".$tmp[0].".".get_fichier_extension($tmp[1]));
				} else
					if ($ordre == "type") {
						$tableau[$tmp[1]][0] = get_fichier_type_libelle("$repertoire/".$tmp[1]);
					} else {
						$tableau[$tmp[1]][0] = get_fichier_type_image("$repertoire/".$tmp[1]);
					}

		//met de champ id en 2eme position
		$tableau[$tmp[1]][1] = $tmp[0];
		//met le champ type en 3eme position
		$tableau[$tmp[1]][2] = $tmp[2];
		//met le champ connecte en 4eme position
		$tableau[$tmp[1]][3] = $tmp[3];

	}

	if ($ordre == "nom") {
		if ($sens == 0) {
			ksort($tableau);
		} else {
			krsort($tableau);
		}
	} else
		if ($ordre == "mod") {
			if ($sens == 0) {
				arsort($tableau);
			} else {
				asort($tableau);
			}
		} else
			if ($ordre == "taille" || $ordre == "type") {
				if ($sens == 0) {
					asort($tableau);
				} else {
					arsort($tableau);
				}
			} else {
				if ($sens == 0) {
					ksort($tableau);
				} else {
					krsort($tableau);
				}
			}

	return $tableau;
}

/**
	Trier un tableau de fichiers texte (id, libelle, connected, titre, lien, desciption, date_modification)
	Les options de tris sont definies par les variables globales  $sens,$ordre et $size_unit
	permet de preciser l'unite.
	Attention: le nom des fichiers doit etre unique!!
	@param array : le tableau contenant les fichiers textes � trier
	@return array : le tableau tri� (libelle, ordre_value, id, connecte)
*/
function lister_fichiers_textes_from_array($tableau) {
	global $sens, $ordre, $size_unit;

	if (!is_array($tableau)) {
		print ("Erreur fonction lister_fichiers_textes_from_array: le parametre n'est pas un tableau");
		exit;
	}

	$size = count($tableau);
	for ($i = 0; $i < $size; $i ++) {

		//sauve et efface la ligne courante
		$tmp = $tableau[$i];
		unset ($tableau[$i]);

		//test l'unicit� de la cl�->erreur si la cl� n'est pas unique, cad si les noms de fichier ne sont
		//pas uniques
		if (isset ($tableau[$tmp[1]])) {
			print ("<BR>Erreur: le tableau de fichiers pass� en parametre � la fonction lister_repertoire_from_array() contient des doublons!<BR>");
		}
		//met met le champ libelle en cl� et le champ de ordre en 1ere position
		if ($ordre == "nom") {
			$tableau[$tmp[1]][0] = get_fichier_type_image("$repertoire/".$tmp[1]);
		} else
			if ($ordre == "taille") {
				$tableau[$tmp[1]][0] = get_fichier_taille($tmp[7], 'caracteres');
			} else
				if ($ordre == "mod") {
					$tableau[$tmp[1]][0] = $tmp[8];
				} else
					if ($ordre == "type") {
						$tableau[$tmp[1]][0] = get_fichier_type_libelle("$repertoire/".$tmp[1]);
					} else {
						$tableau[$tmp[1]][0] = get_fichier_type_image("$repertoire/".$tmp[1]);
					}

		//met de champ id en 2eme position
		$tableau[$tmp[1]][1] = $tmp[0];
		//met le champ type en 3eme position
		$tableau[$tmp[1]][2] = $tmp[2];
		//met le champ connecte en 4eme position
		$tableau[$tmp[1]][3] = $tmp[3];
		//met le champ titre en 5eme position
		$tableau[$tmp[1]][4] = $tmp[4];
		//met le champ lien en 6eme position
		$tableau[$tmp[1]][5] = $tmp[5];
		//met le champ description en 7eme position
		$tableau[$tmp[1]][6] = $tmp[6];
		//met le champ format en 8eme position
		$tableau[$tmp[1]][7] = $tmp[7];
		//met le champ date en 9eme position
		$tableau[$tmp[1]][8] = $tmp[8];
	}

	if ($ordre == "nom") {
		if ($sens == 0) {
			ksort($tableau);
		} else {
			krsort($tableau);
		}
	} else
		if ($ordre == "mod") {
			if ($sens == 0) {
				arsort($tableau);
			} else {
				asort($tableau);
			}
		} else
			if ($ordre == "taille" || $ordre == "type") {
				if ($sens == 0) {
					asort($tableau);
				} else {
					arsort($tableau);
				}
			} else {
				if ($sens == 0) {
					ksort($tableau);
				} else {
					krsort($tableau);
				}
			}

	return $tableau;
}

/**
AFFICHAGE DE LA BARRE D'AIDE
*/
function barre_outil($revenir) {
	global $font, $ordre, $sens, $user, $users, $rep, $allow_change_lang;
	global $MSG_1932;

	echo "<table class=\"tableau_normal\"><tr><td><b>\n";
	if ($revenir == 0) {
		echo "<img src=\"../images/dossier.gif\" width=\"20\" height=\"20\" align=\"ABSMIDDLE\">\n";
	}
	echo "<a class=\"retour\" href=\"";
	if ($revenir == 1) {
		echo "index.php?ordre=$ordre&sens=$sens&rep=$rep";
	} else {
		echo "index.php?ordre=$ordre&sens=$sens";
	}
	echo "\">";
	if ($revenir == 1) {
		echo "$MSG_1932</a>";
	} else {
		echo "$user</a>";
		$array_chemin = split("/", $rep);
		while (list ($cle, $val) = each($array_chemin)) {
			if ($val != "") {
				if ($addchemin != "") {
					$addchemin = $addchemin."/".$val;
				} else {
					$addchemin = $val;
				}
				echo "/<a href=\"index.php?ordre=$ordre&sens=$sens&rep=$addchemin\">Th&egrave;me : $val</a>";
			} else {
				echo "S&eacute;lectionnez un th&egrave;me dans la liste ci-dessous :";
			}

		}
	}
	echo "</b></td>";
	echo "<td align=\"right\">&nbsp;</td></tr></table><br>\n";
}

/**
	AFFICHAGE INTERNE DU CONTENU DES CATEGORIES (LISTE DES FICHIERS) + Gestion allias
*/
function contenu_dir1() {
	global $font, $sens, $ordre, $rep, $cat, $liste_cat, $db, $racine, $nb_fich, $MSG_2008;

	// recupration du repertoire
	$lecture = pg_query("SELECT nom_rep FROM THEMEDIR where num_themedir='$rep'");
	$nom_rep = pg_fetch_row($lecture, 0);

	$nom_rep = $racine.$nom_rep[0]."/".$liste_cat[$cat][1];
	// LECTURE DU REPERTOIRE ET CLASSEMENT DES FICHIERS
	$ordre = "nom";
	$sens = 0;
	$liste = listing($nom_rep);

	//recup des allias
	$resallias = pg_query("select libelle,allias from allias_fichier where theme='$rep';");
	$nballias = pg_numrows($resallias);

	// AFFICHAGE
	if (is_array($liste)) {
		$taille_liste = sizeof($liste);
		$i = 0;
		$ind = 0;
		while (list ($fichier, $mime) = each($liste)) {
			if ($liste_cat[$cat][2] != "") {

				$lstfic = pg_query("select num_fic from ".$liste_cat[$cat][2]." where num_themedir=$rep and nom_fic='$fichier';");
				$numlstfic = pg_numrows($lstfic);
				$affiche_connect = ($numlstfic == 0);
				if (!$affiche_connect) {
					// en base
					$num_fic = pg_fetch_row($lstfic, 0);
					$num_fic = $num_fic[0];
					$query = str_replace("_NUM_FIC_", $num_fic, $liste_cat[$cat][3]);
					$query = str_replace("_NUM_THEME_", $rep, $query);
					$query = str_replace("_NOM_TABLE_", $liste_cat[$cat][2], $query);
					$linkfic = pg_query($query);
					$numlinkfic = pg_numrows($linkfic);
					$affiche_link = ($numlinkfic == 0);
					if (!$affiche_link) {
						// Lie
						$java_link = "lock";
						$image_link = "lock.gif";
						$mess_link = $mess[103];
					} else {
						// Pas lie
						$java_link = "link";
						$image_link = "link.gif";
						$mess_link = $mess[101];
					}
				} else {
					// pas en base
					$java_link = "unlink";
					$image_link = "unlink.gif";
					$mess_link = $mess[102];
				}
			} else {
				$java_link = "nobase";
				$image_link = "blank.gif";
			}

			$i ++;
			// DEFINITION DU LIEN SUR LE FICHIER
			$lien = "";
			$lien .= $fichier."&rep=$rep&cat=$cat";

			$lien = "'$java_link', '$fichier'";

			$affiche_copier = "oui";

			// AFFICHAGE DE LA LIGNE
			echo "<tr class=\"couleur2\" id=\"$fichier\">\n";
			echo "<td nowrap>";
			echo "<img src=\"../images/".mimetype("$nom_rep/$fichier", "image")."\" width=\"20\" height=\"20\" align=\"ABSMIDDLE\" border=\"0\">&nbsp;";
			echo "$fichier";

			if (is_editable($fichier) || is_image($fichier) || is_dir("$nom_rep/$fichier")) {
				echo "</a>\n";
			}
			echo "</td>\n";
			//recup de l'allias s'il existe
			$nomfich = str_replace(".", "_", "$fichier");
			$res = pg_query("select * from allias_fichier where libelle = '$nomfich' and theme='$rep';");
			$cnt = pg_numrows($res);
			if (pg_numrows($res) == 1) {
				$row = pg_fetch_row($res, 0);
				$valeur = $row[3];
			} else
				$valeur = "";

			echo "<td><input type=\"text\" name=\"$fichier\" value=\"$valeur\" size=\"40\"></td>";
			echo "<td nowrap>";

			// IMAGE VISUALISER
			echo "<a href=\"javascript:popup('index.php?action=voir&rep=$rep&cat=$cat&fichier=$fichier');\">";
			echo "<img src=\"../images/view2.gif\" alt=\"$MSG_2008\" width=\"20\" height=\"20\" border=\"0\"></a>";

			echo "</td>\n";
			echo "</tr>\n";
			$ind ++;

		}
	}
	return $taille_liste;
}

/**
AFFICHE LE TABLEAU DES ZONES TEXTES
*/
function lister_rep_txt() {
	// $rep,$sens passes dans l'url
	global $rep, $cat, $mess, $sens, $font, $tablecolor, $ordre, $liste_cat, $db, $MSG_947, $MSG_948, $MSG_949;
	global $MSG_1902, $MSG_1905;
	//debug
	//echo "ordre=$ordre<br>";
	// AFFICHAGE BARRE DU HAUT (REPERTOIRE COURANT)
	echo "<br><table class=\"tableau_normal\">\n";
	echo "<tr>\n";

	// PREMIERE LIGNE DU TABLEAU : Nom du fichier / Actions
	echo "<th>$MSG_948</th>\n";
	echo "<th>$MSG_1902</th>\n";
	echo "<th>$MSG_1905</th>\n";
	echo "</tr>\n";

	$sql = "SELECT num_text , nom, text FROM  ressource_txt WHERE num_themedir=$rep";
	$result = pg_query($sql);
	//echo '<tr><td colspan="3">&nbsp;</td></tr>';
	while ($row = pg_fetch_array($result)) {
		echo '<tr class="couleur2">';
		echo '<td>&nbsp;-&nbsp;'.$row["nom"].'</td>';
		echo '<td align="center">'.strlen($row["text"]).' '.$MSG_947.'</td>';
		$sql = "SELECT COUNT(*) as qte FROM ressource_gest WHERE type='t' AND num_fic=".$row["num_text"];
		$used = pg_query($sql);
		$nb = pg_fetch_result($used, 0, "qte");
		echo '<td  align="center"><a href="javascript:pop(\'zonetxt.php?cat='.$cat.'&rep='.$rep.'&arbo='.$arbo.'&num_text='.$row["num_text"].'&do=view\');"><img border="0" src="../images/view2.gif"></a> <a href="javascript:pop(\'zonetxt.php?cat='.$cat.'&rep='.$rep.'&arbo='.$arbo.'&num_text='.$row["num_text"].'&do=edit\');"><img border="0" src="../images/renommer.gif"></a>';
		echo '<a href="javascript:pop(\'zonetxt.php?cat='.$cat.'&rep='.$rep.'&arbo='.$arbo.'&num_text='.$row["num_text"].'&do=delete\');"><img border="0" src="../images/';
		if ($nb == 0)
			echo 'sup0.gif';
		else
			echo 'lock.gif';

		echo '"></a></td></tr>';

	}
	//echo "<tr><td colspan=\"3\"><hr width=\"100%\" align=\"center\"></td></tr>";
	echo '</table><br> <a class="action" href="javascript:pop(\'zonetxt.php?rep='.$rep.'&do=add\');">'.$MSG_949.'</a><br>';
}

/**
	Remplacer les caract�res sp�ciaux de fin de ligne d'un fichier
	@param string: le chemin du fichier � parser
*/
function enlever_controlM($fichier) {
	$fic = file($fichier);
	$fp = fopen($fichier, "w");
	while (list ($cle, $val) = each($fic)) {
		$val = str_replace(CHR(10), "", $val);
		$val = str_replace(CHR(13), "", $val);
		fputs($fp, "$val\n");
	}
	fclose($fp);
}

/**
	Obtenir une chaine pouvant servir de nom de fichier ou de repertoire
	� partir d'une chaine quelquonque
	@deprecated  utiliser des num�ros plutot que les noms de fichiers pars�s! (pb avec UNICODE sinon!!!) 
*/
function traite_nom_fichier($nom) {
	global $max_caracteres;
	$nom = stripslashes($nom);
	$nom = str_replace("'", "", $nom);
	$nom = str_replace("\"", "", $nom);
	$nom = str_replace("\"", "", $nom);
	$nom = str_replace("&", "", $nom);
	$nom = str_replace(",", "", $nom);
	$nom = str_replace(";", "", $nom);
	$nom = str_replace("/", "", $nom);
	$nom = str_replace("\\", "", $nom);
	$nom = str_replace("`", "", $nom);
	$nom = str_replace("<", "", $nom);
	$nom = str_replace(">", "", $nom);
	$nom = str_replace(" ", "_", $nom);
	$nom = str_replace(":", "", $nom);
	$nom = str_replace("*", "", $nom);
	$nom = str_replace("|", "", $nom);
	$nom = str_replace("?", "", $nom);
	$nom = str_replace("\x{00E9}", "", $nom);
	$nom = str_replace("", "", $nom);
	$nom = str_replace("\x{00E7}", "", $nom);
	$nom = str_replace("@", "", $nom);
	$nom = str_replace("", "", $nom);
	$nom = str_replace("\x{00EA}", "", $nom);
	$nom = str_replace("\x{00EE}", "", $nom);
	$nom = str_replace("\x{00F4}", "", $nom);
	$nom = str_replace("", "", $nom);
	$nom = str_replace("", "", $nom);
	$nom = str_replace("", "", $nom);
	$nom = str_replace("!", "", $nom);
	$nom = str_replace("\x{00A7}", "", $nom);
	$nom = str_replace("+", "", $nom);
	$nom = str_replace("^", "", $nom);
	$nom = str_replace("(", "", $nom);
	$nom = str_replace(")", "", $nom);
	$nom = str_replace("#", "", $nom);
	$nom = str_replace("=", "", $nom);
	$nom = str_replace("$", "", $nom);
	$nom = str_replace("%", "", $nom);
	$nom = substr($nom, 0, $max_caracteres);
	return $nom;
}

/**
	Retourne l'extension du fichier (exemples: "txt", "html")
	@param string: le nom du fichier
	@return string : l'extension du fichier
*/
//function get_fichier_type($fichier) {
function get_fichier_extension($fichier) {
	//echo "fichier=$fichier<br>";
	$tmp = split("\.", $fichier);
	if (count($tmp) > 1)
		return $tmp[count($tmp) - 1];
	else
		return "";
}

/**
	Retourne le nom  du fichier sans l'extenston
	@param string: le nom du fichier
	@return string : l'extension du fichier
*/
function get_fichier_name($fichier) {
	$tmp = split("\.", $fichier);
	if (count($tmp) > 1)
		unset ($tmp[count($tmp) - 1]);
	return implode($tmp);
}

/**
	Retourne le nom  complet du fichier 
	@param integer: l'identifiant du fichier
	@return string : le nom  complet du fichier (lib�ll� avec l'extension)
*/
function get_fichier_full_name($fichier) {
	$res_fichier=get_fichier($fichier);
	$row_fichier=pg_fetch_row($res_fichier);
	return $row_fichier[1];
}

/**
 * Savoir si un fichier est utilis� par un �l�ment de la plate-forme.
 * Pour les fichiers qui sont aussi des �tapes, un traitement particulier
 * est appliqu� en fonction du type de fichier, afin de ne pas consid�rer
 * comme un "lien" la pr�sence des identifiants de ces fichiers dans la table
 * �tape.
 * @param integer l'identifiant du fichier
 * @param integer la table cible de la categorie du fichier
 * @return bool true si le fichier est utilis� par un element de la plate-forme, false sinon
 */
function is_fichier_utilise($fichier, $categorie_table_cible) {
//	echo "fichier=$fichier tc=$categorie_table_cible";
	$db_fic = get_fichier($fichier);
	//si le fichier est de type scenario, c'est l'�tape scenario et non le fichier que l'on v�rifie
	$type_fichier=pg_fetch_result($db_fic, 0, 2);
//	echo "<br>\$type_fichier=$type_fichier";
	$utilise=true;
	switch($type_fichier){
		case 5:
			$utilise= fk_finder("scenario", "id", get_scenario_fichier($fichier));
			break;
		case 12:
			$utilise= fk_finder("etape_scorm", "id", get_etape_scorm_fichier($fichier));	
			break;	
		// fichier icone
		case 6:
			$utilise= fk_finder("fichier_icone","id",$fichier);
			break;
		case 15:
			$utilise= fk_finder("scenario_dynamique","id",$fichier);
			if(!$utilise){
				return is_fichier_scenario_dynamique_used($fichier);
			}else{
				return true;
			}
		default:
			//return fk_finder("fichier_$categorie_table_cible", "id", $fichier);
			$utilise= fk_finder($categorie_table_cible, "id", $fichier);
	}
	return $utilise;
}

/**
 * fonction qui teste si un repertoire est vide
 * @param string : chemin du repertoire
 * @return boolean : true si le repertoire est fide, false sinon
 */
function is_repertoire_vide($chemin) {
	$handle = @ opendir($chemin);
	$file = @ readdir($handle); // repertoire .
	$file = @ readdir($handle); // repertoire ..
	if ($file = @ readdir($handle))
		$val = false;
	else
		$val = true;
	@ closedir($handle);
	return $val;
}
/**
 *  fonction  qui efface un repertoire non vide
 *  @param  string : chemin du repertoire
 *  @return      boolean : true si le repertoire a correctement �t� �ffac�,
 * false sinon
 */
function del_repertoire($chemin) {
	$correct = 1;
	$handle = @ opendir($chemin);
	$file = @ readdir($handle); // repertoire .
	$file = @ readdir($handle); // repertoire ..
	while ($file = @ readdir($handle)) {
		if (is_dir("$chemin/$file")) {
			if (is_repertoire_vide("$chemin/$file")) {
				if (is_dir("$chemin/$file")&&!rmdir("$chemin/$file"))
					$correct = 0;
			} else
				$correct = del_repertoire("$chemin/$file");
		} else
			unlink("$chemin/$file");
	}
	if (is_dir("$chemin/$file")&&!rmdir($chemin))
		$correct = 0;
	@ closedir($handle);
	return $correct;
}

/**
 * Supprime un fichier
 * 
 * @param varchar $chemin chemin du fichier a supprimmer
 */
function del_fichier($chemin){
	
	if(file_exists($chemin)){
		return unlink($chemin);
	}
	return false;
}


/**
 * 	Obtenir le chemin absolu dans lequel est stoch� un fichier pour 
 *  pouvoir l'afficher par la suite. 
 * 	Le libell� du fichier est r�cup�r� en base � partir du numero de fichier,
 *  mais il est possible de le r�cup�r� directement � partir d'un resultat de requete en 
 *  utilisant le parametre facultatif $db_fichier.
 * 	@param integer : identifiant du fichier
 * 	@param integer or string: identifiant du theme ou libelle du theme. 
 * 	@param			integer or string: identifiant de la categorie ou libelle de la categorie
 * 	@param integer : resultat de requete contenant l'enregistrement du fichier(facultatif)
 */
function get_fichier_chemin($fichier, $theme, $categorie, $db_fichier=null){
	//echo "get_fichier_chemin($fichier, $theme, $categorie, $db_fichier)";
	global $serverfront,$langue_par_defaut,$chemin_fo;
	if(empty($db_fichier))$db_fichier=get_fichier($fichier);
	$libelle_fichier=pg_fetch_result($db_fichier, 0, 1);
	$tmp_langue=get_fo_ams_langue();
//	echo $libelle_fichier;
	$theme_dir=pg_fetch_result(get_theme($theme),0,2);
	if (VERSION_BASE > VERSION) {
//		echo "coucou $tmp_langue<br>";
		$chemin= "http://$serverfront/fo/data/contenus/$theme_dir/$categorie/$tmp_langue/$fichier.".get_fichier_extension($libelle_fichier);
//		echo $chemin;
		if(file_exists($chemin_fo."/data/contenus/$theme_dir/$categorie/$tmp_langue/$fichier.".get_fichier_extension($libelle_fichier)))
			$chemin_ok=$chemin;
		else{
			$chemin_ok= "http://$serverfront/fo/data/contenus/$theme_dir/$categorie/$langue_par_defaut/$fichier.".get_fichier_extension($libelle_fichier);
		}
		return $chemin_ok;
	}else{
		return "http://$serverfront/data/exostlc/$theme_dir/$categorie/$libelle_fichier";
	}
}

function get_fo_ams_langue(){
	global $ams_langue, $s_langue;
	if(!empty($ams_langue))$tmp_langue=$ams_langue;
	if(!empty($s_langue)&&empty($tmp_langue))$tmp_langue=$s_langue;
	return $tmp_langue;
}

/**
 * Obtenir le chemin absolu pour affichage en FO
 * @param integer : identifiant du fichier
 * @param integer or string: identifiant du theme ou libelle du theme. 
 * @param			integer or string: identifiant de la categorie ou libelle de la categorie
 * 
 */



/**
 * 	Obtenir le chemin relatif dans lequel est stoch� un fichier pour 
 *  pouvoir l'afficher par la suite. 
 * 	Le libell� du fichier est r�cup�r� en base � partir du numero de fichier,
 *  mais il est possible de le r�cup�r� directement � partir d'un resultat de requete en 
 *  utilisant le parametre facultatif $db_fichier.
 * 	@param integer : identifiant du fichier
 * 	@param integer or string: identifiant du theme ou libelle du theme. 
 * 	@param			integer or string: identifiant de la categorie ou libelle de la categorie
 * 	@param integer : resultat de requete contenant l'enregistrement du fichier(facultatif)
 */
function get_fichier_chemin_relatif($fichier, $theme, $categorie, $db_fichier=null,$langue=""){
	global $serverfront,$s_langue,$langue_par_defaut,$chemin_fo;
	if(empty($langue))
		$langue=$s_langue;
	if(empty($db_fichier))$db_fichier=get_fichier($fichier);
	$libelle_fichier=pg_fetch_result($db_fichier, 0, 1);
//	if(TYPE_OFFICE=='front'){
//		$connecte=pg_fetch_result($db_fichier, 0, 3);
//		if(!sql2Bool($connecte))
//			die("Erreur get_fichier_chemin_relatif(): Le fichier est d�connect�");
//			return false;
//	}
	//echo $libelle_fichier;
	$theme_dir=pg_fetch_result(get_theme($theme),0,2);
	if (VERSION_BASE > VERSION) {
		$fic_type=get_fichier_extension($libelle_fichier);
		$langues_fic=getFichierAms("$chemin_fo/data/contenus/$theme_dir/$categorie", "$fichier.".$fic_type);
		if(in_array($s_langue,$langues_fic)){
			$chemin="/data/contenus/$theme_dir/$categorie/$s_langue/$fichier.".$fic_type;
		}elseif(count($langues_fic)==1){
			$chemin="/data/contenus/$theme_dir/$categorie/$langues_fic[0]/$fichier.".$fic_type;
		}elseif(in_array($langue_par_defaut,$langues_fic)){
			$chemin="/data/contenus/$theme_dir/$categorie/$langue_par_defaut/$fichier.".$fic_type;
		}
		return $chemin;
	}else{
		return "/data/exostlc/$theme_dir/$categorie/$libelle_fichier";
	}
}

/**
 * Obtenir le chemin relatif pour affichage d'un fichier en FO
 * @param integer : identifiant du fichier
 * @param integer or string: identifiant du theme ou libelle du theme. 
 * @param			integer or string: identifiant de la categorie ou libelle de la categorie
 * @return string : le chemin dans la langue de la plateforme ou dans la langue par defaut ou le 1er trouv�
 */
 function get_fo_fichier_chemin_relatif($fichier, $theme, $categorie, $db_fichier=null,$langue=""){
 	global $chemin_fo,$langue_par_defaut,$s_langue;
 	// dans la langue de la plateforme
 	$chemin_fichier_relatif=get_fichier_chemin_relatif($fichier,$theme,$categorie,$db_fichier,$s_langue);
 	$fichier_chemin_absolu=$chemin_fo."/".$chemin_fichier_relatif;
 	if(file_exists($fichier_chemin_absolu))
 		return $chemin_fichier_relatif;
 	// dans la langue par defaut
 	$chemin_fichier_relatif=get_fichier_chemin_relatif($fichier,$theme,$categorie,$db_fichier,$langue_par_defaut);
 	$fichier_chemin_absolu=$chemin_fo."/".$chemin_fichier_relatif;
 	if(file_exists($fichier_chemin_absolu))
 		return $chemin_fichier_relatif;
 	// dans une autre langue ?
 	// recup des langues de la plateforme
 	$res_langue=get_plateforme_langues();
 	$nb_langue=pg_num_rows($res_langue);
 	// boucle sur les langues
 	for($i=0;$i<$nb_langue;$i++){
 		$row_langue=pg_fetch_row($res_langue,$i);
 		$chemin_fichier_relatif=get_fichier_chemin_relatif($fichier,$theme,$categorie,$db_fichier,$row_langue[0]);
 		$chemin_fichier_absolu=$chemin_fo."/".$chemin_fichier_relatif;
 		if(file_exists($fichier_chemin_absolu))
 			return $chemin_fichier_relatif;	
 	}
 	return "";
 }


/**
 * Retourne le type de fichier � partir du code (lettre).
 * Le code peut etre t ou f.
 * La valeur retourner depend du shema de la base.
 * Renvoie le code si on est sur l'ancienne base, le numero si on est sur la nouvelle.
 * @param varchar: le code du type
 * @return interger : l'entier correspondant au code ou  le code lui meme.
 */
function get_fichier_type_old_new($old_type) {
	if (VERSION_BASE > VERSION) {
		switch ($old_type) {
			case "t" :
				return 1;
			case "f" :
				return 7;
			default :
				return $old_type;
		}
	} else {
		return $old_type;
	}
}

/**
 * Retourne le type d'evaluation � partir du numero (nouvelle base).
 * Le code retourn� peut etre t ou f.
 * La valeur retourner depend du shema de la base.
 * Renvoie le numero si on est sur la nouvelle base, le code si on est sur l'ancienne.
 * @param integer: le code du type
 * @return varchar : le code correspondant a l'entier ou  l'entier lui meme.
 */
function get_fichier_type_new_old($new_type) {
	if (VERSION_BASE > VERSION) {
		switch ($new_type) {
			case 1 :
				return "t";
			case 7 :
				return "f";
			default :
				return $new_type;
		}
	} else {
		return $new_type;
	}
}

/**
 * Renvoi le Charset tel qu'il est d�clar� dans un fichier html
 * @param string: nom du fichier a annalyser
 * @return le charset trouv� ou null si non trouv�.
 */
function get_fichier_charset($fichier){
//liste des charset du w3c
$charset_list=array("utf-8","iso-8859-15","windows-1251","iso-8859-6","x-mac-arabic","windows-1256","iso-8859-4","windows-1257","iso-8859-2","x-mac-ce","windows-1250","euc-cn","gb2312","hz-gb-2312","x-mac-chinesesimp","cp-936","big5","x-mac-chinesetrad","cp-950","cp-932","euc-tw","iso-8859-5","koi8-r","koi8","x-mac-cyrillic","iso-8859-7","x-mac-greek","windows-1253","iso-8859-8","iso-8859-8-i","x-mac-hebrew","windows-1255","x-mac-icelandic","euc-jp","iso-2022-jp","x-mac-japanese","shift_jis","ks_c_5601-1987","euc-kr","iso-2022-kr","x-mac-korean","iso-8859-3","windows-874","iso-8859-9","x-mac-turkish","windows-1254","utf-7","iso-10646-ucs-2","us-ascii","windows-1258","iso-8859-1","x-mac-roman","macintosh","windows-1252","isiri-3342");
$charset = null;
if( ! $read = @fopen($fichier,'rb')){
		$result= "Impossible d'ouvrir le fichier";
	} else {
		if(! $contenu = @fread($read, filesize($fichier))) {
			$result = "Impossible de lire le fichier";
		} else {
			//recherche de chaque charset dans le fichier passe en parametre
			foreach($charset_list as $val){
				if(ereg($val,$contenu)){$charset = $val;}
			}
		}
	}
	return $charset;
}

/**
 * T�l�charger un fichier.
 * 
 * Attention, aucun affichage ne doit avoir lieu dans le script qui appelle cette fonction.
 * En effet, l'affichage serai alors ajout� au d�but du fichier ainsi t�l�charg�.
 * @param integer $fichier_src : identifiant du fichier � t�l�charger
 * @param string $fichier_dest : libell� du fichier t�l�charg� pour l'utilisateur
 * @param string $chemin_url : URL du fichier � t�l�charger
 * @param string $chemin_fichier_relatif : chemin relatif du fichier sur le serveur
 * 
 */
function downloadFichier($fichier_src, $fichier_dest, $chemin_url,$chemin_fichier_relatif){

	if(empty($fichier_src)||empty($fichier_dest)||empty($chemin_url)||empty($chemin_fichier_relatif)){
		die("Erreur downloadFichier($fichier_src, $fichier_dest, $chemin_url,$chemin_fichier_relatif): parametres incorrects.");
	}
	//recup du nom du fichier sur le disque du serveur
	$fichier_disque_name=$fichier_src.".".get_fichier_extension($fichier_dest);
	
	//recup des chemins complets 
	$fichier_disque_chemin=$chemin_fichier_relatif.$fichier_disque_name;
	$fichier_disque_url=$chemin_url.$fichier_disque_name;
	
//	echo "\$fichier_disque_chemin=$fichier_disque_chemin<br>";
//	echo "\$fichier_disque_url=$fichier_disque_url<br>";
	
	if(!file_exists($fichier_disque_chemin)){
		die("Erreur downloadFichier($fichier_src, $fichier_dest, $chemin_url,$chemin_fichier_relatif): le fichier n'existe pas.<br>fichier:$fichier_disque_chemin<br>");
	}
	//calcul de la taille du fichier
	$taille=filesize($fichier_disque_chemin);
	if($taille<=0){
		die("Erreur downloadFichier($fichier_src, $fichier_dest, $chemin_url,$chemin_fichier_relatif): la taille du fichier est incorrecte.");
	}
	// envoie des headers pour le telechargement
	header("Content-Type: application/force-download; name=\"$fichier_name\"");
	header("Content-Transfer-Encoding: binary");
	header("Content-Length: $taille");
	header("Content-Disposition: attachment; filename=\"$fichier_dest\"");
	header("Expires: 0");
	header("Cache-Control: no-cache, must-revalidate");
	header("Pragma: no-cache");
	readfile($fichier_disque_url);
	exit;
}

/**
 * Uploader un fichier.
 * 
 * @param integer $fichier_src Chemin complet (sur le disque du client) du fichier � uploader
 * @param string $nom_fichier_src
 * @param integer $taille_fichier_src  
 * @param integer $nom_fichier_dst
 * @param string $destination Chemin complet (sur le disque du serveur) du repertoire ou l'on stocke le fichier � uploader
 * 
 * @return string: message qui indique l'erreur si l'UPLOAD � �chou�, null sinon.
 */
function uploadFichier($fichier_src, $nom_fichier_src, $taille_fichier_src, $nom_fichier_dst, $destination){
	
	messageDebug("uploadFichier($fichier_src, $nom_fichier_src, $taille_fichier_src, $nom_fichier_dst, $destination)");
	$message="";
	$err=false;
    if(!is_dir($destination)){ //si le repertoire Reception n'existe pas au sein du repertoire th�me, on le cr�e
    
           $message.=ERROR_133."<br>"; 
    }
	
    if(empty($fichier_src)|| empty($nom_fichier_src)||empty($nom_fichier_dst)){
    	if(empty($nom_fichier_dst)){
    		$message.=ERROR_134."<br>";
    		$err = true;
    	}else{
        	$message.=WARN_79."<br>";
        	$err = true;
    	}
    }
    else{
    	//verif extentions
		$extension_src = get_fichier_extension($nom_fichier_src);
		//un fichier doir avoir une extension
		if (empty ($extension_src)) {
			$err = true;
			$message .= ERROR_135."<br>";
		}
		
		$extension_dst = get_fichier_extension($nom_fichier_dst);
		//un fichier doir avoir une extension
		if (empty ($extension_dst)) {
			$err = true;
			$message .= ERROR_136."<br>";
		}
		
	   	//verif taille nulle
		if ($taille_fichier_src <=0) {
			$err = true;
			$message.=WARN_80."<br>";
		} else {
			$taille_mo = (int) $taille_fichier_src / 1024 /1024 ;
			if($taille_mo > MAX_UPLOAD_SIZE){
				$err = true;
				$message .= ERROR_137." (".ERROR_138." : $taille_mo ".MSG_1358.",".ERROR_139.": ".(((int)MAX_UPLOAD_SIZE)*1024*1024)." ".MSG_1358.")<br>";
			}
		}
        if($err==false){

            //if (!(file_exists("$destination/$nom_fichier_dst"))){
                if (!(copy($fichier_src, "$destination/$nom_fichier_dst"))){
                    $message.=WARN_81."<br>";
                    $err = true;
                }
//            }
//            else{
//                $message.=$WARN_82;
//            }
        }
    }
//    exit;
    // echo $message;
	//retourne un message qui indique l'erreur si l'UPLOAD � �chou�, null sinon.
	return $message;
}

/**
	Obtenir le libelle d'un fichier
	@param string : nom du fichier sur le disque
	@return string : nom du fichier
*/
function get_fichier_libelle($fichier){
	if (VERSION_BASE > VERSION) {
		$fichier_nom=get_fichier_name($fichier);
		$res=get_fichier($fichier_nom);
		return pg_fetch_result($res,0,1);
	}
	else
		return $fichier;
}

function get_fichier_icone_chemin_relatif($fichier,$langue=""){
	global $s_langue;
	if(empty($langue))
		$langue=$s_langue;
	if($fichier){
		$resfic=get_fichier($fichier);
		$nomfic=pg_fetch_result($resfic,0,1);
		$tab=explode(".",$nomfic);
		$ext= $tab[count($tab)-1];
		
		$chemin = UPLOAD_RESSOURCE_ICONE_DIR."$langue/$fichier.$ext";
		return $chemin;
	}
}

/**
 * Retourne le chemin du fichier ic�ne en fonction de la langue de contenu
 * @param integer : identifiant du fichier
 * @return string : le chemin du fichier icone dans la langue de la plateforme si le fichier existe,sinon dans la langue par defaut de la plateforme si le fichier existe,sinon le 1er trouv� dans le autres langue
 */
 function get_fo_fichier_icone_chemin_relatif($fichier){
 	global $chemin_fo,$langue_par_defaut,$s_langue;
 	// Dans la langue de la plateforme ?
 	$chemin_fichier_relatif=get_fichier_icone_chemin_relatif($fichier,$s_langue);
 	$fichier_chemin_absolu=$chemin_fo."/".$chemin_fichier_relatif;
 	//echo "chemin_absolu=$fichier_chemin_absolu<br>";
 	if(file_exists($fichier_chemin_absolu)){
 	//if(file_exists($chemin_fichier_relatif)){
 		//echo "coucou<br>";
 		return $chemin_fichier_relatif;
 	}
 	//else
 		//echo "toto";
 	// Dans la langue par defaut ?
 	$chemin_fichier_relatif=get_fichier_icone_chemin_relatif($fichier,$langue_par_defaut);
 	$fichier_chemin_absolu=$chemin_fo."/".$chemin_fichier_relatif;
 	if(file_exists($fichier_chemin_absolu))
 		return $chemin_fichier_relatif;
 	// Dans une autre langue ?
 	// recup des langues de la plateforme
 	$res_langue=get_plateforme_langues();
 	$nb_langue=pg_num_rows($res_langue);
 	// boucle sur les langues
 	
 	for($i=0;$i<$nb_langue;$i++){
 		$row_langue=pg_fetch_row($res_langue,$i);
 		$chemin_fichier_relatif=get_fichier_icone_chemin_relatif($fichier,$row_langue[0]);
 		$fichier_chemin_absolu=$chemin_fo."/".$chemin_fichier_relatif;
 		if(file_exists($fichier_chemin_absolu))
 			return $chemin_fichier_relatif;
 	}
 	
 	return "";
 	
 	
 }

function is_fichier_type_mime_type_valid($fichier_libelle, $mime_type){
	
	
		$exploded_fichier=explode('.',$fichier_libelle);
		$extension_fichier=$exploded_fichier[count($exploded_fichier)-1];
//		echo "$fichier_libelle / $extension_fichier / $mime_type";
		switch ($mime_type) {
			case 'application/x-shockwave-flash':
				if(strtolower($extension_fichier)=='swf')return true;
				else return false;
			case 'video/x-flv':
				if(strtolower($extension_fichier)=='flv')return true;
				else return false;
			case 'image/*':
				switch (strtolower($extension_fichier)) {
					case 'jpg':
					case 'jpeg':
					case 'png':
					case 'gif':
						return true;
					default:
						return false;
				}
		
			default:
				return false;
		}
}

function getFichierAms($base_repertoire_sans_ams, $nomfichier_sur_disque){
//	global $langue_par_defaut,$ams_langue;
//	//on test si le fichier existe pour la langue de contenu
//	if(file_exists($base_repertoire_sans_ams."/".$ams_langue."/".$nomfichier_sur_disque)){
//		return $ams_langue;	
//	}
//	//le fichier n'existe pas dans la langue de contenu, on cherche quelle est la langue dans lequel il est disponible
//	else{
//		
//		//on test s'il existe dans la langue par d�fautl de la plateforme'
//		if(file_exists($base_repertoire_sans_ams."/".$langue_par_defaut."/".$nomfichier_sur_disque)){
//			return $langue_par_defaut;	
//		}
//		//on cherche pour les autres langues
//		else{
			$avalaible_langues=get_langues_disponibles();
			$tab_lang=array();
			foreach($avalaible_langues as $indice => $langue_properties){
				
//				echo $base_repertoire_sans_ams."/".$langue_properties[0]."/".$nomfichier_sur_disque."<br>";
				if(file_exists($base_repertoire_sans_ams."/".$langue_properties[0]."/".$nomfichier_sur_disque)){
					$tab_lang[]=$langue_properties[0];
				}
			}
			if(!count($tab_lang)>0){
				
				//TODO remplacer echo par un die
				echo("erreur fichier corrompu: la langue du fichier est introuvable.");
			}else{
				return $tab_lang;
			}
//		}
//	}
}

///**
// * fonction creant le tableau contenant les repertoires et fichiers
// * modifi� a partir de:
// * http://www.phpcs.com/codes/COPIER-REPERTOIRE-TOUT-QU-CONTIENT_33553.aspx
// */
//function copier_repertoire_create_tab ($dir) { 
//	 $dir = rtrim ($dir, '/'); // on vire un eventuel slash mis par l'utilisateur de la fonction a droite du repertoire
//	 if (is_dir ($dir)) // si c'est un repertoire
//	 	$dh = opendir ($dir); // on l'ouvre
//	 else {
//		 echo $dir, ' n\'est pas un repertoire valide'; // sinon on sort! Appel de fonction non valide
//	 	exit;
//	 }
//	 while (($file = readdir ($dh)) !== false ) { //boucle pour parcourir le repertoire
//		 if ($file !== '.' && $file !== '..') { // no comment
//			 $path =$dir.'/'.$file; // construction d'un joli chemin...
//			 if (is_dir ($path)) { //si on tombe sur un sous-repertoire
//				$tableau[$dir]['dir'][] = $path;
//				$tabTmp = create_tab ($path); // appel recursif pour lire a l'interieur de ce sous-repertoire
//				if (is_array ($tabTmp) && is_array ($tableau))
//					$tableau = array_merge ($tableau, $tabTmp);
//			 }
//			 else
//				$tableau[$dir]['file'][] = $path;
//		 }
//	 }
//	 closedir ($dh); // on ferme le repertoire courant
//	 if (isset ($tableau)) {
//	 	return $tableau;
//	 }
//}
//
///**
// * fonction pour copier repertoire : on cree un repertoire de meme nom, puis on va chercher les fichiers, et on les copie. Si il y a des sous repertoires, appel recursif.
// * modifi� a partir de:
// * http://www.phpcs.com/codes/COPIER-REPERTOIRE-TOUT-QU-CONTIENT_33553.aspx
// */
//function copier_repertoire ($destination, $reps, $tableau_dir = array ()) { 
//	 if (empty ($tableau_dir)) {
////		 echo 'Entr�e';
//		 $tableau_dir = copier_repertoire_create_tab ($reps);
//	 }
//	 if (!is_array ($reps)) {
//	 	$reps = array ($reps);
//	 }
//	 print_rr($reps);
//	 print_rr($tableau_dir);
//	 foreach ($reps as $rep) {
//		 if (!is_dir ($destination.'/'.basename ($rep))) {
//			 mkdir ($destination.'/'.basename ($rep));
//			 if (!empty ($tableau_dir[$rep]['file']) && isset($tableau_dir[$rep]['file']) && is_array ($tableau_dir[$rep]['file'])) {
//				foreach ($tableau_dir[$rep]['file'] as $fichier) {
//				 	copy ($fichier, $destination.'/'.basename ($rep).'/'.basename ($fichier));
//			 	}
//			 }
//			 if (!empty ($tableau_dir[$rep]['dir']) && isset ($tableau_dir[$rep]['dir']) && is_array ($tableau_dir[$rep]['dir'])) {
//			 	copier_repertoire ($destination.'/'.basename ($rep), $tableau_dir[$rep]['dir'], $tableau_dir);
//			 }
//		 }
//	 }
//} 

function deplace_repertoire($source,$destination){
    if (!is_dir($destination)){
        mkdir($destination,0777);
    }
    $dossier=opendir($source);

    while ($fichier = readdir($dossier)) {
            $l = array('.', '..');    
            if (!in_array( $fichier, $l)){
                    if (is_dir($source."/".$fichier)){
                        deplace_dir($source."/".$fichier, $destination."/".$fichier);
                    }
                    else{
                        copy ($source."/".$fichier, $destination."/".$fichier);
                        unlink($source."/".$fichier);    
                    }
            }
    }
    @closedir($dossier);
    rmdir($source);
}

function get_fichier_disk_name($fichier){
	//On formate le nom du fichier ici...
     $fichier = strtr($fichier, 
          '����������������������������������������������������', 
          'AAAAAACEEEEIIIIOOOOOUUUUYaaaaaaceeeeiiiioooooouuuuyy');
     $fichier = preg_replace('/([^.a-z0-9]+)/i', '-', $fichier);
     return $fichier;
}
?>