<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *
 * @package fichier
 * @modulegroup plpgsql
 * @module plpgsql_fichier
 */

/**
 *   V�rifie qu'un nom de fichier est unique pour un theme donn� (OLD)
 *   @param string $libelle le nom � v�rifier
 *   @param integer $theme le numero du theme
 *   @param string $table le nom de la table
 *   @return integre : N� du fichier si existe, 0 sinon
 */
function check_fichier_nom_fichier_old($libelle, $theme, $table) {
	$sql = "select * from $table where nom_fic='$libelle' and num_themedir=$theme";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	if (pg_num_rows($res) == 0)
		return 0;
	else {
		$row = pg_fetch_row($res, 0);
		return $row[0];
	}
}

/**
 *   V�rifie qu'un nom de fichier est unique pour un theme donn� (OLD)
 *   @param string $libelle le nom � v�rifier
 *   @param integer $theme le numero du theme
 *   @param string $table le nom de la table
 *   @return integre : N� du fichier si existe, 0 sinon
 */
function check_fichier_nom_fichier($libelle, $theme, $table) {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = check_fichier_nom_fichier_old($libelle, $theme, $table);
	return ($res);
}

/**
 *   Obtenir les infos d'un fichier ressource � partir de son numero (OLD)
 *	@deprecated utiliser get_fichier($fichier, $type)
 *   @param integer $fichier numero du fichier
 *   @param string : le nom de la table
 */
function get_fichier_infos_old($fichier, $table) {
	$sql = "select * from $table where num_fic=$fichier;";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	$row = pg_fetch_row($res, 0);
	return $row;
}
/**
 *   Obtenir les infos d'un fichier ressource � partir de son numero
 *	 @deprecated utiliser get_fichier($fichier, $type)
 *   @param integer $fichier numero du fichier
 *   @param string : le nom de la table
 */
function get_fichier_infos($fichier, $table) {
	if (VERSION_BASE > VERSION) {
		print ("get_fichier_infos:A IMPLEMENTER");
	} else
		$res = get_fichier_infos_old($fichier, $table);
	return ($res);
}

/**
 *   Obtenir les infos d'un fichier, avec les metadatas a partir de son identifiant
 *   @param integer $fichier numero du fichier
 *   @param string : le nom de la table
 */
function get_fichier_metadata($fichier) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_fichier_metadata($fichier) AS ( id int4, libelle varchar, type int4, mots_cles text, individu int4,connecte bool)";
//		echo "$req<br>";
		$res= pg_query($req);
	}
	else
		print ("get_fichier_metadata: A IMPLEMENTER");	
	return ($res);
}

/**
 *   Obtenir les infos d'un fichier ressource � partir de son numero
 *   @param integer $fichier numero du fichier
 *   @return integer : le resultat de la requete ( id int4, libelle varchar, \"type\" int4, connecte bool)
 */
function get_fichier($fichier) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_fichier($fichier) AS ( id int4, libelle varchar, type int4, connecte bool)";
//		echo "$req<br>";
		return pg_query($req);
	
	} else
		print("La fonction get_fichier($fichier) n'existe pas pour la version ".VERSION);
}

/**
 *   Obtenir les infos d'un fichier de media d'evaluation � partir de son numero (OLD)
 *   @param integer $fichier numero du fichier
 *   @return integer : le resultat de la requete
 */
function get_fichier_medias_evaluations_old($fichier) {
	$sql = "select num_fic, nom_fic, 3, 'TRUE' from ficmediaqcm where num_fic=$fichier;";
	//echo "$sql<br>";
	return pg_query($sql);
}

/**
 *   Obtenir les infos d'un fichier de media d'evaluation � partir de son numero
 *   @param integer $fichier numero du fichier
 *   @return integer : le resultat de la requete ( id int4, libelle varchar, \"type\" int4, connecte bool)
 */
function get_fichier_medias_evaluations($fichier) {
	if (VERSION_BASE > VERSION) {
		return get_fichier($fichier);
	} else{
		$res = get_fichier_medias_evaluations_old($fichier);
	}
	return ($res);
}

/**
 *   Obtenir les infos d'un fichier texte � partir de son numero
 *   @param integer $fichier numero du fichier
 *   @return integer : le resultat de la requete
 */
function get_fichier_texte($fichier) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_fichier_texte($fichier) AS ( id int4, libelle varchar, \"type\" int4, connecte bool, titre varchar, lien varchar, description varchar, mise_en_forme text, date_modification text)";
		//echo "$req<br>";
		$res = pg_query($req);
	} else
		print("La fonction get_fichier_texte($fichier) n'existe pas pour la version ".VERSION);
	return ($res);
}

/**
 *   Enregistrer un nouveau fichier ressource (OLD)
 *
 *   Effectue l'enregistrement si le nom n'existe d�j� pour le m�me theme
 *
 *   @param string $libelle Le nom du fichier
 *   @param integer $theme Le num�ro du th�me
 *   @param string $table le nom de la table
 *   @return integer : Le num�ro du nouveau fichier, 0 si erreur
 */
function set_fichier_old($libelle, $theme, $table) {
	$existe_deja = check_fichier_nom_fichier($libelle, $theme, $table);
	if (!$existe_deja) {
		$sql = "insert into $table(nom_fic,num_themedir) values('$libelle','$theme')";
		$ins = pg_query($sql);
		$oid = pg_getlastoid($ins);
		$res = pg_query("select num_fic from $table where oid=$oid;");
		$numfic = pg_result($res, 0, 0);
		return $numfic;
	} else
		return 0;
}

/**
 *   Enregistrer un nouveau fichier ressource
 *
 *   Effectue l'enregistrement si le nom n'existe d�j� pour le m�me theme
 *
 *   @param string $libelle Le nom du fichier
 *   @param integer $theme Le num�ro du th�me
 *   @param string $table le nom de la table
 *   @return integer : Le num�ro du nouveau fichier, 0 si erreur
 */
function set_fichier($libelle, $theme, $table) {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$numfic = set_fichier_old($libelle, $theme, $table);
	return ($numfic);
}

/**
 * Met � jour les donn�es d'un fichier.
 * Le lib�ll�, le type et la connexion du Fichier dont l'identifiant est sp�cifi� sont mis � jour.
 * @param integer $id identifiant du Fichier � mettre � jour
 * @param string $libelle Nouveau lib�ll� du Fichier 
 * @param integer $type Nouveau type du Fichier
 * @param string $connecte  Nouvel �tat de connection du Fichier ('TRUE' ou 'FALSE')
 * 
 * @return char  't' ou 'f' selon que la mise � jour  ai �t� correctement effectu�e ou non 
 */
function maj_fichier($id, $libelle, $type, $connecte) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_maj_fichier($id, '$libelle', $type, $connecte) ";
		//echo $req."<br>";
		$res = pg_query($req);
	} else
		print ("La fonction maj_fichier($id, $libelle, $type, $connecte) n'existe pas pour la version ".VERSION);
	return ($res);

}

/**
 * Met � jour les donn�ss d'un fichier texte.
 * @param integer $id identifiant du Fichier Texte � mettre � jour
 * @param string $libelle Nouveau lib�ll� du Fichier Texte
 * @param string $titre Nouveau titre du Fichier Texte
 * @param string $lien Nouveau lien du Fichier Texte
 * @param string $description Nouvelle description du Fichier Texte
 * @param string $mise_en_forme Nouvelle mise en forme du Fichier Texte
 * @param string $connecte  Nouvel �tat de connection du Fichier Texte('TRUE' ou 'FALSE')
 * 
 * @return char  't' ou 'f' selon que la mise � jour  ai �t� correctement effectu�e ou non 
 */
function maj_fichier_texte($id, $libelle, $titre, $lien, $description, $mise_en_forme, $connecte) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_maj_fichier_texte($id, '$libelle', '$titre', '$lien', '$description', '$mise_en_forme', $connecte) ";
		//echo $req."<br>";
		$res = pg_query($req);
	} else
		print ("La fonction maj_fichier_texte($id, $libelle, $titre, $lien, $description, $mise_en_forme, $connecte) n'existe pas pour la version ".VERSION);
	return ($res);

}

/**
	Met � jour le parametre de connection d'un ensemble de fichier.
	@param array $ids un tableau de numeros de fichiers. (peut etre un tableau multidimension du moment que la premiere colonne du tableau est un numero de fichier)
	@param boolean $bool true connecte les fichiers, false les d�connectent
*/
function maj_fichiers_connection($ids, $bool) {
	if (VERSION_BASE > VERSION) {
		
		//formatage des parametres
		if($bool)$sql_bool="TRUE";
		else $sql_bool="FALSE";
		
		$nb_ids=count($ids);
		$sql_ids="_int4 '{";
		for($i=0;$i<$nb_ids-1;$i++){
				$sql_ids.=$ids[$i].",";	
		}
		$sql_ids.=$ids[$nb_ids-1]."}'";
		
		$req = "select * from contraintes.af_maj_fichiers_connection($sql_ids, $sql_bool) ";
		//echo $req;
		$res = pg_query($req);
	} else
		print ("La fonction maj_fichiers_connection($sql_ids, $sql_bool) n'existe pas pour la version ".VERSION);
	return pg_result($res,0,0);

}

/**
 *   Obtenir l'allias d'un fichier (OLD)
 *
 *   @param integer $theme le numero du theme
 *   @param string $nomfichier le nom du fichier
 *   @param char $type le type de fichier (ex S=scenario)
 *   @return integer : le resultat de la requete
 */
function get_fichier_allias_old($theme, $nomfichier, $type) {
	$sql = "select allias from allias_fichier where libelle='$nomfichier' and type='$type' and theme='$theme';";
	$res = pg_query($sql);
	return $res;
}

/**
 *   Obtenir l'allias d'un fichier
 *
 *   @param integer $theme le numero du theme
 *   @param string $nomfichier le nom du fichier
 *   @param char $type le type de fichier (ex S=scenario)
 *   @return integer : le resultat de la requete
 */
function get_fichier_allias($theme, $nomfichier, $type) {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_fichier_allias_old($theme, $nomfichier, $type);
	return $res;
}

/**
 *   Obtenir les infos d'un fichier exotlc � partir de son numero (OLD)
 *
 *   @param integer $fichier numero du fichier
 *   @return integer :  le resultat de la requete
 */
function get_fichier_exotlc_infos_old($fichier) {
	$sql = "select * from fictlc where num_fic=$fichier;";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
 *   Obtenir les infos d'un fichier exotlc � partir de son numero
 *
 *   @param integer $fichier numero du fichier
 *   @return integer Le resultat de la requete
 */
function get_fichier_exotlc_infos($fichier) {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_fichier_exotlc_infos_old($fichier);
	return ($res);
}

/**
 * Obtenir les infos d'un fichier rendu (exotlc) pour un individu (OLD)
 *
 * @param integer $formation le numero de la formation
 * @param integer $individu le numero d'individu
 * @param integer $exo le numero de l'exercice
 * @return integer Le resultat de la requete
*/
function get_fichier_rendu_infos_old($formation, $individu, $exo) {
	$sql = "select * from reception_exostlc where num_exo=$exo and num_stag=$individu and num_cal=$formation";
	return (pg_query($sql));
}
/**
 *    Obtenir les infos d'un fichier rendu (exotlc) pour un individu
 *
 *   @param integer $formation le numero de la formation
 *   @param integer $individu le numero d'individu
 *   @param integer $exo le numero de l'exercice
 *   @return integer :  le resultat de la requete
 */
function get_fichier_rendu_infos($formation, $individu, $exo) {
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = get_fichier_rendu_infos_old($formation, $individu, $exo);
	return ($res);
}


/**
 *	V�rifie si un fichier photo est utilis� (OLD)
 *
 * 	@param string $nom_fichier le nom du fichier
 * 	@return bool : true = utilis� sinon false
 */
function check_fichier_photo_utilise_old($nom_fichier){
	$sql="select * from utilisateurs where fic_photo='$nom_fichier'";
 	$res=pg_query($sql);

 	if(pg_num_rows($res) == 0)
		return false;
	else
		return true;
}

/**
 *	V�rifie si un fichier photo est utilis�
 *
 * 	@param string $nom_fichier le nom du fichier
 * 	@return bool : true = utilis� sinon false
 */
function check_fichier_photo_utilise($nom_fichier){
	if (VERSION_BASE > VERSION) {
		print ("A IMPLEMENTER");
	} else
		$res = check_fichier_photo_utilise_old($nom_fichier);
	return ($res);
}

/**
 *   Obtenir les themes d'un fichier de media d'evaluation � partir de son numero (OLD)
 *   @param integer $fichier numero du fichier
 *   @return integer Le resultat de la requete  (id int4, libelle varchar)
 */
function get_fichier_medias_evaluations_theme_old($fichier) {
	$sql = "select T.num_themedir, T.nom_theme from ficmediaqcm F,themedir T where F.num_fic=$fichier AND T.num_themedir=F.num_themedir;";
	//echo "$sql<br>";
	return pg_query($sql);
}

/**
 *   Obtenir les themes d'un fichier de media d'evaluation � partir de son numero
 *   @param integer $fichier numero du fichier
 *   @return integer Le resultat de la requete  (id int4, libelle varchar)
 */
function get_fichier_medias_evaluations_theme($fichier) {
	if (VERSION_BASE > VERSION) {
		return get_categorie_element_themes(4, $fichier);
	} else{
		$res = get_fichier_medias_evaluations_theme_old($fichier);
	}
	return ($res);
}

/**
 * Obtenir les themes associ�s � un fichier de ressource de type fichier (OLD)
 *  
 * @param integer $ressource le numero de la ressource
 * @param char $type le type de la ressource (pour la OLD)
 * 
 * @return integer : (id int4, libelle varchar)
 */
function get_fichier_ressource_fichier_themes_old($ressource,$type){
    $sql="select num_themedir, nom_theme from themedir where num_themedir in
                (select num_themedir from ressource_fic where num_fic in
                (select num_fic from ressource_gest where num_gest_res=$ressource))";
    $res=pg_query($sql);
    return $res;
}


/**
 * Obtenir les themes associ�s � un fichier de ressource  de type fichier
 *  
 * @param integer $ressource le numero de la ressource
 * @param char $type le type de la ressource (pour la OLD)
 * @return integer : (id int4, libelle varchar)
 */
function get_fichier_ressource_fichier_themes($ressource,$type=""){
    if(VERSION_BASE>VERSION){
        return get_categorie_element_themes(7,$ressource);
    }
    else
        $res=get_fichier_ressource_fichier_themes_old($ressource,$type);
    return ($res);
}

/**
 * Obtenir les themes associ�s � un fichier de ressource  de type fichier
 *  
 * @param integer $ressource le numero de la ressource
 * @param char $type le type de la ressource (pour la OLD)
 * @return integer : (id int4, libelle varchar)
 */
function get_fichier_scenario_themes($ressource,$type=""){
    if(VERSION_BASE>VERSION){
        return get_categorie_element_themes(1,$ressource);
    }
    else
        echo"erreur";
}




/**
 *   Obtenir les themes associ�s � un fichier de ressource de type texte (OLD)
 *  
 *   @param integer $ressource le numero de la ressource
 *   @return integer : (id int4, libelle varchar)
 */
function get_fichier_ressource_texte_themes_old($ressource){
    $sql="select num_themedir, nom_theme from themedir where num_themedir in
                (select num_themedir from ressource_txt where num_text in
                (select num_fic from ressource_gest where num_gest_res=$ressource))";
    $res=pg_query($sql);
    return $res;
}


/**
 *  Obtenir les themes associ�s � un fichier de ressource  de type texte
 *  
 *   @param integer $ressource le numero de la ressource
 *   @return integer : (id int4, libelle varchar)
 */
function get_fichier_ressource_texte_themes($ressource){
    if(VERSION_BASE>VERSION){
        return get_categorie_element_themes(26,$ressource);
    }
    else
        $res=get_fichier_ressource_texte_themes_old($ressource);
    return ($res);
}

/**
 *  Obtenir les themes associ�s � un fichier de ressource  de type scenario dynamique
 *  
 *   @param integer $ressource le numero de la ressource
 *   @return integer : (id int4, libelle varchar)
 */
function get_fichier_scenario_dynamique_themes($ressource){
    if(VERSION_BASE>VERSION){
        return get_categorie_element_themes(59,$ressource);
    }
    else
        $res=get_fichier_ressource_texte_themes_old($ressource);
    return ($res);
}

/**
 * Obtenir les themes associ�s � un fichier de ressource de type glossaire
 * @param integer $ressource le numero de la ressource
 * @return integer : (id int4, libelle varchar)
 */
 function get_fichier_glossaire_themes($ressource){
 	return get_categorie_element_themes(66,$ressource);		
 }

/**
 *  Obtenir les themes associ�s � un fichier de ressource  
 *  
 *   @param integer $ressource le numero de la ressource
 * 	@param integer $type le type de la ressource 7 ou 1
 *   @return integer : (id int4, libelle varchar)
 */
function get_fichier_ressource_themes($ressource,$type){
    if($type==7){
        return get_fichier_ressource_fichier_themes($ressource);
    }
    if($type==1){
         return get_fichier_ressource_texte_themes($ressource);
    }
    if($type==5){
    	return get_fichier_scenario_themes($ressource);
    }
    if($type==59)
    	return get_fichier_scenario_dynamique_themes($ressource);
    print("Erreur: Le type sp�cifi� pour la fonction get_fichier_ressource_themes($ressource,$type) doit etre 1 ou 7");
    return null;
}

/**
	Enregistre un fichier icone
	@param string : libelle fichier
	@return integer/string : le numero ou libelle du fichier
*/
function set_fichier_icone($fichier){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_fichier_icone('$fichier')";
		$res=pg_query($sql);
		return pg_fetch_result($res,0,0);
	
	}
	else{
		// on retourne le nom du fichier sans l'extension
		$tab=explode(".",$fichier);
		return $tab[0];
	}
}

/**
 *   Enregistrer ou mettre a jour les m�tadonn�es d'un fichier
 *
 *   @param string $libelle Le nom du fichier
 *   @param integer $theme Le num�ro du th�me
 *   @param string $table le nom de la table
 *   @return integer : Le num�ro du nouveau fichier, 0 si erreur
 */
function set_fichier_metadata($id, $mot_cles,$individu) {
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_set_fichier_metadata($id, '$mot_cles',$individu)";
		echo "$sql";
		exit;
		$res=pg_query($sql);
	} else
		print ("set_fichier_metadata_old A IMPLEMENTER");
	return pg_fetch_result($res,0,0)=='t';
}

/**
*   R�cup�rer les diff�erents themes des fichiers ressources de la plate forme
*
*   Retourne les  th�mes ordonn�s alphab�tiquement pas leur nom
*
*    @return  integer : les themes des ressources de la plateforme
*
*/
function get_plateforme_themes_fichiers_ressources() {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_categorie_themes(43) as (id int4,libelle varchar)";
		$res = pg_query($sql);
	} else
		print ("get_plateforme_themes_fichiers_ressources_old A IMPLEMENTER");
	return $res;
}

/**
*	Obtenir les ressources associ�es a un theme
*
*	@param integer: le numero du theme desire
*	@return integer : l'entier resultat de la requete
*/
function get_theme_fichiers_ressources($theme) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_get_theme_ressources($theme) as (id int4,libelle varchar,fichier int4,mots_cles text)";
//		echo $req."<br>";
		$res = pg_query($req);
	} else
		$res = get_theme_ressources_old($theme);
	return $res;
}

function set_fichier_photo($photo_name){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_fichier_photo(".string2Sql($photo_name).")";
		$res=pg_query($sql);
		return pg_fetch_result($res,0,0);
	
	}
}

function del_fichier_db($fichier){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_fichier($fichier)";
		$res=pg_query($sql);
		return pg_fetch_result($res,0,0);
	
	}
}

/**
 * Obtenir les infos du type d'un fichier
 * @param integer type
 * @return integer : res req
 */
  function get_fichier_type($type){
 	$sql="select * from contraintes.af_get_fichier_type($type) as (id int4,libelle varchar,code varchar,categorie int4)";
 	$res=pg_query($sql);
 	return $res;
 }
 
?>
