<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * L'objet Filire est compos d'un id, un libell et d'un pre.
 * Il y a donc une filiation de Filires, sans ordre.
 * 
 * Une Filire est ncssaire pour la cration d'un Parcours. 
 * 
 * @package filiere
 */
class Filiere {

	/**
	* @var integer  Identifiant en base de donnes
	*/
	var $id;

	/**
	* @var string  Libell de la Filiere
	*/
	var $libelle;

	/**
	* @var integer  Numro de la Filiere pre. A null si pas de Filiere pre. 
	*/
	var $pere;

	/**
	* Constructeur de la classe Filiere
	*
	* On peut construire de deux faons. Soit on utilise le paramtre num pour rcuprer les valeurs de la Filiere
	* en base de donnes, sinon on construit une Filiere sans $id avec les deux autres paramtres
	*
	* @param integer $num_Filiere L'identifiant en base de donnes (utilis pour rcuprer les informations en base)
	* @param string $libelle_Filiere libelle de la Filiere
	* @param object Filiere $pere_Filiere numero de la filiere pre si sous-filire ou null si filire 
	*/
	function Filiere($num_Filiere = 0, $libelle_Filiere = "", $pere_Filiere = null) {
		// echo "Class Filiere : constructeur : $num_Filiere, $libelle_Filiere, $pere_Filiere<br>" ;

		// constructeur  partir d'un identifiant d'enregistrement en base de donnes (seul le numero doit tre pass)
		if (func_num_args()==1) {
			$result = get_filiere($num_Filiere);
			$row = pg_fetch_array($result);

			// On copie la ligne dans les attributs
			$this->id = $num_Filiere;
			$this->libelle = $row[1];

			// Si l'identifiant du pre est gal   0 ou NULL, alors l'attribut pre est vide
			if ($row[2] == 0 || $row[2] == "")
				$this->pere = "";
			else
				$this->pere = new Filiere($row[2]);
		}
		// constructeur avec des paramtres pour l'affectation des attributs
		else {
			// Faut-il verifier la cohrence des donnes envoyes ?
			$this->id = $num_Filiere;
			$this->libelle = $libelle_Filiere;
			$this->pere = $pere_Filiere;
		}
	}

	/**
	* Fonction qui insre un enregistrement en table classe et qui retourne l'identifiant de la ligne cre
	* On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne null
	* @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
	*/
	function insertToDB() {
		// Le libelle ne doit pas tre vide
		if (!empty($this->libelle)) {

			// Il ne peut y avoir deux Filieres du mme libelle au mme niveau ( la base ou avec le mme pre)
			$lib = addslashes($this->libelle);

			// Donne l'identifiant de la Filiere pre
			if (!empty($this->pere))
				$num_pere = $this->pere;
			else
				$num_pere = "NULL";

			if (!check_filiere($num_pere, $lib)) {
				$insertion = set_filiere($lib, $num_pere);
				return $insertion;
			} 
		}
		else
			print("Erreur sur les parametres de la fonction insertToDB()");
			
		return null;
	}

	/**
	* Fonction qui met  jour l'enregistrement en table filiere
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
	* @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
	*/
	function updateToDB() {
		if (!empty($this->id)) {
			
			$lib = addslashes($this->nom);
			$update = maj_filiere($this->id, $lib, $this->pere);

			// On retourne un boolen
			if ($update)
				return true;
		}
		else 
			print("Erreur sur les parametres de la fonction insertToDB()");
		
		return false;
		
	}

	/**
//	* Fonction qui retourne une chane de caractre contenant des informations sur l'objet
//	*
//	* Fonction qui retourne une chane de caractre contenant des informations sur l'objet.
//	* Si on ne passe aucun paramtre, la chane retourne contient le libelle. Par contre, si le paramtre est dfini,
//	* il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
//	* (Attention cela retourne un affichage seulement... toString("P") ne retourne pas l'objet pre !)
//	*
//	* @param string : le paramtre determine ce qu'on retourne. Les informations disponibles sont :
//	*       [libelle],[id],[pere] retourne le libelle du pre...
//	*
//	* @return string : On retourne la chane de caractres cre  partir du format
//	*/
//	function toString($format = "") {
//		// Aucun paramtre, on retourne le libelle
//		if ($format == "")
//			return $this->libelle;
//
//		// Si aucun pre, donner "Aucune filire de niveau superieur" ?
//
//		// Ce tableau contient tous les pattern et les nouvelles valeurs
//		$tab_replace = array (
//			"\[libelle\]" => $this->libelle,
//			"\[id\]" => $this->id,
//			"\[pere\]" => $this->pere->libelle
//		);
//
//		while ($tab = each($tab_replace)) {
//			$format = ereg_replace($tab[0], "$tab[1]", $format);
//		}
//		return $format;
//	}

	/**
	* Retourne la liste des formations de la filire
	*
	* @param string : "ASC" ou "DESC"
	* @param integer : si VRAI alors on ordonne les formations par date
	* @return integer : Rsultat de requete = {num_formation, libelle_formation, debut, fin}
	*/
	function getFormations($ordre = "ASC", $par_date = 'false') {
		if($par_date != "libelle")
			$par_date = 'true';
		else
			$par_date = 'false';
		return get_filiere_formations($this->id, $ordre, $par_date);
	}

	/**
	* Retourne la liste des parcours de la filire
	* @return integer retourne l'identifiant du parcours de la filiere.
	*/
	function getParcours() {
		return get_filiere_parcourss($this->id);
	}
	
	/**
	 * fonction qui retourne le nom de la filiere
	 * @return string retourne une chaine de caractere contenant le libelle de la filiere.
	 */
	function getLibelle(){
		return $this->libelle;
	}
	
	/**
	 * Fonction qui retourne l'id' de la filiere
	 * @return integer retourne l'identifiant base de donne de la filiere.
	 */
	function getId(){
		return $this->id;
	}
	
	/**
	 * Function qui retourne le nom du pere de la filiere slctionn
	 * @return integer retourne l'identifiant de la filiere pere.
	 */
	function getPere(){
		return $this->pere;
	}

}
?>