<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  Fonctions relatives aux fil�res.

  @package filiere
  @modulegroup fonctions
*/

/**
 * Savoir si une fil�re est utilis�e par un Parcours.
 * 
 * @param integer : numero de la filiere
 * @return bool : true si la filiere est utilis�e par un Parcours, false sinon.
 */
function is_filiere_utilise($filiere) {
	
	$respar =get_filiere_parcourss($filiere);
	if (pg_num_rows($respar) == 0&&!sql2Bool(fk_finder('filiere', 'id', $filiere))) {
		return false;
	} else
		return true;
}

/**
  Obtenir la couleur associ� � un niveau de filiere
  @param integer: niveau
  @return string: code couleur associ� au niveau, blanc(#FFFFFF) par d�faut.
*/
function get_filiere_niveau_couleur($niveau){
  if($niveau == 1)return("#999999");
  if($niveau == 2)return("#B3B3B3");
  if($niveau == 3)return("#CCCCCC");
  //retourne blanc au cas ou
  return("#FFFFFF");
}

/**
 * Obtenir le nom complet d'une fili�re en tenant compte de l'AMS
 * @param integer : filiere
 * @return string : le nom complet de la filiere
 */
function get_filiere_libelle_ams_complet($filiere){
	// recup le nom complet de la filiere
	$lib_fil=get_filiere_libelle_complet($filiere);
	// recup dans un tableau les chaines s�par�es par /
	$tab=array();
	$tab=explode("/",$lib_fil);
	$taille_tableau=count($tab);
	if($taille_tableau>1){
		$chaine="";
		for($i=0;$i<$taille_tableau;$i++){
			//$tmp_fil=get_ams_libelles($tab[$i]);
			//$chaine .=get_ams_libelle($tmp_fil);
			$chaine.=get_gui_libelle($tab[$i]);
			if($i>=0 &&$i<$taille_tableau -1)
				$chaine .="<b>/</b>";	
		}	
	}
	else{
		//$tmp_fil=get_ams_libelles($lib_fil);
		//$chaine=get_ams_libelle($tmp_fil);
		$chaine=get_gui_libelle($lib_fil);
	}
	return $chaine;
}
?>
