<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

  @package filiere
  @modulegroup plpgsql
  @module plpgsql_filiere
*/

/**
*   Enregistrer une nouvelle filiere. (OLD)
*
*   Effectue l'enregistrement seulement si le nom correspond aux crit�res de la fonction is_filiere_libelle_ok()
*
*   @param string: libelle de la filiere
*   @param integer : numero de la filiere pere

*   @return integer : numero de la nouvelle filiere , false si erreur
*/
function set_filiere_old($libelle, $pere) {
	if($pere=='NULL')$pere=0;
	$res = pg_query("insert into filiere (nom,id_pere)
				                                    values('$libelle',$pere)");
	$oid = pg_getlastoid($res);
	$res = pg_query("SELECT id  FROM filiere WHERE OID=$oid;");
	$nv_filiere = pg_result($res, 0, 0);

	return $nv_filiere;
}

/**
*   Enregistrer une nouvelle filiere.
*
*   Effectue l'enregistrement seulement si le nom correspond aux crit�res de la fonction is_filiere_libelle_ok().
*
*   @param string: libelle de la filiere
*   @param integer : numero de la filiere pere

*   @return integer : numero de la nouvelle filiere , false si erreur
*/
function set_filiere($libelle, $pere) {
	if (VERSION_BASE > VERSION) {
		$req = "SELECT  * FROM contraintes.af_set_filiere('$libelle', $pere);";
		//echo $req;
		$res = pg_query($req);
		$nv_filiere = pg_result($res, 0, 0);
	} else
		$nv_filiere = set_filiere_old($libelle, $pere);

	return $nv_filiere;
}

/**
*   Obtenir les informations concernant une filiere.(OLD)
*
*   @param integer : numero de la filiere
*   @return integer : identifiant resultat (id integer, libelle varchar, id_pere integer)
*/
function get_filiere_old($filiere) {
	$req = "select id, nom, id_pere from filiere  where id=$filiere;";
	//echo $req;
	$res = pg_query($req);
	return $res;
}

/**
*   Obtenir les informations concernant une filiere.
*
*   @param integer : numero de la filiere
*   @return integer : identifiant resultat (id integer, libelle varchar, pere integer)
*/
function get_filiere($filiere) {
	if (VERSION_BASE > VERSION) {
		$req = "SELECT * FROM contraintes.af_get_filiere($filiere)AS (id integer, libelle varchar, pere integer);";
		//echo $req;
		$res = pg_query($req);
	} else
		$res = get_filiere_old($filiere);

	return ($res);
}

/**
*   Mettre a jour le nom d'une filiere(OLD)
*   Effectue l'enregistrement seulement si le nom correspond aux crit�res de la fonction is_filiere_libelle_ok().
* 
*   @param integer : numero de la filiere
*   @param varchar : nouveau nom de la filiere
*   @param integer : numero de la filiere pere
*   @return integer : 1 si ok, false si ERREUR
*/
function maj_filiere_old($filiere, $nom, $pere) {
	if ($pere == 'NULL')
	$pere = 0;
	$req = "update filiere set nom='$nom',id_pere=$pere  where id=$filiere ";
	$ok = pg_query($req);
	return $ok;
}

/**
*   Mettre a jour le nom d'une filiere.
*
*
*   @param integer : numero de la filiere
*   @param varchar : nouveau nom de la filiere
*   @param integer : numero de la filiere pere
*   @return integer : true si ok, false si ERREUR
*/
function maj_filiere($filiere, $libelle, $pere) {
	
	if (VERSION_BASE > VERSION) {
		$req = "SELECT * FROM contraintes.af_maj_filiere($filiere, '$libelle', $pere) ;";
//		echo $req;
		$ok = pg_query($req);
		$ok = pg_result($ok, 0, 0);
	} else
		$ok = maj_filiere_old($filiere, $libelle, $pere);
	return $ok;
		
}

/**
* Obtenir les formations d'une filiere (OLD)
*
* @param integer : num�ro de filiere
* @param string : ASC ou DESC pour le classement du resultat
* @param bool : si �gal � 'TRUE' alors on ordonne par les dates de debuts de formation et non pas par leurs libell�s.
* 
* @return integer : identifiant resultat (id integer, libelle varchar, debut date, fin date)
*/
function get_filiere_formations_old($filiere, $classement = "ASC", $par_date = 'FALSE') {
	$req = "SELECT DISTINCT num_cal AS num_formation, nom_cal AS nom_formation, d1.jour AS debut, d2.jour AS fin, g_num_gest_c
			    FROM calendrier, gestionnaire, dates d1, dates d2
			    WHERE g_num_cal=num_cal
			    AND g_num_gest_c=$num_filiere
			    AND datedeb = d1.num_date
			    AND datefin = d2.num_date
			    ORDER by ";
	$req="select distinct num_cal,nom_cal,g_num_parcours,d1.jour as debut,d2.jour as fin,langue,g_num_gest_c
				FROM calendrier, gestionnaire, dates d1, dates d2 
				WHERE g_num_cal=num_cal
			    AND g_num_gest_c=$filiere
			    AND datedeb = d1.num_date
			    AND datefin = d2.num_date
			    ORDER by ";
	if ($par_date=='TRUE')
		$req .= "debut $classement";
	else
		$req .= "nom_cal $classement";

	$formations = pg_query($req);

	return $formations;
}

/**
* Obtenir les formations d'une filiere (OLD)
*
* @param integer : num�ro de filiere
* @param string : ASC ou DESC pour le classement du resultat
* @param integer : si �gal � 'TRUE' alors on ordonne par les dates de debuts de formation et non pas par leurs libell�s.
* 
* @return integer : identifiant resultat (id integer, libelle varchar, debut date, fin date)
*/
function get_filiere_formations($filiere, $classement = 'asc', $par_date = 'false') {
	if (VERSION_BASE > VERSION) {
		global $auth;
		$user_id=$auth->getUserId();
//		if($par_date==0)	
//			$par_date="false";
//		else
//			$par_date="true";
//		
		$req = "SELECT * FROM contraintes.af_get_filiere_formations($filiere, '$classement', $par_date,$user_id) AS (id int4, libelle varchar, parcours int4,debut date, fin date, langue int4,filiere int4) ;";
		//echo"req = $req";
		$formations = pg_query($req);
	} else
		$formations = get_filiere_formations_old($filiere, $classement, $par_date);

	return $formations;
}

/**
* Obtenir les parcours qui utilisent une filiere (OLD)
*
* @param integer : num�ro de filiere
* @return integer : identifiant resultat (id integer, libelle varchar , filiere int4 )
*/
function get_filiere_parcourss_old($filiere,$desc="") {
	if($desc=='DESC')$ordre=" DESC";
	else $ordre="";
	$req = "SELECT DISTINCT g_num_parcours,nom_parcours,num_c_q_e_d, affiche_fo
			    FROM gestparcours,parcours
			    WHERE num_etape='1' AND num_c_q_e_d='$filiere'
			    AND g_num_parcours=num_parcours
			    ORDER BY nom_parcours $ordre";
	echo "$req<br>";
	$parcours = pg_query($req);

	return $parcours;
}

/**
* Obtenir les parcours qui utilisent une filiere 
*
* @param integer : num�ro de filiere
* @return integer : identifiant resultat (id integer, libelle varchar, filiere int4 )
*/
function get_filiere_parcourss($filiere,$desc="") {
	if (VERSION_BASE > VERSION) {
		if($desc=='DESC')$ordre=" ORDER BY libelle DESC";
    	else $ordre="";
		$req = "SELECT * FROM  contraintes.af_get_filiere_parcourss($filiere)
				                AS (id integer, libelle varchar, filiere int4 , duree bool) ;";
		//echo "$req<br>";
		$parcours = pg_query($req);
	} else
		$parcours = get_filiere_parcourss_old($filiere);

	return $parcours;
}

/**
*   V�rifier si un nom de filiere est unique pour un meme pere et s'il ne contient pas de caract�re '/'.  (OLD)
*
*   @param integer : numero de la filiere pere
*   @param string :  libelle de la filiere
*   @return integre : false si existe deja ou contient '/', true si ok
*/
function is_filiere_libelle_ok_old($pere, $libelle) {
	if ($pere == 'NULL')
		$pere = 0;
		
	//le caractere '/' est interdit
	if (strchr($libelle, '/'))
		return "f";
		
	$req = "select * from filiere where id_pere=$pere and nom like '$libelle';";
	$res = pg_query($req);
	if (pg_num_rows($res) == 0)
		return "t";
	else
		return "f";
}

/**
*   V�rifier si un nom de filiere est unique pour un meme pere et s'il ne contient pas de caract�re '/'. 
*
*   @param integer : numero de la filiere pere
*   @param string :  libelle de la filiere
*   @return integre : false si existe deja ou contient '/', true si ok
*/
function is_filiere_libelle_ok($pere, $nomfiliere) {

	if (VERSION_BASE > VERSION) {
		$req = "SELECT * FROM contraintes.af_is_filiere_libelle_ok($pere, '$nomfiliere');";
//		echo $req;
		$res = pg_query($req);
		$res = pg_result($res, 0, 0);
	} else
		$res = is_filiere_libelle_ok_old($pere, $nomfiliere);

	return ($res);
}

/**
*   Obtenir les sous fili�res d'une fili�re (OLD)
* 	
* 	Retourne les fil�res qui ont pour p�re l'identifiant en parametre.
*	Si le num�ro de fili�re est �gal � 0 ou 'NULL' (pas de p�res), retoune les Fili�res et non les sous fili�res.
* 	
* 	Les filieres sont ordonn�es par libell�s.
* 
*   @param integer : numero de la fil�re .
*   @return integer : l'entier r�sultat de la requete (id int4,nom varchar,id_pere int4)
*/
function get_filiere_sous_filieres_old($filiere) {
	if ($filiere == 'NULL')
		$filiere = 0;
	$sql = "select * from filiere where id_pere=$filiere order by nom";
	$res = pg_query($sql);
	return $res;
}

/**
*   Obtenir les sous fili�res d'une fili�re 
* 
* 	Retourne les fil�res qui ont pour p�re l'identifiant en parametre.
*	Si le num�ro de fili�re est �gal 'NULL' (pas de p�res), retoune les Fili�res et non les sous fili�res.
* 	
* 	Les filieres sont ordonn�es par libell�s.
* 
*   @param integer : numero de la fil�re .
*   @return integer : l'entier r�sultat de la requete (id int4,nom varchar,id_pere int4)
*/
function get_filiere_sous_filieres($filiere) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_filiere_sous_filieres($filiere) as (id int4,nom varchar,id_pere int4)";
		//echo $sql;
		$res = pg_query($sql);

	} else
		$res = get_filiere_sous_filieres_old($filiere);
	return $res;
}

/**
*   Obtenir le niveau d'une filiere (OLD)
*
*   Une filiere qui n'a pas de p�re  est de niveau 1.
*
*   @param integer : numero de la filiere
*   @return integer : niveau de la filiere
*/
function get_filiere_niveau_old($filiere) {

	$parent = $filiere;
	while ($parent <> 0) {
		$res = pg_query("select * from filiere where id='$parent';");
		$row = pg_fetch_row($res, 0);
		$tab[] = $row[1];
		$parent = $row[2];
	}
	$niv = sizeof($tab);
	return $niv;
}

/**
*   Obtenir le niveau d'une filiere
*
*   Une filiere qui n'a pas de p�re  est de niveau 1.
*
*   @param integer : numero de la filiere
*   @return integer : niveau de la filiere
*/
function get_filiere_niveau($filiere) {

	if (VERSION_BASE > VERSION) {
		//$req="select   _af_get_niveau_filiere($filiere)";
		$req = "SELECT * FROM contraintes.af_gen_get_element_niveau('contraintes.filiere','id',$filiere,'',0)";
		//echo $req;
		$res = pg_query($req);
		$res = pg_result($res, 0, 0);
	} else
		$res = get_filiere_niveau_old($filiere);

	return ($res);
}

/**
*   Obtenir le libelle complet d'une filiere (OLD)
*
*	Le libelle de la filiere est retourn� pr�c�d� des libelles de ses filieres peres,
*	c'est a dire sous la forme:
*	libelle_filiere_pere_pere/libelle_filiere_pere/libelle_filiere
*   @param integer : numero de la filiere dont on veut le libelle.
*   @return string :  la chaine contenant le libelle de la filiere
*/
function get_filiere_libelle_complet_old($filiere) {
	$parent = $filiere;
	$tab1 = array ();
	//echo "parent=$parent<br>";
	while ($parent <> 0) {
		$req = "select * from filiere where id=$parent ;";
		$res = pg_query($req);
		$row = pg_fetch_row($res, 0);
		$tab[] = $row[1];
		$parent = $row[2];
	}
	//print_r($tab);
	$tab1 = array_reverse($tab, TRUE);
	return (implode("/", $tab1));

}

/**
*   Obtenir le libelle complet d'une filiere 
*
*	Le libelle de la filiere est retourn� pr�c�d� des libelles de ses filieres peres,
*	c'est a dire sous la forme:
*	libelle_filiere_pere_pere/libelle_filiere_pere/libelle_filiere
*   @param integer : numero de la filiere dont on veut le libelle.
*   @return string :  la chaine contenant le libelle de la filiere
*/
function get_filiere_libelle_complet($filiere) {

	if (VERSION_BASE > VERSION) {
		$req = "SELECT * FROM contraintes.af_get_filiere_libelle_complet($filiere)";
		//echo $req;
		$res = pg_query($req);
		$res = pg_result($res, 0, 0);
	} else
		$res = get_filiere_libelle_complet_old($filiere);

	return ($res);
}

/**
*   Supprimer une filiere et ses sous fili�res (OLD)
*
*   @param integer : numero de la filiere � supprimer
*   @return integer : true ou false selon que la suppression se soit correctement effectu�e ou non.
*/
function del_filiere_old($filiere) {

	//suppression du pere courant
	$del = pg_query("delete from filiere where id=$filiere;");

	//recup de ses fils
	$res = pg_query("select * from filiere where id_pere=$filiere;");
	while ($row = pg_fetch_array($res)) {
		$filiere = $row["id"];
		del_filiere_old($filiere);
	}
	return $del;
}

/**
*   Supprimer une filiere et ses sous fili�res (OLD)
*
*   @param integer : numero de la filiere � supprimer
*   @return integer : true ou false selon que la suppression se soit correctement effectu�e ou non.
*/
function del_filiere($filiere) {

	if (VERSION_BASE > VERSION) {
		$req = "SELECT * FROM contraintes.af_del_filiere($filiere)";
		//echo $req;
		$res = pg_query($req);
		$res = pg_result($res, 0, 0);
	} else
		$res = del_filiere_old($filiere);

	return ($res);
}
?>