<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
Class Formateur hrite d'individu

La connexion  la base de donnes doit tre $db

@author CHABOISSIER Jonathan <jc@afide.fr>
@since 24/05/2004

@package formateur
*/
class Formateur extends Individu
{
	
		function Formateur($num=0, $log="" , $passwd="" , $name="" , $pre="" , $cate="", $adr="" , $cod="" , $vil="" ,
                $mail="" , $fix="" , $port="" , $lang="" , $orga="" , $fic=""){
        	if(func_num_args()==0)return parent::Individu();
        	elseif(func_num_args()==1)return parent::Individu($num);
        	else return parent::Individu($num, $log , $passwd , $name , $pre, $cate, $adr , $cod , $vil,
                $mail , $fix , $port , $lang , $orga , $fic);
        	
        }
        /**
        * Fonction qui donne le nombre de formations
        *
        * Cette fonction appel une fonction dfinie dans plpgsql_formateur.inc et qui utilise une fonction PL/SQL
        * @return integer : le nombre de classes
        */
        function getNbClasses()
        {
                // echo "Class Formateur : getNbClasses<br>";
                return (get_nb_classes($this->id)) ;
        }

        /**
        *  Les formations dont le formateur est reponsable
        *
        * Cette fonction qui porte le mme nom qu'une des mthode de la class Individu ne fait que
        * donner les formations dont le formateurs est responsable.
        * Si on utilise un objet Formateur et qu'on veut toutes ses formations, il faut faire un cast :
        * (Individu) $monForm... Autrement, la mthode getAllFormations appelle directement la mthode
        * originale
        *
        * @param string : DESC ou ASC pour le tri decroissant ou croissant (par dfaut ASC) pour le premier champ
        * @param integer : Numero du champ sur lequel on trie en premier (0=nom_cal,1 ou 2=debut,3=nom_groupe)
        * par dfaut on met ce paramtre  1 pour que la classement se fasse par nom_cal.
        * Si on utilise le paramtre periode alors si ce paramtre est gal  1 alors on classe par groupe, sinon on classe
        * par calendrier. Remarque : d'autre mthode getFormations (dans les autres classes) ont un prototype getFormations(ordre="ASC", chrono=0)
        * Je fais un traitement sur le paramtre classement1 pour qu'on puisse utiliser cette mthode getFormations de la mme faon que dans les autres classes.
        * @param string : DESC ou ASC pour le tri decroissant ou croissant (par dfaut ASC) pour le second champs
        * @param integer : Numero du champ sur lequel on trie en second (1=nom_cal,2=debut,3=nom_groupe)
        *
        * @return integer : liste d'enregistrements {num_formation, nom_formation, debut, fin, langue, num_groupe, nom_groupe}
        */
        function getFormations($classement="ASC", $ordre="date_debut",  $periode=0)
        {
                 

                 return get_formateur_formations($this->id, $classement, $ordre, $periode) ;
        }
        // -----------------------------------------------------------------------fin getFormations($ordre1, $classement1,  $ordre2, $classement2)

        /**
        *  Les formations d'une periode donne dont le formateur est reponsable
        * @param integer : la priode concerne ( 1 = pass ; 2 = prsent ; 3 = futur)
        * @param string : DESC ou ASC pour le tri decroissant ou croissant (par dfaut ASC) pour le premier champ
        * @param integer : Numero du champ sur lequel on trie en premier (1=nom_cal,2=debut,3=nom_groupe)
        * Par dfaut on met ce paramtre  1 pour que la classement se fasse par nom_formation.
        * @return integer : liste d'enregistrements {num_formation, nom_formation, debut, fin, langue, num_groupe, nom_groupe}
        */
        function getFormationsPeriode($periode, $ordre="ASC", $classement="libelle")
        {
                return get_formations_formateur_periode($this->id, $classement, $ordre, $periode) ;
        }
        // -----------------------------------------------------------------------fin getFormationsPeriode($periode, $ordre, $classement)

        /**
        * Cette mthode appel la mthode getFormations() de la classe individu
        * @param string $classement classement ASC ou DESC
        * @param integer $ordre_chrono 1 si on dsire un classement par ordre chronologique
        * @return integer : tableau associatif contenant des informations aux cases : "num_cal" "nom_cal" etc.
        */
        function getAllFormations($classement="ASC", $ordre_chrono=0)
        {
                // On utilise la mthode de la classe Individu
                return parent::getFormations($this->id, $classement, $ordre_chrono);
        }
        // ------------------------------------------------------------------------------------------------------------------- fin getAllFormations()
}
?>